/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.traitextender.ExtensionFactory;
import org.alfresco.traitextender.Trait;

public class ExtendedTrait<T extends Trait> {
    private ConcurrentHashMap<Class<?>, Object> extensions = new ConcurrentHashMap();
    private T trait;

    public ExtendedTrait(T trait) {
        this.trait = trait;
    }

    public T getTrait() {
        return this.trait;
    }

    public <E> E getExtension(Class<E> extensionAPI) {
        Object extension = this.extensions.get(extensionAPI);
        return (E)extension;
    }

    public synchronized <E> E extend(Class<E> extensionAPI, ExtensionFactory<E> factory) {
        Object extension = this.extensions.get(extensionAPI);
        if (extension == null) {
            extension = factory.createExtension(this.trait);
            this.extensions.put(extensionAPI, extension);
        }
        return (E)extension;
    }
}

