/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.workflow.WorkflowNodeConverter;
import org.alfresco.repo.workflow.WorkflowPropertyHandler;
import org.alfresco.repo.workflow.WorkflowPropertyHandlerRegistry;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.QName;

public abstract class AbstractWorkflowPropertyHandler
implements WorkflowPropertyHandler {
    private static final String ERR_SET_TASK_PROPS_INVALID_VALUE = "activiti.engine.set.task.properties.invalid.value";
    private static final TypeConverter typeConverter = DefaultTypeConverter.INSTANCE;
    protected WorkflowNodeConverter nodeConverter;
    protected MessageService messageService;

    protected Object handleAssociation(Serializable value, AssociationDefinition assocDef) {
        if (assocDef.isProtected()) {
            return "*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*";
        }
        return this.convertAssociationValue(assocDef, value);
    }

    protected Object handleProperty(Serializable value, PropertyDefinition propDef) {
        if (propDef.isProtected()) {
            return "*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*";
        }
        return this.convertPropertyValue(propDef, value);
    }

    protected Object convertPropertyValue(PropertyDefinition propDef, Serializable value) {
        Object newValue = value;
        newValue = value instanceof Collection ? typeConverter.convert(propDef.getDataType(), (Collection)((Object)value)) : typeConverter.convert(propDef.getDataType(), (Object)value);
        DataTypeDefinition dataTypeDef = propDef.getDataType();
        if (dataTypeDef.getName().equals((Object)DataTypeDefinition.NODE_REF)) {
            newValue = this.nodeConverter.convertNodes(newValue, propDef.isMultiValued());
        }
        return newValue;
    }

    protected Object convertAssociationValue(AssociationDefinition assocDef, Serializable value) {
        return this.nodeConverter.convertNodes(value, assocDef.isTargetMany());
    }

    protected WorkflowException getInvalidPropertyValueException(QName key, Object value) {
        String msg = this.messageService.getMessage(ERR_SET_TASK_PROPS_INVALID_VALUE, new Object[]{value, key});
        return new WorkflowException(msg);
    }

    public void setRegistry(WorkflowPropertyHandlerRegistry registry) {
        QName key = this.getKey();
        if (key != null) {
            registry.registerHandler(key, this);
        }
    }

    public void setNodeConverter(WorkflowNodeConverter nodeConverter) {
        this.nodeConverter = nodeConverter;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    protected abstract QName getKey();

    protected void checkType(QName key, Object value, Class<?> type) {
        if (value != null && !type.isAssignableFrom(value.getClass())) {
            throw this.getInvalidPropertyValueException(key, value);
        }
    }

    protected Object handleDefaultProperty(Object task, TypeDefinition type, QName key, Serializable value) {
        PropertyDefinition propDef = (PropertyDefinition)type.getProperties().get(key);
        if (propDef != null) {
            return this.handleProperty(value, propDef);
        }
        AssociationDefinition assocDef = (AssociationDefinition)type.getAssociations().get(key);
        if (assocDef != null) {
            return this.handleAssociation(value, assocDef);
        }
        if (value instanceof NodeRef) {
            return this.nodeConverter.convertNode((NodeRef)value, false);
        }
        return value;
    }
}

