/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryAtMostRule
implements TestRule {
    private static final Log LOG = LogFactory.getLog(RetryAtMostRule.class);

    public Statement apply(Statement statement, Description description) {
        RetryAtMost retryAtMost = (RetryAtMost)description.getAnnotation(RetryAtMost.class);
        if (retryAtMost != null) {
            return new RetryAtMostTestStatement(statement, description, retryAtMost.value());
        }
        return statement;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface RetryAtMost {
        public int value() default 1;
    }

    private static class RetryAtMostTestStatement
    extends Statement {
        private final Statement statement;
        private final Description description;
        private final int retryCount;

        private RetryAtMostTestStatement(Statement statement, Description description, int retryCount) {
            this.statement = statement;
            this.description = description;
            this.retryCount = retryCount;
        }

        public void evaluate() throws Throwable {
            this.validate();
            int i = 0;
            while (i < this.retryCount) {
                try {
                    LOG.debug((Object)("Retryable testing configured for method: " + this.description.getMethodName() + " // Attempt #" + (i + 1)));
                    this.statement.evaluate();
                    break;
                }
                catch (Throwable t) {
                    if (this.isLastExecution(i)) {
                        throw t;
                    }
                    ++i;
                }
            }
        }

        private void validate() {
            if (this.retryCount < 1) {
                String methodName = this.description.getMethodName();
                throw new IllegalArgumentException("Invalid value for @RetryAtMost on method " + methodName + ": " + this.retryCount + " is less than 1.");
            }
        }

        private boolean isLastExecution(int i) {
            return i == this.retryCount - 1;
        }
    }
}

