/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extender;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.ExtensionBundle;
import org.alfresco.traitextender.ExtensionFactory;
import org.alfresco.traitextender.ExtensionPoint;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.traitextender.Trait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtenderImpl
extends Extender {
    private static Log logger = LogFactory.getLog(Extender.class);
    private List<ExtensionBundle> bundles = new LinkedList<ExtensionBundle>();
    private Map<ExtensionPoint<?, ?>, ExtensionFactory<?>> pointFactories = new ConcurrentHashMap();

    @Override
    public synchronized void start(ExtensionBundle bundle) {
        this.bundles.add(bundle);
        bundle.start(this);
    }

    @Override
    public void stop(ExtensionBundle bundle) {
        bundle.stop(this);
        this.bundles.remove(bundle);
    }

    @Override
    public synchronized void stopAll() {
        LinkedList<ExtensionBundle> bundlesCopy = new LinkedList<ExtensionBundle>(this.bundles);
        for (ExtensionBundle bundle : bundlesCopy) {
            this.stop(bundle);
        }
    }

    @Override
    public synchronized <E, M extends Trait> E getExtension(Extensible anExtensible, ExtensionPoint<E, M> point) {
        ExtendedTrait<M> exTrait;
        E extension = null;
        ExtensionFactory<?> factory = this.pointFactories.get(point);
        if (factory != null && (extension = (E)(exTrait = anExtensible.getTrait(point.getTraitAPI())).getExtension(point.getExtensionAPI())) == null) {
            extension = exTrait.extend(point.getExtensionAPI(), factory);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("trait extension leak trace : " + System.identityHashCode(extension) + " : " + System.identityHashCode(exTrait) + " : " + System.identityHashCode(extension)));
            }
        }
        return extension;
    }

    @Override
    public synchronized void register(ExtensionPoint<?, ?> point, ExtensionFactory<?> factory) {
        if (!factory.canCreateExtensionFor(point)) {
            throw new InvalidExtension("Invalid extension factory registry entry : " + String.valueOf(point) + "->" + String.valueOf(factory));
        }
        this.pointFactories.put(point, factory);
    }

    @Override
    public synchronized void unregister(ExtensionPoint<?, ?> point) {
        this.pointFactories.remove(point);
    }
}

