/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.VirtualQuery;

public class VirtualFolderDefinition {
    private String name;
    private String description;
    private FilingRule filingRule;
    private VirtualQuery query;
    private List<VirtualFolderDefinition> children = new LinkedList<VirtualFolderDefinition>();
    private Map<String, VirtualFolderDefinition> childrenByName = new HashMap<String, VirtualFolderDefinition>();
    private Map<String, VirtualFolderDefinition> childrenById = new HashMap<String, VirtualFolderDefinition>();
    private String id;
    private Map<String, String> properties = new HashMap<String, String>();

    public VirtualFolderDefinition() {
        this("");
    }

    public VirtualFolderDefinition(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.id == null) {
            this.id = name;
        }
    }

    public void setId(String id) {
        this.id = id;
        if (this.name == null) {
            this.name = id;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FilingRule getFilingRule() {
        return this.filingRule;
    }

    public void setFilingRule(FilingRule filingRule) {
        this.filingRule = filingRule;
    }

    public VirtualQuery getQuery() {
        return this.query;
    }

    public void setQuery(VirtualQuery query) {
        this.query = query;
    }

    public VirtualFolderDefinition findChildByName(String name) {
        return this.childrenByName.get(name);
    }

    public List<VirtualFolderDefinition> getChildren() {
        return this.children;
    }

    public void addChild(VirtualFolderDefinition child) {
        this.children.add(child);
        this.childrenByName.put(child.getName(), child);
        this.childrenById.put(child.getId(), child);
    }

    public VirtualFolderDefinition findChildById(String childId) {
        return this.childrenById.get(childId);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

