/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.configuration;

import java.util.List;
import org.alfresco.model.ApplicationModel;
import org.alfresco.repo.configuration.ConfigurableService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class ConfigurableServiceImpl
implements ConfigurableService {
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public boolean isConfigurable(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ApplicationModel.ASPECT_CONFIGURABLE);
    }

    @Override
    public void makeConfigurable(NodeRef nodeRef) {
        if (!this.isConfigurable(nodeRef)) {
            this.nodeService.addAspect(nodeRef, ApplicationModel.ASPECT_CONFIGURABLE, null);
            this.nodeService.createNode(nodeRef, ApplicationModel.ASSOC_CONFIGURATIONS, ApplicationModel.ASSOC_CONFIGURATIONS, ApplicationModel.TYPE_CONFIGURATIONS);
        }
    }

    @Override
    public NodeRef getConfigurationFolder(NodeRef nodeRef) {
        List assocs;
        NodeRef result = null;
        if (this.isConfigurable(nodeRef) && (assocs = this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ApplicationModel.ASSOC_CONFIGURATIONS)).size() != 0) {
            ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(0);
            result = assoc.getChildRef();
        }
        return result;
    }
}

