/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.filesys.repo.BufferedWrite;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MSOfficeContentNetworkFile
extends ContentNetworkFile {
    private static final Log logger = LogFactory.getLog(MSOfficeContentNetworkFile.class);
    private int m_readCnt;
    private List<BufferedWrite> m_writeList = new ArrayList<BufferedWrite>();

    protected MSOfficeContentNetworkFile(NodeService nodeService, ContentService contentService, MimetypeService mimetypeService, NodeRef nodeRef, String name) {
        super(nodeService, contentService, mimetypeService, nodeRef, name);
    }

    public final int getReadCount() {
        return this.m_readCnt;
    }

    @Override
    public int readFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        ++this.m_readCnt;
        return super.readFile(buffer, length, position, fileOffset);
    }

    @Override
    public void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        if (this.m_writeList != null) {
            if (this.getReadCount() > 0 && this.m_writeList.size() < 2) {
                if (length != 0) {
                    byte[] data = new byte[length];
                    System.arraycopy(buffer, position, data, 0, length);
                    BufferedWrite bufWrite = new BufferedWrite(data, fileOffset);
                    this.m_writeList.add(bufWrite);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("MSOfficeFile: Buffered write=" + String.valueOf(bufWrite) + ", cnt=" + this.m_writeList.size() + ", readCnt=" + this.getReadCount()));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"MSOfficeFile: Ignored zero length write");
                }
                return;
            }
            if (this.m_writeList.size() > 0) {
                while (this.m_writeList.size() > 0) {
                    BufferedWrite bufWrite = this.m_writeList.remove(0);
                    try {
                        super.writeFile(bufWrite.getData(), bufWrite.getDataLength(), 0, bufWrite.getOffset());
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("MSOfficeFile: Buffered write error, " + ex.getMessage()));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"MSOfficeFile: Buffered writes flushed");
                }
                this.m_writeList = null;
            }
        }
        super.writeFile(buffer, length, position, fileOffset);
    }

    @Override
    public void closeFile() throws IOException {
        if (logger.isDebugEnabled() && this.m_writeList != null) {
            logger.debug((Object)("MSOfficeFile: Discarded buffered writes - " + this.m_writeList.size()));
        }
        super.closeFile();
    }
}

