/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.service.StoreRedirector;
import org.alfresco.service.ServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public class StoreRedirectorProxyFactory<I>
implements FactoryBean,
InitializingBean {
    private static final Log logger = LogFactory.getLog(StoreRedirectorProxyFactory.class);
    private Class<I> proxyInterface = null;
    private I defaultBinding = null;
    private Map<String, I> redirectedProtocolBindings = null;
    private Map<StoreRef, I> redirectedStoreBindings = null;
    private I redirectorProxy = null;

    public void setProxyInterface(Class<I> proxyInterface) {
        this.proxyInterface = proxyInterface;
    }

    public void setDefaultBinding(I defaultBinding) {
        this.defaultBinding = defaultBinding;
    }

    public void setRedirectedProtocolBindings(Map<String, I> protocolBindings) {
        if (protocolBindings != null) {
            this.redirectedProtocolBindings = Collections.unmodifiableMap(protocolBindings);
        } else {
            logger.warn((Object)"Null map injected");
            this.redirectedProtocolBindings = protocolBindings;
        }
    }

    public void setRedirectedStoreBindings(Map<String, I> storeBindings) {
        HashMap<StoreRef, I> redirectedStoreBindingsMap = new HashMap<StoreRef, I>(storeBindings.size());
        for (String ref : storeBindings.keySet()) {
            redirectedStoreBindingsMap.put(new StoreRef(ref), storeBindings.get(ref));
        }
        this.redirectedStoreBindings = Collections.unmodifiableMap(redirectedStoreBindingsMap);
    }

    public void afterPropertiesSet() throws ServiceException {
        ParameterCheck.mandatory((String)"Proxy Interface", this.proxyInterface);
        ParameterCheck.mandatory((String)"Default Binding", this.defaultBinding);
        this.redirectorProxy = Proxy.newProxyInstance(this.proxyInterface.getClassLoader(), new Class[]{this.proxyInterface, StoreRedirector.class}, (InvocationHandler)new RedirectorInvocationHandler());
    }

    public I getObject() {
        return this.redirectorProxy;
    }

    public Class getObjectType() {
        return this.proxyInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    class RedirectorInvocationHandler
    implements InvocationHandler,
    StoreRedirector {
        RedirectorInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(StoreRedirector.class)) {
                return method.invoke((Object)this, args);
            }
            Object binding = null;
            StoreRef storeRef = this.getStoreRef(method.getParameterTypes(), args);
            if (storeRef == null) {
                binding = StoreRedirectorProxyFactory.this.defaultBinding;
            } else {
                if (StoreRedirectorProxyFactory.this.redirectedStoreBindings != null) {
                    binding = StoreRedirectorProxyFactory.this.redirectedStoreBindings.get(storeRef);
                }
                if (binding == null && StoreRedirectorProxyFactory.this.redirectedProtocolBindings != null) {
                    binding = StoreRedirectorProxyFactory.this.redirectedProtocolBindings.get(storeRef.getProtocol());
                }
                if (binding == null) {
                    binding = StoreRedirectorProxyFactory.this.defaultBinding;
                }
                if (binding == null) {
                    throw new ServiceException("Store type " + String.valueOf(storeRef) + " is not supported");
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Redirecting method " + String.valueOf(method) + " based on store type " + String.valueOf(storeRef)));
            }
            try {
                return method.invoke(binding, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private StoreRef getStoreRef(Class[] argTypes, Object[] args) {
            StoreRef storeRef = null;
            if (args == null) {
                return null;
            }
            int i = 0;
            while (i < argTypes.length) {
                StoreRef argStoreRef = null;
                if (argTypes[i].equals(NodeRef.class)) {
                    if (args[i] != null) {
                        argStoreRef = ((NodeRef)args[i]).getStoreRef();
                    }
                } else if (argTypes[i].equals(StoreRef.class)) {
                    argStoreRef = (StoreRef)args[i];
                }
                if (argStoreRef != null) {
                    return argStoreRef;
                }
                ++i;
            }
            return storeRef;
        }

        @Override
        public Collection<String> getSupportedStoreProtocols() {
            return Collections.unmodifiableCollection(StoreRedirectorProxyFactory.this.redirectedProtocolBindings.keySet());
        }

        @Override
        public Collection<StoreRef> getSupportedStores() {
            return Collections.unmodifiableCollection(StoreRedirectorProxyFactory.this.redirectedStoreBindings.keySet());
        }
    }
}

