/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.Oracle9Dialect;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.validator.IndexColumnsValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexColumnsValidatorTest {
    private IndexColumnsValidator validator;
    private DiffContext ctx;
    private Results validationResults;

    @Before
    public void setUp() throws Exception {
        this.validator = new IndexColumnsValidator();
        this.validationResults = new Results();
        this.ctx = new DiffContext((Dialect)new Oracle9Dialect(), this.validationResults, null, null);
    }

    @Test
    public void testNonIndex() {
        this.validator.setPattern(Pattern.compile("SYS_NC.+"));
        Assert.assertEquals((Object)"SYS_NC.+", (Object)this.validator.getPattern().toString());
        try {
            this.validator.validate(null, (DbObject)new Table("SYS_NC234234"), this.ctx);
            Assert.fail((String)"Validator should faile for non-index object");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    @Test
    public void testAllOk() {
        this.validator.setPattern(Pattern.compile("SYS_NC.+"));
        Assert.assertEquals((Object)"SYS_NC.+", (Object)this.validator.getPattern().toString());
        this.validator.validate((DbObject)this.indexForColumns("SYS_NC234234", "SYS_NC654123"), (DbObject)this.indexForColumns("SYS_NC123123", "SYS_NC225588"), this.ctx);
        Assert.assertEquals((long)0L, (long)this.validationResults.size());
    }

    @Test
    public void testNotValid() {
        this.validator.setPattern(Pattern.compile("SYS_NC.+"));
        Assert.assertEquals((Object)"SYS_NC.+", (Object)this.validator.getPattern().toString());
        Index target = this.indexForColumns("TEST_INDEX1", "SYS_NC892345", "MY_INDEX");
        this.validator.validate((DbObject)this.indexForColumns("SYS_NC234234", "SYS_NC654123"), (DbObject)target, this.ctx);
        Assert.assertEquals((long)3L, (long)this.validationResults.size());
        Assert.assertEquals((Object)"TEST_INDEX1", (Object)((ValidationResult)this.validationResults.get(0)).getValue());
        Assert.assertEquals((Object)"MY_INDEX", (Object)((ValidationResult)this.validationResults.get(1)).getValue());
        Assert.assertEquals((Object)target.getColumnNames(), (Object)((ValidationResult)this.validationResults.get(2)).getValue());
    }

    private Index indexForColumns(String ... names) {
        return new Index(null, null, Arrays.asList(names));
    }
}

