/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.properties;

import java.io.Serializable;
import org.activiti.engine.task.Task;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPriorityPropertyHandler;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivitiPriorityPropertyHandlerTest {
    private static ActivitiPriorityPropertyHandler handler;
    @Mock
    private Task task;
    private TypeDefinition type = null;
    private QName key = null;

    @BeforeClass
    public static void setUp() {
        handler = new ActivitiPriorityPropertyHandler();
        MessageService messageService = (MessageService)Mockito.mock(MessageService.class);
        handler.setMessageService(messageService);
    }

    @Test
    public void handleTaskPropertySetsValidIntPriority() {
        int priority = 1;
        while (priority <= 3) {
            Object result = handler.handleTaskProperty(this.task, this.type, this.key, (Serializable)Integer.valueOf(priority));
            Assert.assertEquals((Object)"*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*", (Object)result);
            ((Task)Mockito.verify((Object)this.task)).setPriority(priority);
            ++priority;
        }
    }

    @Test
    public void handleTaskPropertySetsValidStringPriority() {
        int priority = 1;
        while (priority <= 3) {
            Object result = handler.handleTaskProperty(this.task, this.type, this.key, (Serializable)((Object)("" + priority)));
            Assert.assertEquals((Object)"*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*", (Object)result);
            ((Task)Mockito.verify((Object)this.task)).setPriority(priority);
            ++priority;
        }
    }

    @Test(expected=WorkflowException.class)
    public void handleTaskPropertyDoesNotSetInvalidStringPriority() {
        String priority = "Not an integer";
        handler.handleTaskProperty(this.task, this.type, this.key, (Serializable)((Object)priority));
        Assert.fail((String)"The method should throw an exception and not reach here.");
    }

    @Test(expected=WorkflowException.class)
    public void handleTaskPropertyDoesNotSetInvalidClassPriority() {
        Long priority = 2L;
        handler.handleTaskProperty(this.task, this.type, this.key, (Serializable)priority);
        Assert.fail((String)"The method should throw an exception and not reach here.");
    }
}

