/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.calendar.cannedqueries;

import java.util.ArrayList;
import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQuery;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQueryParams;
import org.alfresco.repo.query.AbstractQNameAwareCannedQueryFactory;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;

public class GetCalendarEntriesCannedQueryFactory
extends AbstractQNameAwareCannedQueryFactory<CalendarEntry> {
    protected NodeService nodeService;
    protected TaggingService taggingService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"taggingService", (Object)this.taggingService);
    }

    public CannedQuery<CalendarEntry> getCannedQuery(CannedQueryParameters parameters) {
        GetCalendarEntriesCannedQuery cq = new GetCalendarEntriesCannedQuery(this.cannedQueryDAO, this.nodeService, this.taggingService, this.methodSecurity, parameters);
        return cq;
    }

    public CannedQuery<CalendarEntry> getCannedQuery(NodeRef[] containerNodes, Date fromDate, Date toDate, PagingRequest pagingReq) {
        ParameterCheck.mandatory((String)"containerNodes", (Object)containerNodes);
        ParameterCheck.mandatory((String)"pagingReq", (Object)pagingReq);
        int requestTotalCountMax = pagingReq.getRequestTotalCountMax();
        Long[] containerIds = new Long[containerNodes.length];
        int i = 0;
        while (i < containerIds.length) {
            containerIds[i] = this.getNodeId(containerNodes[i]);
            ++i;
        }
        GetCalendarEntriesCannedQueryParams paramBean = new GetCalendarEntriesCannedQueryParams(containerIds, this.getQNameId(ContentModel.PROP_NAME), this.getQNameId(CalendarModel.TYPE_EVENT), this.getQNameId(CalendarModel.PROP_FROM_DATE), this.getQNameId(CalendarModel.PROP_TO_DATE), this.getQNameId(CalendarModel.PROP_RECURRENCE_RULE), this.getQNameId(CalendarModel.PROP_RECURRENCE_LAST_MEETING), fromDate, toDate);
        CannedQueryPageDetails cqpd = this.createCQPageDetails(pagingReq);
        CannedQuerySortDetails cqsd = this.createCQSortDetails();
        CannedQueryParameters params = new CannedQueryParameters((Object)paramBean, cqpd, cqsd, requestTotalCountMax, pagingReq.getQueryExecutionId());
        return this.getCannedQuery(params);
    }

    protected CannedQuerySortDetails createCQSortDetails() {
        ArrayList<Pair> sort = new ArrayList<Pair>();
        sort.add(new Pair((Object)CalendarModel.PROP_FROM_DATE, (Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        sort.add(new Pair((Object)CalendarModel.PROP_TO_DATE, (Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        sort.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        return new CannedQuerySortDetails(sort);
    }
}

