/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.Set;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.springframework.extensions.surf.util.I18NUtil;

public class AddGroupAuthorityPatch
extends AbstractPatch {
    private static final String MSG_START = "patch.addGroupAuthority.start";
    private static final String MSG_RESULT = "patch.addGroupAuthority.result";
    private static final String MSG_EXIST = "patch.addGroupAuthority.exist";
    private AuthorityService authorityService;
    private GroupAuthorityDetails groupAuthorityDetails;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setGroupAuthorityDetails(GroupAuthorityDetails groupAuthorityDetails) {
        this.groupAuthorityDetails = groupAuthorityDetails;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.authorityService, "authorityService");
        this.checkPropertyNotNull(this.groupAuthorityDetails, "groupAuthorityDetails");
    }

    @Override
    protected String applyInternal() throws Exception {
        StringBuilder result = new StringBuilder(I18NUtil.getMessage((String)MSG_START));
        Object groupAuthorityName = "GROUP_" + this.groupAuthorityDetails.groupName;
        if (!this.authorityService.authorityExists((String)groupAuthorityName)) {
            groupAuthorityName = this.authorityService.createAuthority(AuthorityType.GROUP, this.groupAuthorityDetails.groupName, this.groupAuthorityDetails.groupDisplayName, this.groupAuthorityDetails.authorityZones);
            this.authorityService.addAuthority((String)groupAuthorityName, AuthenticationUtil.getAdminUserName());
            result.append(I18NUtil.getMessage((String)MSG_RESULT, (Object[])new Object[]{groupAuthorityName}));
        } else {
            result.append(I18NUtil.getMessage((String)MSG_EXIST, (Object[])new Object[]{groupAuthorityName}));
        }
        return result.toString();
    }

    public static class GroupAuthorityDetails {
        private String groupName;
        private String groupDisplayName;
        private Set<String> authorityZones;

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public void setGroupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
        }

        public void setAuthorityZones(Set<String> authorityZones) {
            this.authorityZones = authorityZones;
        }
    }
}

