/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Test;

public class ZeroStringifierTest {
    @Test
    public void testStringifyReference() throws Exception {
        Reference r = new Reference(Encodings.ZERO.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"));
        Assert.assertEquals((Object)"5:/org/alfresco/", (Object)r.encode(Encodings.ZERO.encoding));
        RepositoryResource rr1 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2")));
        RepositoryResource rr2 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/b6843991-e06f-4ca6-9fe5-51105e2af99f")));
        List<Parameter> params = Arrays.asList(new StringParameter("/"), new ResourceParameter((Resource)rr1), new ResourceParameter((Resource)rr2));
        Reference r2 = new Reference(Encodings.ZERO.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params);
        Assert.assertEquals((Object)"2:/org/alfresco/repo/virtual/node/vanilla.js:s:/:1:0d3b26ff-c4c1-4680-8622-8608ea7ab4b2:1:b6843991-e06f-4ca6-9fe5-51105e2af99f", (Object)r2.encode(Encodings.ZERO.encoding));
    }

    @Test
    public void testReferenceDelimiter() {
        List<Parameter> params1 = Arrays.asList(new StringParameter("/6"), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f")))), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/6428d7cc-feaa-4e32-a983-0b357439a994")))));
        Reference innerRef1 = new Reference(Encodings.ZERO.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params1);
        Reference innerRef2 = new Reference(Encodings.ZERO.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"), params1);
        List<Parameter> prms1 = Arrays.asList(new ReferenceParameter(innerRef1), new ReferenceParameter(innerRef2));
        Reference createdRef1 = new Reference(Encodings.ZERO.encoding, Protocols.NODE.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/Company Home/Data Dictionary/")), prms1);
        Assert.assertEquals((Object)"6:/Company Home/Data Dictionary/:r:2:/org/alfresco/repo/virtual/node/vanilla.js:s:/6:1:67c8f11d-0936-4295-88a0-12b85764c76f:1:6428d7cc-feaa-4e32-a983-0b357439a994:*:r:2:/org/alfresco/repo/virtual/node/vanilla.js:s:/6:1:67c8f11d-0936-4295-88a0-12b85764c76f:1:6428d7cc-feaa-4e32-a983-0b357439a994:*", (Object)createdRef1.encode());
        List<Parameter> prms2 = Arrays.asList(new StringParameter("ado+8"), new ReferenceParameter(innerRef1), new ReferenceParameter(innerRef2), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f")))));
        Reference createdRef2 = new Reference(Encodings.ZERO.encoding, Protocols.NODE.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/Company Home/Data Dictionary/")), prms2);
        Assert.assertEquals((Object)"6:/Company Home/Data Dictionary/:s:ado+8:r:2:/org/alfresco/repo/virtual/node/vanilla.js:s:/6:1:67c8f11d-0936-4295-88a0-12b85764c76f:1:6428d7cc-feaa-4e32-a983-0b357439a994:*:r:2:/org/alfresco/repo/virtual/node/vanilla.js:s:/6:1:67c8f11d-0936-4295-88a0-12b85764c76f:1:6428d7cc-feaa-4e32-a983-0b357439a994:*:1:67c8f11d-0936-4295-88a0-12b85764c76f", (Object)createdRef2.encode());
    }

    @Test
    public void testStringifyRepositoryNodeRef() throws Exception {
        RepositoryResource rr1 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444")));
        Reference r = new Reference(Encodings.ZERO.encoding, Protocols.VIRTUAL.protocol, (Resource)rr1);
        Assert.assertEquals((Object)"4:0029-222-333-444", (Object)r.encode(Encodings.ZERO.encoding));
    }

    public void testStringifyRepositoryPath() throws Exception {
        RepositoryResource rr2 = new RepositoryResource((RepositoryLocation)new RepositoryPath("/Data Dictionary/Virtual Folders/claim.json"));
        Reference r = new Reference(Encodings.ZERO.encoding, Protocols.VIRTUAL.protocol, (Resource)rr2);
        Assert.assertEquals((Object)"3:/Data Dictionary/Virtual Folders/claim.json", (Object)r.encode(Encodings.ZERO.encoding));
    }
}

