/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.PlainReferenceParser;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public class ReferenceTest
extends TestCase {
    private static final String TEST_CLASSPATH = "/org/alfresco/";
    private static final String TEST_PLAIN_REFERENCE = "virtual:classpath:/org/alfresco/";
    private static final String TEST_NODE_REF = "workspace://SpacesStore/vpdmlydHVhbDpjbGFzc3BhdGg6L29yZy9hbGZyZXNjby8=";
    private static final String TEST_NODE_REF_1 = "workspace://SpacesStore/vpdmFuaWxsYTpjbGFzc3BhdGg6L29yZy9hbGZyZXNjby9yZXBvL3ZpcnR1YWwvbm9kZS92YW5pbGxhLmpzOnM6LzAxIENvcnJlc3BvbmRlbmNlOnI6cmVwb3NpdG9yeTpub2RlOndvcmtzcGFjZTpTcGFjZXNTdG9yZTo2NWM2NjliMS00N2IzLTQzMmUtYjk0Zi1lZmU4YTcyYWEyMjA6cjpjbGFzc3BhdGg6L29yZy9hbGZyZXNjby9yZXBvL3ZpcnR1YWwvbm9kZS9jbGFpbXNEZW1vLmpzb24";
    private static final Reference TEST_REFERENCE = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"));

    @Test
    public void testToNodeRef() throws Exception {
        Reference r = new PlainReferenceParser().parse(TEST_PLAIN_REFERENCE);
        NodeRef nodeRef = r.toNodeRef();
        ReferenceTest.assertEquals((Object)new NodeRef(TEST_NODE_REF), (Object)nodeRef);
    }

    @Test
    public void testFromNodeRef() throws Exception {
        Reference r = Reference.fromNodeRef((NodeRef)new NodeRef(TEST_NODE_REF));
        Reference expectedReference = TEST_REFERENCE;
        ReferenceTest.assertEquals((Object)expectedReference, (Object)r);
        String expected = "vanilla:classpath:/org/alfresco/repo/virtual/node/vanilla.js:s:/01 Correspondence:r:repository:node:workspace:SpacesStore:65c669b1-47b3-432e-b94f-efe8a72aa220:r:classpath:/org/alfresco/repo/virtual/node/claimsDemo.json";
        Reference fromNodeRef = Reference.fromNodeRef((NodeRef)new NodeRef(TEST_NODE_REF_1));
        ReferenceTest.assertNotNull((Object)fromNodeRef);
        ReferenceTest.assertEquals((String)expected, (String)fromNodeRef.toString());
    }

    @Test
    public void testExecute() throws Exception {
        boolean sccess = (Boolean)TEST_REFERENCE.execute((ProtocolMethod)new ProtocolMethod<Boolean>(){

            public Boolean execute(VanillaProtocol vanillaProtocol, Reference reference) throws ProtocolMethodException {
                ReferenceTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
                if (reference == TEST_REFERENCE) {
                    return true;
                }
                return false;
            }

            public Boolean execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
                ReferenceTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(Protocol protocol, Reference reference) throws ProtocolMethodException {
                ReferenceTest.fail((String)"Invalid dispatch");
                return false;
            }
        });
        ReferenceTest.assertTrue((String)"Invalid method execution result!", (boolean)sccess);
    }

    @Test
    public void testEncode() throws Exception {
        Reference r = TEST_REFERENCE;
        ReferenceTest.assertEquals((String)TEST_PLAIN_REFERENCE, (String)r.encode());
    }

    @Test
    public void testEquals() throws Exception {
        ReferenceTest.assertTrue((boolean)TEST_REFERENCE.equals((Object)TEST_REFERENCE));
        ReferenceTest.assertFalse((boolean)TEST_REFERENCE.equals(null));
        Reference testResourceReplica = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource(TEST_CLASSPATH));
        ReferenceTest.assertTrue((boolean)TEST_REFERENCE.equals((Object)testResourceReplica));
        Reference nullResRef = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, null);
        Reference nullResRefReplica = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, null);
        ReferenceTest.assertFalse((boolean)TEST_REFERENCE.equals((Object)nullResRef));
        ReferenceTest.assertFalse((boolean)nullResRef.equals((Object)TEST_REFERENCE));
        ReferenceTest.assertTrue((boolean)nullResRef.equals((Object)nullResRefReplica));
        List<Parameter> params1 = Arrays.asList(new StringParameter("P1"));
        List<Parameter> params2 = Arrays.asList(new StringParameter("P1"), new StringParameter("P2"));
        Reference testParams1Ref = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource(TEST_CLASSPATH), params1);
        Reference testParams1RefReplica = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource(TEST_CLASSPATH), params1);
        Reference testParams2Ref = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource(TEST_CLASSPATH), params2);
        ReferenceTest.assertTrue((boolean)testParams1Ref.equals((Object)testParams1RefReplica));
        ReferenceTest.assertFalse((boolean)testParams2Ref.equals((Object)testParams1Ref));
    }
}

