/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rendition2.AbstractRenditionIntegrationTest;
import org.alfresco.repo.rendition2.LocalSynchronousTransformClient;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.beans.factory.annotation.Autowired;

@Category(value={NeverRunsTests.class})
public class LocalSynchronousTransformClientIntegrationTest
extends AbstractRenditionIntegrationTest {
    @Autowired
    protected SynchronousTransformClient localSynchronousTransformClient;
    protected SynchronousTransformClient synchronousTransformClient;

    @BeforeClass
    public static void before() {
        AbstractRenditionIntegrationTest.before();
        LocalSynchronousTransformClientIntegrationTest.local();
    }

    @AfterClass
    public static void after() {
        System.clearProperty("transformer.strict.mimetype.check");
        System.clearProperty("content.transformer.retryOn.different.mimetype");
        AbstractRenditionIntegrationTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getAdminUserName());
        this.synchronousTransformClient = this.localSynchronousTransformClient;
    }

    @Test
    public void testTransformDocxJpegMedium() throws Exception {
        this.checkTransform("quick.docx", "medium", true);
    }

    @Test
    public void testTransformDocxDoclib() throws Exception {
        this.checkTransform("quick.docx", "doclib", true);
    }

    @Test
    public void testParallelTransforms() throws Exception {
        ArrayList<Callable<Void>> transforms = new ArrayList<Callable<Void>>();
        ExecutorService executorService = Executors.newWorkStealingPool(10);
        int i = 0;
        while (i < 50) {
            Callable<Void> callable = () -> {
                this.checkTransform("quick.txt", "text/plain", Collections.emptyMap(), true);
                return null;
            };
            transforms.add(callable);
            ++i;
        }
        executorService.invokeAll(transforms);
    }

    @Test
    public void testTransformDocxJpegImgpreview() throws Exception {
        this.checkTransform("quick.docx", "imgpreview", true);
    }

    @Test
    public void testTransformDocxPngAvatar() throws Exception {
        this.checkTransform("quick.docx", "avatar", true);
    }

    @Test
    public void testTransformDocxPngAvatar32() throws Exception {
        this.checkTransform("quick.docx", "avatar32", true);
    }

    @Test
    public void testTransformDocxFlashWebpreview() throws Exception {
        this.checkTransform("quick.docx", "webpreview", false);
    }

    @Test
    public void testTransformDocxPdf() throws Exception {
        this.checkTransform("quick.docx", "pdf", false);
    }

    @Test
    public void testRetryOnDifferentMimetype() throws Exception {
        boolean expectedToPass = this.synchronousTransformClient.getClass().isInstance(LocalSynchronousTransformClient.class);
        this.checkTransform("quick-differentMimetype.docx", "pdf", expectedToPass);
    }

    @Test
    public void testNonWhitelistedStrictMimetype() throws Exception {
        this.checkTransform("quickMaskedHtml.jpeg", "avatar32", false);
    }

    private void checkTransform(String testFileName, String renditionDefinitionName, boolean expectedToPass) throws Exception {
        if (expectedToPass) {
            RenditionDefinition2 renditionDefinition = this.renditionDefinitionRegistry2.getRenditionDefinition(renditionDefinitionName);
            String targetMimetype = renditionDefinition.getTargetMimetype();
            Map actualOptions = renditionDefinition.getTransformOptions();
            this.checkTransform(testFileName, targetMimetype, actualOptions, expectedToPass);
        }
    }

    private void checkTransform(String testFileName, String targetMimetype, Map<String, String> actualOptions, boolean expectedToPass) {
        if (expectedToPass) {
            NodeRef sourceNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.createContentNodeFromQuickFile(testFileName));
            ContentReader reader = this.contentService.getReader(sourceNode, ContentModel.PROP_CONTENT);
            ContentWriter writer = this.contentService.getTempWriter();
            writer.setMimetype(targetMimetype);
            this.synchronousTransformClient.transform(reader, writer, actualOptions, null, sourceNode);
            ContentReader transformReader = writer.getReader();
            String content = transformReader == null ? null : transformReader.getContentString();
            content = content == null || content.isEmpty() ? null : content;
            LocalSynchronousTransformClientIntegrationTest.assertNotNull((String)"The synchronous transform resulted in no content", (Object)content);
        }
    }
}

