/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class SecondaryTypesProperty
extends AbstractProperty {
    private CMISMapping cmisMapping;

    public SecondaryTypesProperty(ServiceRegistry serviceRegistry, CMISConnector connector, CMISMapping cmisMapping) {
        super(serviceRegistry, connector, "cmis:secondaryObjectTypeIds");
        this.cmisMapping = cmisMapping;
    }

    @Override
    public Serializable getValueInternal(CMISNodeInfo nodeInfo) {
        NodeRef nodeRef = nodeInfo.getNodeRef();
        if (nodeRef == null || nodeInfo.getType() == null) {
            return (Serializable)((Object)Collections.emptyList());
        }
        Set aspects = nodeInfo.getNodeAspects();
        ArrayList<String> results = new ArrayList<String>(aspects.size());
        for (QName aspect : aspects) {
            String typeId = this.cmisMapping.getCmisTypeId(aspect);
            if (typeId == null) continue;
            results.add(typeId);
        }
        return results;
    }
}

