/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.config;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.VirtualizationTest;
import org.alfresco.repo.virtual.config.NodeRefPathExpression;
import org.alfresco.repo.virtual.config.NodeRefPathExpressionFactory;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeRefPathExpressionTest
extends VirtualizationIntegrationTest
implements VirtualizationTest {
    private static final String NODE_REF_PATH_EXPRESSION_FACTORY_ID = "config.NodeRefPathExpressionFactory";
    private NodeRefPathExpressionFactory nodeRefPathExpressionFactory;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.nodeRefPathExpressionFactory = (NodeRefPathExpressionFactory)this.ctx.getBean(NODE_REF_PATH_EXPRESSION_FACTORY_ID);
    }

    protected void assertResolvablePath(String path, String toName) {
        NodeRefPathExpression pathExpression = this.nodeRefPathExpressionFactory.createInstance();
        pathExpression.setPath(path);
        NodeRef nodeRef = pathExpression.resolve();
        Assert.assertNotNull((Object)nodeRef);
        Serializable theName = this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME);
        Assert.assertEquals((String)("Unexpected name for path " + String.valueOf(pathExpression)), (Object)toName, (Object)theName);
    }

    @Test
    public void testResolveNamePath() throws Exception {
        this.assertResolvablePath("/Data Dictionary", "Data Dictionary");
        this.assertResolvablePath("/Data Dictionary//Messages", "Messages");
        this.assertResolvablePath("", "Company Home");
        this.assertResolvablePath("//", "Company Home");
    }

    @Test
    public void testResolveQNamePath() throws Exception {
        this.assertResolvablePath("", "Company Home");
        this.assertResolvablePath("app:dictionary", "Data Dictionary");
        this.assertResolvablePath("/app:dictionary/app:messages", "Messages");
    }

    @Test
    public void testNonSingleton() throws Exception {
        NodeRefPathExpression spe1 = this.nodeRefPathExpressionFactory.createInstance();
        NodeRefPathExpression spe2 = this.nodeRefPathExpressionFactory.createInstance();
        Assert.assertNotSame((Object)spe1, (Object)spe2);
        spe1.setPath("Data Dictionary");
        spe2.setPath("/Data Dictionary//Messages");
        NodeRef nr = spe1.resolve();
        Serializable theName = this.nodeService.getProperty(nr, ContentModel.PROP_NAME);
        Assert.assertEquals((Object)"Data Dictionary", (Object)theName);
    }
}

