/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.workflow.FailedWorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class WorkflowDeployer
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    public static final String ENGINE_ID = "engineId";
    public static final String LOCATION = "location";
    public static final String MIMETYPE = "mimetype";
    public static final String REDEPLOY = "redeploy";
    public static final String CATEGORY_ALFRESCO_INTERNAL = "http://alfresco.org/workflows/internal";
    public static final String CATEGORY_FULL_ACCESS = "http://alfresco.org/workflows/fullAccess";
    private TransactionService transactionService;
    private WorkflowService workflowService;
    private WorkflowAdminService workflowAdminService;
    private AuthenticationContext authenticationContext;
    private DictionaryDAO dictionaryDAO;
    private List<Properties> workflowDefinitions;
    private List<String> models = new ArrayList<String>();
    private List<String> resourceBundles = new ArrayList<String>();
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private RepositoryLocation repoWorkflowDefsLocation;
    private WorkflowDeployerTransactionListener workflowDeployerTransactionListener = new WorkflowDeployerTransactionListener();
    public static final String CRITERIA_ALL = "/*";
    public static final String defaultSubtypeOfWorkflowDefinitionType = "subtypeOf('bpm:workflowDefinition')";

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setWorkflowAdminService(WorkflowAdminService workflowAdminService) {
        this.workflowAdminService = workflowAdminService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setWorkflowDefinitions(List<Properties> workflowDefinitions) {
        this.workflowDefinitions = workflowDefinitions;
    }

    public void setModels(List<String> modelResources) {
        this.models = modelResources;
    }

    public void setLabels(List<String> labels) {
        this.resourceBundles = labels;
    }

    public List<Properties> getWorkflowDefinitions() {
        return this.workflowDefinitions;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRepositoryWorkflowDefsLocations(RepositoryLocation repoWorkflowDefsLocation) {
        this.repoWorkflowDefsLocation = repoWorkflowDefsLocation;
    }

    public void init() {
        PropertyCheck.mandatory((Object)((Object)this), (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"authenticationContext", (Object)this.authenticationContext);
        PropertyCheck.mandatory((Object)((Object)this), (String)"workflowService", (Object)this.workflowService);
        String currentUser = this.authenticationContext.getCurrentUserName();
        if (currentUser == null) {
            this.authenticationContext.setSystemUserAsCurrentUser();
        }
        if (!this.transactionService.getAllowWrite() && AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Repository is in read-only mode; not deploying workflows.");
            }
            return;
        }
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        try {
            try {
                StoreRef storeRef;
                NodeRef rootNode;
                List nodeRefs;
                userTransaction.begin();
                if (this.models != null && this.resourceBundles != null && (this.models.size() > 0 || this.resourceBundles.size() > 0)) {
                    DictionaryBootstrap dictionaryBootstrap = new DictionaryBootstrap();
                    dictionaryBootstrap.setDictionaryDAO(this.dictionaryDAO);
                    dictionaryBootstrap.setTenantService(this.tenantService);
                    dictionaryBootstrap.setModels(this.models);
                    dictionaryBootstrap.setLabels(this.resourceBundles);
                    dictionaryBootstrap.bootstrap();
                    AlfrescoTransactionSupport.bindListener(this.workflowDeployerTransactionListener);
                }
                if (this.workflowDefinitions != null) {
                    for (Properties workflowDefinition : this.workflowDefinitions) {
                        String engineId = workflowDefinition.getProperty(ENGINE_ID);
                        if (engineId == null || engineId.length() == 0) {
                            throw new WorkflowException("Workflow Engine Id must be provided");
                        }
                        String location = workflowDefinition.getProperty(LOCATION);
                        if (location == null || location.length() == 0) {
                            throw new WorkflowException("Workflow definition location must be provided");
                        }
                        if (this.workflowAdminService.isEngineEnabled(engineId)) {
                            Boolean redeploy = Boolean.valueOf(workflowDefinition.getProperty(REDEPLOY));
                            String mimetype = workflowDefinition.getProperty(MIMETYPE);
                            ClassPathResource workflowResource = new ClassPathResource(location);
                            if (!redeploy.booleanValue() && this.workflowService.isDefinitionDeployed(engineId, workflowResource.getInputStream(), mimetype)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Workflow deployer: Definition '" + location + "' already deployed. Checking deploymentcategory..."));
                                }
                                this.workflowService.checkDeploymentCategory(engineId, workflowResource.getInputStream());
                                continue;
                            }
                            InputStream workflowInputStream = workflowResource.getInputStream();
                            Optional<WorkflowDeployment> possibleDeployment = this.tryToDeploy(() -> this.workflowService.deployDefinition(engineId, workflowInputStream, mimetype, workflowResource.getFilename(), true));
                            possibleDeployment.ifPresent(deployment -> this.logDeployment(location, (WorkflowDeployment)deployment));
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Workflow deployer: Definition '" + location + "' not deployed as the '" + engineId + "' engine is disabled"));
                    }
                }
                if (this.repoWorkflowDefsLocation != null && (nodeRefs = this.searchService.selectNodes(rootNode = this.nodeService.getRootNode(storeRef = this.repoWorkflowDefsLocation.getStoreRef()), this.repoWorkflowDefsLocation.getPath() + "/*[subtypeOf('bpm:workflowDefinition')]", null, (NamespacePrefixResolver)this.namespaceService, false)).size() > 0) {
                    for (NodeRef nodeRef : nodeRefs) {
                        this.deploy(nodeRef, false);
                    }
                }
                userTransaction.commit();
            }
            catch (Throwable e) {
                try {
                    if (userTransaction != null) {
                        userTransaction.rollback();
                    }
                }
                catch (Exception exception) {}
                throw new AlfrescoRuntimeException("Workflow deployment failed", e);
            }
        }
        finally {
            if (currentUser == null) {
                this.authenticationContext.clearCurrentSecurityContext();
            }
        }
    }

    public void deploy(NodeRef nodeRef, boolean redeploy) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            if (!this.isValidLocation(nodeRef)) {
                if (logger.isDebugEnabled()) {
                    Path nodePath = this.nodeService.getPath(nodeRef);
                    logger.debug((Object)("Workflow deployer: Definition '" + String.valueOf(nodeRef) + "' (" + String.valueOf(nodePath) + ") not deployed as it is not in the correct location."));
                }
                return;
            }
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED);
            if (value != null && value.booleanValue()) {
                String engineId = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID));
                if (this.workflowAdminService.isEngineEnabled(engineId)) {
                    if (!redeploy && this.workflowService.isDefinitionDeployed(nodeRef)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Workflow deployer: Definition '" + String.valueOf(nodeRef) + "' already deployed"));
                        }
                    } else {
                        this.tryToDeploy(() -> this.workflowService.deployDefinition(nodeRef)).ifPresent(deployment -> {
                            this.logDeployment(nodeRef, (WorkflowDeployment)deployment);
                            WorkflowDefinition def = deployment.getDefinition();
                            Map props = this.nodeService.getProperties(nodeRef);
                            props.put(WorkflowModel.PROP_WORKFLOW_DEF_NAME, def.getName());
                            if (deployment.getProblems().length > 0) {
                                String[] stringArray = deployment.getProblems();
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String problem = stringArray[n2];
                                    if (logger.isWarnEnabled()) {
                                        logger.warn((Object)problem);
                                    }
                                    ++n2;
                                }
                            }
                            this.nodeService.setProperties(nodeRef, props);
                        });
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Workflow deployer: Definition '" + String.valueOf(nodeRef) + "' not deployed as the '" + engineId + "' engine is disabled"));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Workflow deployer: Definition '" + String.valueOf(nodeRef) + "' not deployed since it is a working copy"));
        }
    }

    private Optional<WorkflowDeployment> tryToDeploy(Supplier<WorkflowDeployment> workflowDeployment) {
        WorkflowDeployment deployment = workflowDeployment.get();
        Optional<String> possibleFailure = FailedWorkflowDeployment.getFailure(deployment);
        if (possibleFailure.isEmpty()) {
            return Optional.ofNullable(deployment);
        }
        logger.warn((Object)("Failed to deploy a workflow. " + possibleFailure.get()));
        return Optional.empty();
    }

    private boolean isValidLocation(NodeRef definitionNode) {
        StoreRef storeRef = this.repoWorkflowDefsLocation.getStoreRef();
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(rootNode, this.repoWorkflowDefsLocation.getPath(), null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.isEmpty() || nodeRefs.size() > 1) {
            throw new IllegalStateException("Incorrect number of nodes (" + nodeRefs.size() + ") found for workflow location: " + this.repoWorkflowDefsLocation.getPath());
        }
        NodeRef workflowParent = (NodeRef)nodeRefs.get(0);
        for (ChildAssociationRef assoc : this.nodeService.getParentAssocs(definitionNode)) {
            if (!assoc.getParentRef().equals((Object)workflowParent)) continue;
            return true;
        }
        return false;
    }

    private void logDeployment(Object location, WorkflowDeployment deployment) {
        if (logger.isDebugEnabled()) {
            String title = deployment.getDefinition().getTitle();
            String version = deployment.getDefinition().getVersion();
            int problemLength = deployment.getProblems().length;
            logger.debug((Object)("Workflow deployer: Deployed process definition '" + title + "' (version " + version + ") from '" + String.valueOf(location) + "' with " + problemLength + " problems"));
        }
    }

    public void undeploy(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            String defName = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_NAME));
            if (defName != null) {
                List<WorkflowDefinition> defs = this.workflowService.getAllDefinitionsByName(defName);
                for (WorkflowDefinition def : defs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Undeploying workflow '" + defName + "' ..."));
                    }
                    this.workflowService.undeployDefinition(def.getId());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("... undeployed '" + def.getId() + "' v" + def.getVersion()));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Workflow deployer: Definition '" + String.valueOf(nodeRef) + "' not undeployed since it is a working copy"));
        }
    }

    public int undeploy(List<String> workflowNames) {
        int undeployed = 0;
        for (String workflowName : workflowNames) {
            String engineId = BPMEngineRegistry.getEngineId(workflowName);
            if (this.workflowAdminService.isEngineEnabled(engineId)) {
                List<WorkflowDefinition> defs = this.workflowService.getAllDefinitionsByName(workflowName);
                if (defs.size() > 0) {
                    ++undeployed;
                }
                for (WorkflowDefinition def : defs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Undeploying workflow '" + workflowName + "' ..."));
                    }
                    this.workflowService.undeployDefinition(def.getId());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("... undeployed '" + def.getId() + "' v" + def.getVersion()));
                }
                continue;
            }
            logger.debug((Object)("Workflow deployer: Definition '" + workflowName + "' cannot be undeployed as the '" + engineId + "' engine is disabled"));
        }
        return undeployed;
    }

    protected void onBootstrap(ApplicationEvent event) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() {
                        WorkflowDeployer.this.init();
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }, false, true);
        this.tenantAdminService.register(this);
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public class WorkflowDeployerTransactionListener
    extends TransactionListenerAdapter {
        @Override
        public void afterCommit() {
            RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        public Object doWork() {
                            ((WorkflowDeployerTransactionListener)(this).WorkflowDeployerTransactionListener.this).WorkflowDeployer.this.dictionaryDAO.init();
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Workflow deployer afterCommit: Dictionary destroyed [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                            }
                            return null;
                        }
                    }, (String)AuthenticationUtil.getSystemUserName());
                    return null;
                }
            };
            WorkflowDeployer.this.transactionService.getRetryingTransactionHelper().doInTransaction(work, true, true);
        }
    }
}

