/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.search.AbstractIndexFilter;
import org.alfresco.service.namespace.QName;

public class TypeIndexFilter
extends AbstractIndexFilter {
    private boolean ignorePathsForSpecificTypes = false;
    private Set<QName> typesForIgnoringPaths = new HashSet<QName>();
    private List<String> typesForIgnoringPathsString;

    public boolean isIgnorePathsForSpecificTypes() {
        return this.ignorePathsForSpecificTypes;
    }

    public void setIgnorePathsForSpecificTypes(boolean ignorePersonAndConfigurationPaths) {
        this.ignorePathsForSpecificTypes = ignorePersonAndConfigurationPaths;
    }

    public void setTypesForIgnoringPaths(List<String> typesForIgnoringPaths) {
        this.typesForIgnoringPathsString = typesForIgnoringPaths;
    }

    @Override
    public void init() {
        super.init();
        this.initIgnoringPathsByCriterion(this.typesForIgnoringPathsString, this.typesForIgnoringPaths, new AbstractIndexFilter.DefinitionExistChecker(){

            @Override
            public boolean isDefinitionExists(QName qName) {
                return TypeIndexFilter.this.dictionaryService.getType(qName) != null;
            }
        });
    }

    public boolean shouldBeIgnored(QName nodeType) {
        if (!this.ignorePathsForSpecificTypes) {
            return false;
        }
        if (nodeType != null) {
            if (this.typesForIgnoringPaths.contains(nodeType)) {
                return true;
            }
            for (QName type : this.typesForIgnoringPaths) {
                if (!this.dictionaryService.isSubClass(nodeType, type)) continue;
                return true;
            }
        }
        return false;
    }
}

