/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;
import org.springframework.util.FileCopyUtils;

public class AttachmentsExtractor {
    private Log logger = LogFactory.getLog(AttachmentsExtractor.class);
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private ImapService imapService;
    private ServiceRegistry serviceRegistry;
    private RepositoryFolderConfigBean attachmentsFolder;
    private NodeRef attachmentsFolderRef;
    private AttachmentsExtractorMode attachmentsExtractorMode;
    private MimetypeService mimetypeService;

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setImapService(ImapService imapService) {
        this.imapService = imapService;
    }

    public void setAttachmentsFolder(RepositoryFolderConfigBean attachmentsFolder) {
        this.attachmentsFolder = attachmentsFolder;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setAttachmentsExtractorMode(String attachmentsExtractorMode) {
        this.attachmentsExtractorMode = AttachmentsExtractorMode.valueOf(attachmentsExtractorMode);
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void init() {
        this.attachmentsFolderRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RetryingTransactionHelper helper = AttachmentsExtractor.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper();
                helper.setForceWritable(true);
                RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> getDescriptorCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() {
                        NodeRef attFolderRef = (this).AttachmentsExtractor.this.attachmentsFolder.getOrCreateFolderPath((this).AttachmentsExtractor.this.serviceRegistry.getNamespaceService(), (this).AttachmentsExtractor.this.nodeService, (this).AttachmentsExtractor.this.serviceRegistry.getSearchService(), (this).AttachmentsExtractor.this.fileFolderService);
                        if ((this).AttachmentsExtractor.this.attachmentsExtractorMode != null && (this).AttachmentsExtractor.this.attachmentsExtractorMode == AttachmentsExtractorMode.COMMON) {
                            (this).AttachmentsExtractor.this.serviceRegistry.getPermissionService().setPermission(attFolderRef, "GROUP_EVERYONE", "FullControl", true);
                        }
                        return attFolderRef;
                    }
                };
                return helper.doInTransaction(getDescriptorCallback, false, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void extractAttachments(NodeRef messageRef, MimeMessage originalMessage) throws IOException, MessagingException {
        Object content;
        NodeRef attachmentsFolderRef = null;
        String attachmentsFolderName = null;
        boolean createFolder = false;
        switch (this.attachmentsExtractorMode) {
            case SAME: {
                attachmentsFolderRef = this.nodeService.getPrimaryParent(messageRef).getParentRef();
                break;
            }
            case COMMON: {
                attachmentsFolderRef = this.attachmentsFolderRef;
                break;
            }
            default: {
                String messageName = (String)((Object)this.nodeService.getProperty(messageRef, ContentModel.PROP_NAME));
                attachmentsFolderName = messageName + "-attachments";
                createFolder = true;
            }
        }
        if (!createFolder) {
            this.nodeService.createAssociation(messageRef, attachmentsFolderRef, ImapModel.ASSOC_IMAP_ATTACHMENTS_FOLDER);
        }
        if ((content = originalMessage.getContent()) instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int i = 0;
            int n = multipart.getCount();
            while (i < n) {
                BodyPart part = multipart.getBodyPart(i);
                if ("attachment".equalsIgnoreCase(part.getDisposition())) {
                    if (createFolder) {
                        attachmentsFolderRef = this.createAttachmentFolder(messageRef, attachmentsFolderName);
                        createFolder = false;
                    }
                    this.createAttachment(messageRef, attachmentsFolderRef, (Part)part);
                }
                ++i;
            }
        }
    }

    private NodeRef createAttachmentFolder(NodeRef messageRef, String attachmentsFolderName) {
        NodeRef attachmentsFolderRef = null;
        NodeRef parentFolder = this.nodeService.getPrimaryParent(messageRef).getParentRef();
        attachmentsFolderRef = this.fileFolderService.create(parentFolder, attachmentsFolderName, ContentModel.TYPE_FOLDER).getNodeRef();
        this.nodeService.createAssociation(messageRef, attachmentsFolderRef, ImapModel.ASSOC_IMAP_ATTACHMENTS_FOLDER);
        return attachmentsFolderRef;
    }

    private void createAttachment(NodeRef messageFile, NodeRef attachmentsFolderRef, Part part) throws MessagingException, IOException {
        String fileName;
        block9: {
            fileName = part.getFileName();
            if (fileName == null || fileName.isEmpty()) {
                fileName = "unnamed";
            }
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException e) {
                if (!this.logger.isWarnEnabled()) break block9;
                this.logger.warn((Object)("Cannot decode file name '" + fileName + "'"), (Throwable)e);
            }
        }
        ContentType contentType = new ContentType(part.getContentType());
        if (contentType.getBaseType().equalsIgnoreCase("application/ms-tnef")) {
            HMEFMessage hmef = new HMEFMessage(part.getInputStream());
            List attachments = hmef.getAttachments();
            for (Attachment attachment : attachments) {
                String subName = attachment.getLongFilename();
                NodeRef attachmentNode = this.fileFolderService.searchSimple(attachmentsFolderRef, subName);
                if (attachmentNode != null) continue;
                FileInfo createdFile = this.fileFolderService.create(attachmentsFolderRef, subName, ContentModel.TYPE_CONTENT);
                attachmentNode = createdFile.getNodeRef();
                this.serviceRegistry.getNodeService().createAssociation(messageFile, attachmentNode, ImapModel.ASSOC_IMAP_ATTACHMENT);
                byte[] bytes = attachment.getContents();
                ContentWriter writer = this.fileFolderService.getWriter(attachmentNode);
                String extension = attachment.getExtension();
                String mimetype = this.mimetypeService.getMimetype(extension);
                if (mimetype != null) {
                    writer.setMimetype(mimetype);
                }
                OutputStream os = writer.getContentOutputStream();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                FileCopyUtils.copy((InputStream)is, (OutputStream)os);
            }
        } else {
            NodeRef attachmentFile = this.fileFolderService.searchSimple(attachmentsFolderRef, fileName);
            if (attachmentFile == null) {
                FileInfo createdFile = this.fileFolderService.create(attachmentsFolderRef, fileName, ContentModel.TYPE_CONTENT);
                this.nodeService.createAssociation(messageFile, createdFile.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENT);
                attachmentFile = createdFile.getNodeRef();
            } else {
                String newFileName = this.imapService.generateUniqueFilename(attachmentsFolderRef, fileName);
                FileInfo createdFile = this.fileFolderService.create(attachmentsFolderRef, newFileName, ContentModel.TYPE_CONTENT);
                this.nodeService.createAssociation(messageFile, createdFile.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENT);
                attachmentFile = createdFile.getNodeRef();
            }
            this.nodeService.setProperty(attachmentFile, ContentModel.PROP_DESCRIPTION, this.nodeService.getProperty(messageFile, ContentModel.PROP_NAME));
            ContentWriter writer = this.fileFolderService.getWriter(attachmentFile);
            writer.setMimetype(contentType.getBaseType());
            OutputStream os = writer.getContentOutputStream();
            FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)os);
        }
    }

    public static enum AttachmentsExtractorMode {
        SAME,
        COMMON,
        SEPARATE;

    }
}

