/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.ProtectedUser;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.tenant.TenantContextHolder;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationServiceImpl
extends AbstractAuthenticationService
implements ActivateableBean {
    private Log logger = LogFactory.getLog(AuthenticationServiceImpl.class);
    AuthenticationComponent authenticationComponent;
    TicketComponent ticketComponent;
    private String serviceInstanceId = GUID.generate();
    private String domain;
    private boolean allowsUserCreation = true;
    private boolean allowsUserDeletion = true;
    private boolean allowsUserPasswordChange = true;
    private static final String AUTHENTICATION_UNSUCCESSFUL = "Authentication was not successful.";
    private static final String BRUTE_FORCE_ATTACK_DETECTED = "Brute force attack was detected for user: %s";
    private int protectionPeriodSeconds;
    private boolean protectionEnabled;
    private int protectionLimit;
    private SimpleCache<String, ProtectedUser> protectedUsersCache;
    private PersonService personService;

    public void setProtectionPeriodSeconds(int protectionPeriodSeconds) {
        this.protectionPeriodSeconds = protectionPeriodSeconds;
    }

    public void setProtectionEnabled(boolean protectionEnabled) {
        this.protectionEnabled = protectionEnabled;
    }

    public boolean isProtectionEnabled() {
        return this.protectionEnabled;
    }

    public void setProtectionLimit(int protectionLimit) {
        this.protectionLimit = protectionLimit;
    }

    public void setProtectedUsersCache(SimpleCache<String, ProtectedUser> protectedUsersCache) {
        this.protectedUsersCache = protectedUsersCache;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTicketComponent(TicketComponent ticketComponent) {
        this.ticketComponent = ticketComponent;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    @Override
    public boolean isActive() {
        return !(this.authenticationComponent instanceof ActivateableBean) || ((ActivateableBean)((Object)this.authenticationComponent)).isActive();
    }

    private boolean getUserNamesAreCaseSensitive() {
        if (this.personService != null) {
            return this.personService.getUserNamesAreCaseSensitive();
        }
        return false;
    }

    @Override
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        try {
            String protectedUserKey;
            String tenant = this.getPrevalidationTenantDomain();
            this.clearCurrentSecurityContext();
            this.preAuthenticationCheck(userName);
            if (this.isUserProtected(userName)) {
                throw new AuthenticationException(AUTHENTICATION_UNSUCCESSFUL);
            }
            this.authenticationComponent.authenticate(userName, password);
            if (tenant == null) {
                Pair userTenant = AuthenticationUtil.getUserTenant((String)userName);
                tenant = (String)userTenant.getSecond();
            }
            TenantContextHolder.setTenantDomain((String)tenant);
            if (this.protectionEnabled && this.protectedUsersCache.get((Serializable)((Object)(protectedUserKey = this.getProtectedUserKey(userName)))) != null) {
                this.protectedUsersCache.remove((Serializable)((Object)protectedUserKey));
            }
        }
        catch (AuthenticationException ae) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exception in authenticating user: " + AuthenticationUtil.maskUsername((String)userName) + ", cause: " + ae.getMessage()), (Throwable)ae);
            }
            this.clearCurrentSecurityContext();
            this.recordFailedAuthentication(userName);
            throw ae;
        }
        this.ticketComponent.clearCurrentTicket();
        this.getCurrentTicket();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Authenticated user: " + AuthenticationUtil.maskUsername((String)userName)));
        }
    }

    public boolean isUserProtected(String userName) {
        String protectedUserKey;
        ProtectedUser protectedUser;
        boolean isProtected = false;
        if (this.protectionEnabled && (protectedUser = (ProtectedUser)this.protectedUsersCache.get((Serializable)((Object)(protectedUserKey = this.getProtectedUserKey(userName))))) != null) {
            long currentTimeStamp = System.currentTimeMillis();
            isProtected = protectedUser.getNumLogins() >= (long)this.protectionLimit && currentTimeStamp - protectedUser.getTimeStamp() < (long)(this.protectionPeriodSeconds * 1000);
        }
        return isProtected;
    }

    public void recordFailedAuthentication(String userName) {
        if (this.protectionEnabled) {
            String protectedUserKey = this.getProtectedUserKey(userName);
            ProtectedUser protectedUser = (ProtectedUser)this.protectedUsersCache.get((Serializable)((Object)protectedUserKey));
            if (protectedUser == null) {
                protectedUser = new ProtectedUser(userName);
            } else if ((protectedUser = new ProtectedUser(userName, protectedUser.getNumLogins() + 1L)).getNumLogins() == (long)this.protectionLimit && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)String.format(BRUTE_FORCE_ATTACK_DETECTED, AuthenticationUtil.maskUsername((String)userName)));
            }
            this.protectedUsersCache.put((Serializable)((Object)protectedUserKey), (Object)protectedUser);
        }
    }

    public String getProtectedUserKey(String userName) {
        if (!this.getUserNamesAreCaseSensitive()) {
            userName = userName.toLowerCase();
        }
        return this.serviceInstanceId + "@@" + userName;
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        return this.authenticationComponent.getCurrentUserName();
    }

    @Override
    public void invalidateUserSession(String userName) throws AuthenticationException {
        this.ticketComponent.invalidateTicketByUser(userName);
    }

    @Override
    public Set<String> getUsersWithTickets(boolean nonExpiredOnly) {
        return this.ticketComponent.getUsersWithTickets(nonExpiredOnly);
    }

    @Override
    public void invalidateTicket(String ticket) throws AuthenticationException {
        this.ticketComponent.invalidateTicketById(ticket);
    }

    @Override
    public int countTickets(boolean nonExpiredOnly) {
        return this.ticketComponent.countTickets(nonExpiredOnly);
    }

    @Override
    public int invalidateTickets(boolean expiredOnly) {
        return this.ticketComponent.invalidateTickets(expiredOnly);
    }

    @Override
    public void validate(String ticket) throws AuthenticationException {
        String currentUser = null;
        try {
            String tenant = this.getPrevalidationTenantDomain();
            this.clearCurrentSecurityContext();
            currentUser = this.ticketComponent.validateTicket(ticket);
            this.authenticationComponent.setCurrentUser(currentUser, AuthenticationComponent.UserNameValidationMode.NONE);
            if (tenant == null) {
                Pair userTenant = AuthenticationUtil.getUserTenant((String)currentUser);
                tenant = (String)userTenant.getSecond();
            }
            TenantContextHolder.setTenantDomain((String)tenant);
        }
        catch (AuthenticationException ae) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exception validating ticket: " + ticket + ", cause:" + ae.getMessage()), (Throwable)ae);
            }
            this.clearCurrentSecurityContext();
            throw ae;
        }
    }

    protected String getPrevalidationTenantDomain() {
        return null;
    }

    @Override
    public String getCurrentTicket() throws AuthenticationException {
        String userName = this.getCurrentUserName();
        String ticket = this.ticketComponent.getCurrentTicket(userName, false);
        if (ticket == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Ticket was null, but, if we got through the authentication check, then it's safe to issue a new ticket for user: " + AuthenticationUtil.maskUsername((String)userName)));
            }
            return this.getNewTicket();
        }
        return ticket;
    }

    @Override
    public String getNewTicket() {
        String userName = this.getCurrentUserName();
        try {
            this.preAuthenticationCheck(userName);
        }
        catch (AuthenticationException e) {
            this.clearCurrentSecurityContext();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exception in pre authentication check: " + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
        return this.ticketComponent.getNewTicket(userName);
    }

    @Override
    public void clearCurrentSecurityContext() {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.ticketComponent.clearCurrentTicket();
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        return this.authenticationComponent.isSystemUserName(this.getCurrentUserName());
    }

    @Override
    public void authenticateAsGuest() throws AuthenticationException {
        String defaultGuestName = AuthenticationUtil.getGuestUserName();
        if (defaultGuestName == null || defaultGuestName.length() == 0) {
            throw new AuthenticationException("Guest authentication not supported");
        }
        this.preAuthenticationCheck(defaultGuestName);
        this.authenticationComponent.setGuestUserAsCurrentUser();
        String guestUser = this.authenticationComponent.getCurrentUserName();
        this.ticketComponent.clearCurrentTicket();
        this.ticketComponent.getCurrentTicket(guestUser, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Authenticated as guest: " + guestUser));
        }
    }

    @Override
    public boolean guestUserAuthenticationAllowed() {
        return this.authenticationComponent.guestUserAuthenticationAllowed();
    }

    public boolean getAllowsUserCreation() {
        return this.allowsUserCreation;
    }

    public void setAllowsUserCreation(boolean allowsUserCreation) {
        this.allowsUserCreation = allowsUserCreation;
    }

    public boolean getAllowsUserDeletion() {
        return this.allowsUserDeletion;
    }

    public void setAllowsUserDeletion(boolean allowsUserDeletion) {
        this.allowsUserDeletion = allowsUserDeletion;
    }

    public boolean getAllowsUserPasswordChange() {
        return this.allowsUserPasswordChange;
    }

    public void setAllowsUserPasswordChange(boolean allowsUserPasswordChange) {
        this.allowsUserPasswordChange = allowsUserPasswordChange;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public Set<String> getDomains() {
        return Collections.singleton(this.getDomain());
    }

    @Override
    public Set<String> getDomainsThatAllowUserCreation() {
        if (this.getAllowsUserCreation()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDomainsThatAllowUserDeletion() {
        if (this.getAllowsUserDeletion()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDomiansThatAllowUserPasswordChanges() {
        if (this.getAllowsUserPasswordChange()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<TicketComponent> getTicketComponents() {
        return Collections.singleton(this.ticketComponent);
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        return this.authenticationComponent.getDefaultAdministratorUserNames();
    }

    @Override
    public Set<String> getDefaultGuestUserNames() {
        return this.authenticationComponent.getDefaultGuestUserNames();
    }

    @Override
    public boolean authenticationExists(String userName) {
        return true;
    }

    @Override
    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        if (this.personService != null && this.personService.personExists(userName)) {
            return this.personService.isEnabled(userName);
        }
        return true;
    }
}

