/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryFactory;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class CommentServiceImpl
extends AbstractLifecycleBean
implements CommentService,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(CommentServiceImpl.class);
    private static final QName FORUM_TO_TOPIC_ASSOC_QNAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments");
    private static final String COMMENTS_TOPIC_NAME = "Comments";
    private static final String CANNED_QUERY_GET_CHILDREN = "commentsGetChildrenCannedQueryFactory";
    private NodeService nodeService;
    private ContentService contentService;
    private ActivityService activityService;
    private SiteService siteService;
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private PermissionService permissionService;
    private LockService lockService;
    private DictionaryService dictionaryService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        ApplicationContext ctx = this.getApplicationContext();
        if (ctx != null) {
            if (this.nodeService == null) {
                this.nodeService = (NodeService)ctx.getBean("NodeService");
            }
            if (this.contentService == null) {
                this.contentService = (ContentService)ctx.getBean("ContentService");
            }
            if (this.siteService == null) {
                this.siteService = (SiteService)ctx.getBean("SiteService");
            }
            if (this.activityService == null) {
                this.activityService = (ActivityService)ctx.getBean("activityService");
            }
            if (this.cannedQueryRegistry == null) {
                this.cannedQueryRegistry = (NamedObjectRegistry)ctx.getBean("commentsCannedQueryRegistry");
            }
            if (this.policyComponent == null) {
                this.policyComponent = (PolicyComponent)ctx.getBean("policyComponent");
            }
            if (this.behaviourFilter == null) {
                this.behaviourFilter = (BehaviourFilter)ctx.getBean("policyBehaviourFilter");
            }
            if (this.permissionService == null) {
                this.permissionService = (PermissionService)ctx.getBean("PermissionService");
            }
            if (this.lockService == null) {
                this.lockService = (LockService)ctx.getBean("LockService");
            }
            if (this.dictionaryService == null) {
                this.dictionaryService = (DictionaryService)ctx.getBean("DictionaryService");
            }
        }
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ForumModel.TYPE_POST, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ForumModel.TYPE_POST, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    @Override
    public NodeRef getDiscussableAncestor(NodeRef descendantNodeRef) {
        NodeRef discussableNode;
        NodeRef forumNode;
        ChildAssociationRef forumToTopicChildAssocRef;
        NodeRef topicNode;
        NodeRef result = null;
        if (this.nodeService.getType(descendantNodeRef).equals((Object)ForumModel.TYPE_POST) && this.nodeService.getType(topicNode = this.nodeService.getPrimaryParent(descendantNodeRef).getParentRef()).equals((Object)ForumModel.TYPE_TOPIC) && (forumToTopicChildAssocRef = this.nodeService.getPrimaryParent(topicNode)).getQName().equals((Object)FORUM_TO_TOPIC_ASSOC_QNAME) && this.nodeService.getType(forumNode = forumToTopicChildAssocRef.getParentRef()).equals((Object)ForumModel.TYPE_FORUM) && this.nodeService.hasAspect(discussableNode = this.nodeService.getPrimaryParent(forumNode).getParentRef(), ForumModel.ASPECT_DISCUSSABLE)) {
            result = discussableNode;
        }
        return result;
    }

    @Override
    public PagingResults<NodeRef> listComments(NodeRef discussableNode, PagingRequest paging) {
        NodeRef commentsFolder = this.getShareCommentsTopic(discussableNode);
        if (commentsFolder != null) {
            ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
            sort.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)false));
            GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN));
            GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(commentsFolder, null, null, null, null, sort, paging);
            final CannedQueryResults results = cq.execute();
            List comments = Collections.emptyList();
            if (results.getPageCount() > 0) {
                comments = (List)results.getPages().get(0);
            }
            final Pair totalCount = paging.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
            final ArrayList<NodeRef> page = new ArrayList<NodeRef>(comments.size());
            for (NodeRef comment : comments) {
                page.add(comment);
            }
            return new PagingResults<NodeRef>(){

                public String getQueryExecutionId() {
                    return results.getQueryExecutionId();
                }

                public List<NodeRef> getPage() {
                    return page;
                }

                public boolean hasMoreItems() {
                    return results.hasMoreItems();
                }

                public Pair<Integer, Integer> getTotalResultCount() {
                    return totalCount;
                }
            };
        }
        return new EmptyPagingResults();
    }

    @Override
    public NodeRef getShareCommentsTopic(NodeRef discussableNode) {
        NodeRef firstForumNode;
        List topics;
        List fora;
        NodeRef result = null;
        if (this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE) && !(fora = this.nodeService.getChildAssocs(discussableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)ForumModel.ASSOC_DISCUSSION, true)).isEmpty() && !(topics = this.nodeService.getChildAssocs(firstForumNode = ((ChildAssociationRef)fora.get(0)).getChildRef(), (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)FORUM_TO_TOPIC_ASSOC_QNAME, true)).isEmpty()) {
            NodeRef firstTopicNode;
            result = firstTopicNode = ((ChildAssociationRef)topics.get(0)).getChildRef();
        }
        return result;
    }

    private String getSiteId(final NodeRef nodeRef) {
        String siteId = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return CommentServiceImpl.this.siteService.getSiteShortName(nodeRef);
            }
        });
        return siteId;
    }

    private JSONObject getActivityData(String siteId, NodeRef nodeRef) {
        if (siteId != null) {
            JSONObject json = new JSONObject();
            json.put((Object)"title", (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            try {
                StringBuilder sb = new StringBuilder("document-details?nodeRef=");
                sb.append(URLEncoder.encode(nodeRef.toString(), "UTF-8"));
                json.put((Object)"page", (Object)sb.toString());
                json.put((Object)"nodeRef", (Object)nodeRef.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.warn((Object)"Unable to urlencode page for create comment activity");
            }
            return json;
        }
        logger.warn((Object)("Unable to determine site in which node " + String.valueOf(nodeRef) + " resides."));
        return null;
    }

    private void postActivity(String siteId, String activityType, JSONObject activityData) {
        if (activityData != null) {
            this.activityService.postActivity(activityType, siteId, "comments", activityData.toString());
        }
    }

    @Override
    public NodeRef createComment(NodeRef discussableNode, String title, String comment, boolean suppressRollups) {
        if (comment == null) {
            throw new IllegalArgumentException("Must provide a non-null comment");
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE)) {
            this.nodeService.addAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP) && !suppressRollups) {
            this.nodeService.addAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
        }
        NodeRef forumNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(discussableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = this.nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)FORUM_TO_TOPIC_ASSOC_QNAME);
        NodeRef topicNode = null;
        if (existingTopics.isEmpty()) {
            HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
            props.put(ContentModel.PROP_NAME, COMMENTS_TOPIC_NAME);
            topicNode = this.nodeService.createNode(forumNode, ContentModel.ASSOC_CONTAINS, FORUM_TO_TOPIC_ASSOC_QNAME, ForumModel.TYPE_TOPIC, props).getChildRef();
        } else {
            topicNode = ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        }
        NodeRef postNode = this.nodeService.createNode(topicNode, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ForumModel.TYPE_POST).getChildRef();
        this.nodeService.setProperty(postNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        this.nodeService.setProperty(postNode, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        ContentWriter writer = this.contentService.getWriter(postNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(comment);
        String siteId = this.getSiteId(discussableNode);
        JSONObject activityData = this.getActivityData(siteId, discussableNode);
        this.postActivity(siteId, "org.alfresco.comments.comment-created", activityData);
        return postNode;
    }

    @Override
    public void updateComment(NodeRef commentNodeRef, String title, String comment) {
        QName nodeType = this.nodeService.getType(commentNodeRef);
        if (!nodeType.equals((Object)ForumModel.TYPE_POST)) {
            throw new IllegalArgumentException("Node to update is not a comment node.");
        }
        try {
            ContentWriter writer = this.contentService.getWriter(commentNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/html");
            writer.putContent(comment);
        }
        catch (ContentIOException cioe) {
            Throwable cause = cioe.getCause();
            if (cause instanceof AccessDeniedException) {
                throw (AccessDeniedException)((Object)cause);
            }
            if (cause instanceof NodeLockedException) {
                throw (NodeLockedException)((Object)cause);
            }
            throw cioe;
        }
        if (title != null) {
            this.nodeService.setProperty(commentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        }
        String siteId = this.getSiteId(commentNodeRef);
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        if (discussableNodeRef != null) {
            JSONObject activityData = this.getActivityData(siteId, discussableNodeRef);
            this.postActivity(siteId, "org.alfresco.comments.comment-updated", activityData);
        } else {
            logger.warn((Object)("Unable to determine discussable node for the comment with nodeRef " + String.valueOf(commentNodeRef) + ", not posting an activity"));
        }
    }

    @Override
    public void deleteComment(NodeRef commentNodeRef) {
        QName nodeType = this.nodeService.getType(commentNodeRef);
        if (!nodeType.equals((Object)ForumModel.TYPE_POST)) {
            throw new IllegalArgumentException("Node to delete is not a comment node.");
        }
        String siteId = this.getSiteId(commentNodeRef);
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        JSONObject activityData = null;
        if (discussableNodeRef != null) {
            activityData = this.getActivityData(siteId, discussableNodeRef);
        }
        this.nodeService.deleteNode(commentNodeRef);
        if (activityData != null) {
            this.postActivity(siteId, "org.alfresco.comments.comment-deleted", activityData);
        } else {
            logger.warn((Object)("Unable to determine discussable node for the comment with nodeRef " + String.valueOf(commentNodeRef) + ", not posting an activity"));
        }
    }

    @Override
    public Map<String, Boolean> getCommentPermissions(NodeRef discussableNode, NodeRef commentNodeRef) {
        boolean canEdit = false;
        boolean canDelete = false;
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        if (discussableNodeRef.equals((Object)discussableNode) && (!this.isWorkingCopyOrLocked(discussableNode) || this.isLockOwner(discussableNode))) {
            canEdit = this.canEditPermission(commentNodeRef);
            canDelete = this.canDeletePermission(commentNodeRef);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        map.put("canEdit", canEdit);
        map.put("canDelete", canDelete);
        return map;
    }

    private boolean canEditPermission(NodeRef commentNodeRef) {
        boolean isCoordinator;
        String creator = (String)((Object)this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_CREATOR));
        Serializable owner = this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_OWNER);
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        boolean isSiteManager = this.permissionService.hasPermission(commentNodeRef, "SiteManager") == AccessStatus.ALLOWED;
        boolean bl = isCoordinator = this.permissionService.hasPermission(commentNodeRef, "Coordinator") == AccessStatus.ALLOWED;
        return isSiteManager || isCoordinator || currentUser.equals(creator) || currentUser.equals(owner);
    }

    private boolean canDeletePermission(NodeRef commentNodeRef) {
        return this.permissionService.hasPermission(commentNodeRef, "Delete") == AccessStatus.ALLOWED;
    }

    private boolean isLockOwner(NodeRef nodeRef) {
        return this.lockService.getLockStatus(nodeRef) == LockStatus.LOCK_OWNER;
    }

    private boolean isWorkingCopyOrLocked(NodeRef nodeRef) {
        LockStatus lockStatus;
        Set aspects;
        boolean isWorkingCopy = false;
        boolean isLocked = false;
        if (nodeRef != null && !(isWorkingCopy = (aspects = this.nodeService.getAspects(nodeRef)).contains(ContentModel.ASPECT_WORKING_COPY)) && aspects.contains(ContentModel.ASPECT_LOCKABLE) && ((lockStatus = this.lockService.getLockStatus(nodeRef)) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
            isLocked = true;
        }
        return isWorkingCopy || isLocked;
    }

    @Override
    public void onUpdateProperties(NodeRef commentNodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        if (discussableNodeRef != null) {
            boolean canEdit;
            if (this.behaviourFilter.isEnabled(ContentModel.ASPECT_LOCKABLE) && this.isWorkingCopyOrLocked(discussableNodeRef) && !this.isLockOwner(discussableNodeRef)) {
                List<QName> changedProperties = this.getChangedProperties(before, after);
                boolean commentUpdated = false;
                for (QName changedProperty : changedProperties) {
                    PropertyDefinition propertyDef = this.dictionaryService.getProperty(changedProperty);
                    if (propertyDef == null || !propertyDef.getContainerClass().getName().equals((Object)ContentModel.TYPE_CONTENT)) continue;
                    commentUpdated = true;
                    break;
                }
                if (commentUpdated) {
                    throw new NodeLockedException(discussableNodeRef);
                }
            }
            if (!(canEdit = this.canEditPermission(commentNodeRef))) {
                throw new AccessDeniedException("Cannot edit comment");
            }
        }
    }

    private List<QName> getChangedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        ArrayList<QName> results = new ArrayList<QName>();
        for (QName propQName : before.keySet()) {
            Serializable afterValue;
            if (!after.keySet().contains(propQName)) {
                results.add(propQName);
                continue;
            }
            Serializable beforeValue = before.get(propQName);
            if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)(afterValue = after.get(propQName)))) continue;
            results.add(propQName);
        }
        for (QName propQName : after.keySet()) {
            if (before.containsKey(propQName)) continue;
            results.add(propQName);
        }
        return results;
    }

    @Override
    public void beforeDeleteNode(NodeRef commentNodeRef) {
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        if (discussableNodeRef != null) {
            boolean canDelete = this.canDeletePermission(commentNodeRef);
            if (this.behaviourFilter.isEnabled(ContentModel.ASPECT_LOCKABLE) && this.isWorkingCopyOrLocked(discussableNodeRef) && !this.isLockOwner(discussableNodeRef) && canDelete) {
                throw new NodeLockedException(discussableNodeRef);
            }
            if (!canDelete) {
                throw new AccessDeniedException("Cannot delete comment");
            }
        }
    }
}

