/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.events.AbstractEventsService;
import org.alfresco.repo.events.ClientUtil;
import org.alfresco.repo.events.EventsService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.events.types.NodeAddedEvent;
import org.alfresco.sync.events.types.NodeCheckOutCancelledEvent;
import org.alfresco.sync.events.types.NodeCheckedInEvent;
import org.alfresco.sync.events.types.NodeCheckedOutEvent;
import org.alfresco.sync.events.types.NodeCommentedEvent;
import org.alfresco.sync.events.types.NodeContentGetEvent;
import org.alfresco.sync.events.types.NodeContentPutEvent;
import org.alfresco.sync.events.types.NodeFavouritedEvent;
import org.alfresco.sync.events.types.NodeLikedEvent;
import org.alfresco.sync.events.types.NodeLockedEvent;
import org.alfresco.sync.events.types.NodeMovedEvent;
import org.alfresco.sync.events.types.NodeRemovedEvent;
import org.alfresco.sync.events.types.NodeRenamedEvent;
import org.alfresco.sync.events.types.NodeTaggedEvent;
import org.alfresco.sync.events.types.NodeUnFavouritedEvent;
import org.alfresco.sync.events.types.NodeUnLikedEvent;
import org.alfresco.sync.events.types.NodeUnTaggedEvent;
import org.alfresco.sync.events.types.NodeUnlockedEvent;
import org.alfresco.sync.events.types.NodeUpdatedEvent;
import org.alfresco.sync.events.types.Property;
import org.alfresco.sync.events.types.authority.AuthorityAddedToGroupEvent;
import org.alfresco.sync.events.types.authority.AuthorityRemovedFromGroupEvent;
import org.alfresco.sync.events.types.authority.GroupDeletedEvent;
import org.alfresco.sync.events.types.permission.InheritPermissionsDisabledEvent;
import org.alfresco.sync.events.types.permission.InheritPermissionsEnabledEvent;
import org.alfresco.sync.events.types.permission.LocalPermissionGrantedEvent;
import org.alfresco.sync.events.types.permission.LocalPermissionRevokedEvent;
import org.alfresco.sync.events.types.recordsmanagement.FileClassifiedEvent;
import org.alfresco.sync.events.types.recordsmanagement.FileUnclassifiedEvent;
import org.alfresco.sync.events.types.recordsmanagement.RecordCreatedEvent;
import org.alfresco.sync.events.types.recordsmanagement.RecordRejectedEvent;
import org.alfresco.sync.repo.Client;
import org.alfresco.util.FileFilterMode;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventsServiceImpl
extends AbstractEventsService
implements EventsService {
    private static Log logger = LogFactory.getLog(EventsServiceImpl.class);
    private static final String RM_MODEL_PROP_NAME_RECORD_ORIGINATING_LOCATION = "PROP_RECORD_ORIGINATING_LOCATION";
    private static final String RECORDS_MANAGEMENT_MODEL = "org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel";
    public static QName PROP_RMA_RECORD_ORIGINATING_LOCATION = EventsServiceImpl.getRmPropOriginatingLocation();

    private NodeRenamedEvent nodeRenamedEvent(AbstractEventsService.NodeInfo nodeInfo, String oldName, String newName) {
        String username = AuthenticationUtil.getFullyAuthenticatedUser();
        String networkId = TenantUtil.getCurrentDomain();
        String objectId = nodeInfo.getNodeId();
        String siteId = nodeInfo.getSiteId();
        String txnId = AlfrescoTransactionSupport.getTransactionId();
        long timestamp = System.currentTimeMillis();
        Long modificationTime = nodeInfo.getModificationTimestamp();
        QName nodeTypeQName = nodeInfo.getType();
        String nodeType = nodeTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<List<String>> parentNodeIds = nodeInfo.getParentNodeIds();
        List<String> newPaths = nodeInfo.getPaths();
        List<String> paths = null;
        if (nodeTypeQName.equals((Object)SiteModel.TYPE_SITE)) {
            paths = newPaths;
        } else {
            nodeInfo.updateName(oldName);
            paths = nodeInfo.getPaths();
        }
        Set<String> aspects = nodeInfo.getAspectsAsStrings();
        Map<String, Serializable> properties = nodeInfo.getProperties();
        Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
        NodeRenamedEvent event = new NodeRenamedEvent(this.nextSequenceNumber(), oldName, newName, txnId, timestamp, networkId, siteId, objectId, nodeType, paths, parentNodeIds, username, modificationTime, newPaths, alfrescoClient, aspects, properties);
        return event;
    }

    @Override
    public void nodeMoved(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef nodeRef = newChildAssocRef.getChildRef();
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEMOVED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            NodeRef oldParentNodeRef = oldChildAssocRef.getParentRef();
            NodeRef newParentNodeRef = newChildAssocRef.getParentRef();
            NodeRef oldNodeRef = oldChildAssocRef.getChildRef();
            NodeRef newNodeRef = newChildAssocRef.getChildRef();
            String oldParentNodeName = (String)((Object)this.nodeService.getProperty(oldParentNodeRef, ContentModel.PROP_NAME));
            String newParentNodeName = (String)((Object)this.nodeService.getProperty(newParentNodeRef, ContentModel.PROP_NAME));
            String oldNodeName = (String)((Object)this.nodeService.getProperty(oldNodeRef, ContentModel.PROP_NAME));
            String newNodeName = (String)((Object)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_NAME));
            List newParentPaths = this.nodeService.getPaths(newParentNodeRef, false);
            List<String> newPaths = this.getPaths(newParentPaths, Arrays.asList(newParentNodeName, newNodeName));
            if (!oldParentNodeRef.equals((Object)newParentNodeRef)) {
                List<List<String>> toParentNodeIds = this.getNodeIds(newParentPaths);
                List oldParentPaths = this.nodeService.getPaths(oldParentNodeRef, false);
                List<String> previousPaths = this.getPaths(oldParentPaths, Arrays.asList(oldParentNodeName, oldNodeName));
                List<List<String>> previousParentNodeIds = this.getNodeIds(oldParentPaths);
                Set<String> aspects = nodeInfo.getAspectsAsStrings();
                Map<String, Serializable> properties = nodeInfo.getProperties();
                Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
                NodeMovedEvent event = new NodeMovedEvent(this.nextSequenceNumber(), oldNodeName, newNodeName, txnId, timestamp, networkId, siteId, objectId, nodeType, previousPaths, previousParentNodeIds, username, modificationTime, newPaths, toParentNodeIds, alfrescoClient, aspects, properties);
                this.sendEvent((Event)event);
            }
        }
    }

    @Override
    public void nodeRenamed(NodeRef nodeRef, String oldName, String newName) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODERENAMED");
        if (nodeInfo.checkNodeInfo()) {
            NodeRenamedEvent nodeRenamedEvent = this.nodeRenamedEvent(nodeInfo, oldName, newName);
            this.sendEvent((Event)nodeRenamedEvent);
        }
    }

    @Override
    public void nodeTagged(NodeRef nodeRef, String tag) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODETAGGED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            NodeTaggedEvent event = new NodeTaggedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, tag, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeTagRemoved(NodeRef nodeRef, String tag) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODETAGREMOVED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            NodeUnTaggedEvent event = new NodeUnTaggedEvent(this.nextSequenceNumber(), tag, name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeLiked(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODELIKED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            NodeLikedEvent event = new NodeLikedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeUnLiked(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEUNLIKED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            NodeUnLikedEvent event = new NodeUnLikedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeFavourited(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEFAVOURITED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            NodeFavouritedEvent event = new NodeFavouritedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeUnFavourited(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEUNFAVOURITED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            NodeUnFavouritedEvent event = new NodeUnFavouritedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeCreated(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEADDED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeAddedEvent event = new NodeAddedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void secondaryAssociationCreated(ChildAssociationRef secAssociation) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(secAssociation.getChildRef(), "NODEADDED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            NodeRef secParentNodeRef = secAssociation.getParentRef();
            String secParentNodeName = (String)((Object)this.nodeService.getProperty(secAssociation.getParentRef(), ContentModel.PROP_NAME));
            List secParentPath = this.nodeService.getPaths(secParentNodeRef, true);
            List<String> nodePaths = this.getPaths(secParentPath, Arrays.asList(secParentNodeName, name));
            List<List<String>> pathNodeIds = this.getNodeIds(secParentPath);
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeAddedEvent event = new NodeAddedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void secondaryAssociationDeleted(ChildAssociationRef secAssociation) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(secAssociation.getChildRef(), "NODEREMOVED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            NodeRef secParentNodeRef = secAssociation.getParentRef();
            String secParentNodeName = (String)((Object)this.nodeService.getProperty(secAssociation.getParentRef(), ContentModel.PROP_NAME));
            List secParentPath = this.nodeService.getPaths(secParentNodeRef, true);
            List<String> nodePaths = this.getPaths(secParentPath, Arrays.asList(secParentNodeName, name));
            List<List<String>> pathNodeIds = this.getNodeIds(secParentPath);
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeRemovedEvent event = new NodeRemovedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeDeleted(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEREMOVED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeRemovedEvent event = new NodeRemovedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeCommented(NodeRef nodeRef, String comment) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODECOMMENTED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeCommentedEvent event = new NodeCommentedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, comment, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeUpdated(NodeRef nodeRef, Map<String, Property> propertiesAdded, Set<String> propertiesRemoved, Map<String, Property> propertiesChanged, Set<String> aspectsAdded, Set<String> aspectsRemoved) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEUPDATED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeUpdatedEvent event = new NodeUpdatedEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, propertiesAdded, propertiesRemoved, propertiesChanged, aspectsAdded, aspectsRemoved, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void contentGet(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "CONTENTGET");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeContentGetEvent event = new NodeContentGetEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void contentWrite(NodeRef nodeRef, QName propertyQName, ContentData value) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "CONTENTPUT");
        if (nodeInfo.checkNodeInfo()) {
            String encoding;
            String mimeType;
            long size;
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            if (value != null) {
                size = value.getSize();
                mimeType = value.getMimetype();
                encoding = value.getEncoding();
            } else {
                size = 0L;
                mimeType = "";
                encoding = "";
            }
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeContentPutEvent event = new NodeContentPutEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, size, mimeType, encoding, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeCheckedOut(NodeRef workingCopyNodeRef) {
        AbstractEventsService.NodeInfo workingCopyNodeInfo = this.getNodeInfo(workingCopyNodeRef, "NODECHECKEDOUT");
        if (workingCopyNodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = workingCopyNodeInfo.getName();
            String objectId = workingCopyNodeInfo.getNodeId();
            String siteId = workingCopyNodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = workingCopyNodeInfo.getPaths();
            List<List<String>> pathNodeIds = workingCopyNodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = workingCopyNodeInfo.getModificationTimestamp();
            String nodeType = workingCopyNodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(workingCopyNodeInfo.getClient());
            String workingCopyNodeId = workingCopyNodeInfo.getNodeId();
            Set<String> aspects = workingCopyNodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = workingCopyNodeInfo.getProperties();
            NodeCheckedOutEvent event = new NodeCheckedOutEvent(this.nextSequenceNumber(), workingCopyNodeId, name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeCheckOutCancelled(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODECHECKOUTCANCELLED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeCheckOutCancelledEvent event = new NodeCheckOutCancelledEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeCheckedIn(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODECHECKEDIN");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String objectId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            NodeCheckedInEvent event = new NodeCheckedInEvent(this.nextSequenceNumber(), name, txnId, timestamp, networkId, siteId, objectId, nodeType, nodePaths, pathNodeIds, username, modificationTime, alfrescoClient, aspects, properties);
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void authorityRemovedFromGroup(String parentGroup, String childAuthority) {
        if (this.includeEventType("AUTHREMOVEDFROMGROUP")) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            long timestamp = System.currentTimeMillis();
            Client client = this.getAlfrescoClient(ClientUtil.from(FileFilterMode.getClient()));
            AuthorityRemovedFromGroupEvent event = AuthorityRemovedFromGroupEvent.builder().parentGroup(parentGroup).authorityName(childAuthority).seqNumber(this.nextSequenceNumber()).txnId(txnId).networkId(networkId).timestamp(timestamp).username(username).client(client).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void authorityAddedToGroup(String parentGroup, String childAuthority) {
        if (this.includeEventType("AUTHADDEDTOGROUP")) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            long timestamp = System.currentTimeMillis();
            Client client = this.getAlfrescoClient(ClientUtil.from(FileFilterMode.getClient()));
            AuthorityAddedToGroupEvent event = AuthorityAddedToGroupEvent.builder().parentGroup(parentGroup).authorityName(childAuthority).seqNumber(this.nextSequenceNumber()).txnId(txnId).networkId(networkId).timestamp(timestamp).username(username).client(client).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void groupDeleted(String groupName, boolean cascade) {
        if (this.includeEventType("GROUPDELETED")) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            long timestamp = System.currentTimeMillis();
            Client client = this.getAlfrescoClient(ClientUtil.from(FileFilterMode.getClient()));
            GroupDeletedEvent event = GroupDeletedEvent.builder().authorityName(groupName).cascade(cascade).seqNumber(this.nextSequenceNumber()).txnId(txnId).networkId(networkId).timestamp(timestamp).username(username).client(client).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void inheritPermissionsEnabled(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "INHERITPERMISSIONSENABLED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String nodeId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            InheritPermissionsEnabledEvent event = InheritPermissionsEnabledEvent.builder().seqNumber(this.nextSequenceNumber()).name(name).txnId(txnId).timestamp(timestamp).networkId(networkId).siteId(siteId).nodeId(nodeId).nodeType(nodeType).paths(nodePaths).parentNodeIds(pathNodeIds).username(username).nodeModificationTime(modificationTime).client(alfrescoClient).aspects(aspects).nodeProperties(properties).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void inheritPermissionsDisabled(NodeRef nodeRef, boolean async) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "INHERITPERMISSIONSDISABLED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String nodeId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            InheritPermissionsDisabledEvent event = InheritPermissionsDisabledEvent.builder().async(async).seqNumber(this.nextSequenceNumber()).name(name).txnId(txnId).timestamp(timestamp).networkId(networkId).siteId(siteId).nodeId(nodeId).nodeType(nodeType).paths(nodePaths).parentNodeIds(pathNodeIds).username(username).nodeModificationTime(modificationTime).client(alfrescoClient).aspects(aspects).nodeProperties(properties).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void revokeLocalPermissions(NodeRef nodeRef, String authority, String permission) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "LOCALPERMISSIONREVOKED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String nodeId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            LocalPermissionRevokedEvent event = LocalPermissionRevokedEvent.builder().authority(authority).permission(permission).seqNumber(this.nextSequenceNumber()).name(name).txnId(txnId).timestamp(timestamp).networkId(networkId).siteId(siteId).nodeId(nodeId).nodeType(nodeType).paths(nodePaths).parentNodeIds(pathNodeIds).username(username).nodeModificationTime(modificationTime).client(alfrescoClient).aspects(aspects).nodeProperties(properties).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void grantLocalPermission(NodeRef nodeRef, String authority, String permission) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "LOCALPERMISSIONGRANTED");
        if (nodeInfo.checkNodeInfo()) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            String networkId = TenantUtil.getCurrentDomain();
            String name = nodeInfo.getName();
            String nodeId = nodeInfo.getNodeId();
            String siteId = nodeInfo.getSiteId();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            List<String> nodePaths = nodeInfo.getPaths();
            List<List<String>> pathNodeIds = nodeInfo.getParentNodeIds();
            long timestamp = System.currentTimeMillis();
            Long modificationTime = nodeInfo.getModificationTimestamp();
            String nodeType = nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Client alfrescoClient = this.getAlfrescoClient(nodeInfo.getClient());
            Set<String> aspects = nodeInfo.getAspectsAsStrings();
            Map<String, Serializable> properties = nodeInfo.getProperties();
            LocalPermissionGrantedEvent event = LocalPermissionGrantedEvent.builder().authority(authority).permission(permission).seqNumber(this.nextSequenceNumber()).name(name).txnId(txnId).timestamp(timestamp).networkId(networkId).siteId(siteId).nodeId(nodeId).nodeType(nodeType).paths(nodePaths).parentNodeIds(pathNodeIds).username(username).nodeModificationTime(modificationTime).client(alfrescoClient).aspects(aspects).nodeProperties(properties).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void fileUnclassified(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "FILEUNCLASSIFIED");
        if (nodeInfo.checkNodeInfo()) {
            FileUnclassifiedEvent event = FileUnclassifiedEvent.builder().seqNumber(this.nextSequenceNumber()).name(nodeInfo.getName()).txnId(AlfrescoTransactionSupport.getTransactionId()).timestamp(System.currentTimeMillis()).networkId(TenantUtil.getCurrentDomain()).siteId(nodeInfo.getSiteId()).nodeId(nodeInfo.getNodeId()).nodeType(nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService)).paths(nodeInfo.getPaths()).parentNodeIds(nodeInfo.getParentNodeIds()).username(AuthenticationUtil.getFullyAuthenticatedUser()).nodeModificationTime(nodeInfo.getModificationTimestamp()).client(this.getAlfrescoClient(nodeInfo.getClient())).aspects(nodeInfo.getAspectsAsStrings()).nodeProperties(nodeInfo.getProperties()).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void fileClassified(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "FILECLASSIFIED");
        if (nodeInfo.checkNodeInfo()) {
            FileClassifiedEvent event = FileClassifiedEvent.builder().seqNumber(this.nextSequenceNumber()).name(nodeInfo.getName()).txnId(AlfrescoTransactionSupport.getTransactionId()).timestamp(System.currentTimeMillis()).networkId(TenantUtil.getCurrentDomain()).siteId(nodeInfo.getSiteId()).nodeId(nodeInfo.getNodeId()).nodeType(nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService)).paths(nodeInfo.getPaths()).parentNodeIds(nodeInfo.getParentNodeIds()).username(AuthenticationUtil.getFullyAuthenticatedUser()).nodeModificationTime(nodeInfo.getModificationTimestamp()).client(this.getAlfrescoClient(nodeInfo.getClient())).aspects(nodeInfo.getAspectsAsStrings()).nodeProperties(nodeInfo.getProperties()).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void recordRejected(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "RECORDREJECTED");
        if (nodeInfo.checkNodeInfo()) {
            if (PROP_RMA_RECORD_ORIGINATING_LOCATION == null) {
                logger.error((Object)String.format("Could not generate %s event for node %s because %s property is not found.", "RECORDREJECTED", nodeRef, RM_MODEL_PROP_NAME_RECORD_ORIGINATING_LOCATION));
                return;
            }
            NodeRef recordOriginatingLocation = (NodeRef)this.nodeService.getProperty(nodeRef, PROP_RMA_RECORD_ORIGINATING_LOCATION);
            String recordOriginatingParentName = (String)((Object)this.nodeService.getProperty(recordOriginatingLocation, ContentModel.PROP_NAME));
            Path originatingParentPath = this.nodeService.getPath(recordOriginatingLocation);
            RecordRejectedEvent event = RecordRejectedEvent.builder().seqNumber(this.nextSequenceNumber()).name(nodeInfo.getName()).txnId(AlfrescoTransactionSupport.getTransactionId()).timestamp(System.currentTimeMillis()).networkId(TenantUtil.getCurrentDomain()).siteId(nodeInfo.getSiteId()).nodeId(nodeInfo.getNodeId()).nodeType(nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService)).paths(this.getPaths(Collections.singletonList(originatingParentPath), Arrays.asList(recordOriginatingParentName, nodeInfo.getName()))).parentNodeIds(this.getNodeIds(Collections.singletonList(originatingParentPath))).username(AuthenticationUtil.getFullyAuthenticatedUser()).nodeModificationTime(nodeInfo.getModificationTimestamp()).client(this.getAlfrescoClient(nodeInfo.getClient())).aspects(nodeInfo.getAspectsAsStrings()).nodeProperties(nodeInfo.getProperties()).build();
            this.sendEvent((Event)event);
        }
    }

    private static QName getRmPropOriginatingLocation() {
        QName originatingLocation = null;
        try {
            Class recordsManagementModel = ClassUtils.getClass((String)RECORDS_MANAGEMENT_MODEL);
            originatingLocation = (QName)FieldUtils.readStaticField((Class)recordsManagementModel, (String)RM_MODEL_PROP_NAME_RECORD_ORIGINATING_LOCATION);
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            logger.info((Object)String.format("Could not retrieve property %s from class %s. Maybe RM isn't installed, the property %s will be null.", RM_MODEL_PROP_NAME_RECORD_ORIGINATING_LOCATION, RECORDS_MANAGEMENT_MODEL, "PROP_RMA_RECORD_ORIGINATING_LOCATION"));
        }
        return originatingLocation;
    }

    @Override
    public void recordCreated(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "RECORDCREATED");
        if (nodeInfo.checkNodeInfo()) {
            List allPaths = this.nodeService.getPaths(nodeRef, false);
            Path primaryPath = this.nodeService.getPath(nodeRef);
            if (allPaths.size() >= 2) {
                allPaths.remove(primaryPath);
            }
            List<Path> recordPath = Collections.singletonList((Path)allPaths.get(0));
            RecordCreatedEvent event = RecordCreatedEvent.builder().seqNumber(this.nextSequenceNumber()).name(nodeInfo.getName()).txnId(AlfrescoTransactionSupport.getTransactionId()).timestamp(System.currentTimeMillis()).networkId(TenantUtil.getCurrentDomain()).siteId(nodeInfo.getSiteId()).nodeId(nodeInfo.getNodeId()).nodeType(nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService)).paths(this.getPaths(recordPath, Arrays.asList(nodeInfo.getName()))).parentNodeIds(this.getNodeIdsFromParent(recordPath)).username(AuthenticationUtil.getFullyAuthenticatedUser()).nodeModificationTime(nodeInfo.getModificationTimestamp()).client(this.getAlfrescoClient(nodeInfo.getClient())).aspects(nodeInfo.getAspectsAsStrings()).nodeProperties(nodeInfo.getProperties()).build();
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeLocked(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODELOCKED");
        if (nodeInfo.checkNodeInfo()) {
            NodeLockedEvent event = new NodeLockedEvent(this.nextSequenceNumber(), nodeInfo.getName(), AlfrescoTransactionSupport.getTransactionId(), System.currentTimeMillis(), TenantUtil.getCurrentDomain(), nodeInfo.getSiteId(), nodeInfo.getNodeId(), nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService), nodeInfo.getPaths(), nodeInfo.getParentNodeIds(), AuthenticationUtil.getFullyAuthenticatedUser(), nodeInfo.getModificationTimestamp(), this.getAlfrescoClient(nodeInfo.getClient()), nodeInfo.getAspectsAsStrings(), nodeInfo.getProperties());
            this.sendEvent((Event)event);
        }
    }

    @Override
    public void nodeUnlocked(NodeRef nodeRef) {
        AbstractEventsService.NodeInfo nodeInfo = this.getNodeInfo(nodeRef, "NODEUNLOCKED");
        if (nodeInfo.checkNodeInfo()) {
            NodeUnlockedEvent event = new NodeUnlockedEvent(this.nextSequenceNumber(), nodeInfo.getName(), AlfrescoTransactionSupport.getTransactionId(), System.currentTimeMillis(), TenantUtil.getCurrentDomain(), nodeInfo.getSiteId(), nodeInfo.getNodeId(), nodeInfo.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService), nodeInfo.getPaths(), nodeInfo.getParentNodeIds(), AuthenticationUtil.getFullyAuthenticatedUser(), nodeInfo.getModificationTimestamp(), this.getAlfrescoClient(nodeInfo.getClient()), nodeInfo.getAspectsAsStrings(), nodeInfo.getProperties());
            this.sendEvent((Event)event);
        }
    }
}

