/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.calendar.CalendarEntryImpl;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQuery;
import org.alfresco.repo.calendar.cannedqueries.GetCalendarEntriesCannedQueryFactory;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropBoolean;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryFactory;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.calendar.CalendarService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarServiceImpl
implements CalendarService {
    public static final String CALENDAR_COMPONENT = "calendar";
    private static final int MAX_QUERY_ENTRY_COUNT = 10000;
    protected static final String CANNED_QUERY_GET_CHILDREN = "calendarGetChildrenCannedQueryFactory";
    protected static final String CANNED_QUERY_GET_ENTRIES = "calendarGetCalendarEntriesCannedQueryFactory";
    private static Log logger = LogFactory.getLog(CalendarServiceImpl.class);
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private SiteService siteService;
    private TaggingService taggingService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    protected NodeRef getSiteCalendarContainer(String siteShortName, boolean create) {
        return SiteServiceImpl.getSiteContainer(siteShortName, CALENDAR_COMPONENT, create, this.siteService, this.transactionService, this.taggingService);
    }

    @Override
    public CalendarEntry getCalendarEntry(String siteShortName, String entryName) {
        NodeRef container = this.getSiteCalendarContainer(siteShortName, false);
        if (container == null) {
            return null;
        }
        NodeRef event = this.nodeService.getChildByName(container, ContentModel.ASSOC_CONTAINS, entryName);
        return this.getCalendarEntry(event, entryName, container);
    }

    private CalendarEntry getCalendarEntry(NodeRef event, String entryName, NodeRef container) {
        if (event != null) {
            CalendarEntryImpl entry = new CalendarEntryImpl(event, container, entryName);
            entry.populate(this.nodeService.getProperties(event));
            entry.setTags(this.taggingService.getTags(event));
            return entry;
        }
        return null;
    }

    @Override
    public CalendarEntry createCalendarEntry(String siteShortName, CalendarEntry entry) {
        CalendarEntryImpl entryImpl;
        if (entry.getNodeRef() != null) {
            throw new IllegalArgumentException("Can't call create for a calendar entry that was previously persisted");
        }
        NodeRef container = this.getSiteCalendarContainer(siteShortName, true);
        Map<QName, Serializable> properties = CalendarEntryImpl.toNodeProperties(entry);
        String name = new Date().getTime() + "-" + Math.round(Math.random() * 10000.0) + ".ics";
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        NodeRef nodeRef = this.nodeService.createNode(container, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), CalendarModel.TYPE_EVENT, properties).getChildRef();
        if (entry instanceof CalendarEntryImpl) {
            entryImpl = (CalendarEntryImpl)entry;
            entryImpl.recordStorageDetails(nodeRef, container, name);
        } else {
            entryImpl = new CalendarEntryImpl(nodeRef, container, name);
            entryImpl.populate(properties);
            entryImpl.setTags(entry.getTags());
        }
        Date createdAt = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED);
        entryImpl.setCreatedAt(createdAt);
        entryImpl.setModifiedAt(createdAt);
        this.taggingService.setTags(nodeRef, entry.getTags());
        return entryImpl;
    }

    @Override
    public CalendarEntry updateCalendarEntry(CalendarEntry entry) {
        if (entry.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't update a calendar entry that was never persisted, call create instead");
        }
        Map<QName, Serializable> properties = CalendarEntryImpl.toNodeProperties(entry);
        for (Map.Entry prop : this.nodeService.getProperties(entry.getNodeRef()).entrySet()) {
            if (((QName)prop.getKey()).getNamespaceURI().equals("http://www.alfresco.org/model/calendar")) continue;
            properties.put((QName)prop.getKey(), (Serializable)prop.getValue());
        }
        this.nodeService.setProperties(entry.getNodeRef(), properties);
        this.taggingService.setTags(entry.getNodeRef(), entry.getTags());
        if (entry instanceof CalendarEntryDTO) {
            ((CalendarEntryDTO)entry).setModifiedAt((Date)this.nodeService.getProperty(entry.getNodeRef(), ContentModel.PROP_MODIFIED));
            return entry;
        }
        return this.getCalendarEntry(entry.getNodeRef(), entry.getSystemName(), entry.getContainerNodeRef());
    }

    @Override
    public void deleteCalendarEntry(CalendarEntry entry) {
        if (entry.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't delete a calendar entry that was never persisted");
        }
        this.nodeService.deleteNode(entry.getNodeRef());
    }

    @Override
    public PagingResults<CalendarEntry> listCalendarEntries(String siteShortName, PagingRequest paging) {
        NodeRef container = this.getSiteCalendarContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
        sort.add(new Pair((Object)CalendarModel.PROP_FROM_DATE, (Object)true));
        sort.add(new Pair((Object)CalendarModel.PROP_TO_DATE, (Object)true));
        sort.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)true));
        HashSet<QName> types = new HashSet<QName>();
        types.add(CalendarModel.TYPE_EVENT);
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN));
        GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(container, null, null, types, null, sort, paging);
        CannedQueryResults results = cq.execute();
        return this.wrap((PagingResults<NodeRef>)results, container);
    }

    @Override
    public PagingResults<CalendarEntry> listCalendarEntries(String[] siteShortNames, PagingRequest paging) {
        if (siteShortNames != null && siteShortNames.length == 1) {
            return this.listCalendarEntries(siteShortNames[0], paging);
        }
        return this.listCalendarEntries(siteShortNames, null, null, paging);
    }

    @Override
    public PagingResults<CalendarEntry> listCalendarEntries(String[] siteShortNames, Date from, Date to, PagingRequest paging) {
        ArrayList<NodeRef> containersL = new ArrayList<NodeRef>();
        String[] stringArray = siteShortNames;
        int n = siteShortNames.length;
        int n2 = 0;
        while (n2 < n) {
            String siteShortName = stringArray[n2];
            NodeRef container = this.getSiteCalendarContainer(siteShortName, false);
            if (container != null) {
                containersL.add(container);
            }
            ++n2;
        }
        NodeRef[] containers = containersL.toArray(new NodeRef[containersL.size()]);
        if (containers.length == 0) {
            return new EmptyPagingResults();
        }
        GetCalendarEntriesCannedQueryFactory cqFactory = (GetCalendarEntriesCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_ENTRIES));
        GetCalendarEntriesCannedQuery cq = (GetCalendarEntriesCannedQuery)cqFactory.getCannedQuery(containers, from, to, paging);
        return cq.execute();
    }

    @Override
    public PagingResults<CalendarEntry> listOutlookCalendarEntries(String siteShortName, String outlookUID, PagingRequest paging) {
        NodeRef container = this.getSiteCalendarContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
        sort.add(new Pair((Object)CalendarModel.PROP_FROM_DATE, (Object)true));
        sort.add(new Pair((Object)CalendarModel.PROP_TO_DATE, (Object)true));
        HashSet<QName> types = new HashSet<QName>();
        types.add(CalendarModel.TYPE_EVENT);
        ArrayList<FilterProp> filters = new ArrayList<FilterProp>();
        if (outlookUID != null) {
            filters.add(new FilterPropString(CalendarModel.PROP_OUTLOOK_UID, outlookUID, FilterPropString.FilterTypeString.EQUALS));
        } else {
            filters.add(new FilterPropBoolean(CalendarModel.PROP_IS_OUTLOOK, Boolean.TRUE));
        }
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN));
        GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(container, null, null, types, filters, sort, paging);
        CannedQueryResults results = cq.execute();
        return this.wrap((PagingResults<NodeRef>)results, container);
    }

    private PagingResults<CalendarEntry> wrap(final PagingResults<NodeRef> results, final NodeRef container) {
        this.nodeDAO.cacheNodes(results.getPage());
        return new PagingResults<CalendarEntry>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<CalendarEntry> getPage() {
                ArrayList<CalendarEntry> entries = new ArrayList<CalendarEntry>();
                for (NodeRef nodeRef : results.getPage()) {
                    String entryName = (String)((Object)CalendarServiceImpl.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    CalendarEntryImpl entry = new CalendarEntryImpl(nodeRef, container, entryName);
                    entry.populate(CalendarServiceImpl.this.nodeService.getProperties(nodeRef));
                    entry.setTags(CalendarServiceImpl.this.taggingService.getTags(nodeRef));
                    entries.add(entry);
                }
                return entries;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
    }
}

