/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.MetadataLoader;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.AbstractNodeImporter;
import org.alfresco.repo.bulkimport.impl.AbstractNodeImporterFactory;
import org.alfresco.repo.bulkimport.impl.BulkImportStatusImpl;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Triple;

public class StreamingNodeImporterFactory
extends AbstractNodeImporterFactory {
    public NodeImporter getNodeImporter(File sourceFolder) {
        StreamingNodeImporter nodeImporter = new StreamingNodeImporter();
        nodeImporter.setNodeService(this.nodeService);
        nodeImporter.setBehaviourFilter(this.behaviourFilter);
        nodeImporter.setFileFolderService(this.fileFolderService);
        nodeImporter.setMetadataLoader(this.metadataLoader);
        nodeImporter.setVersionService(this.versionService);
        nodeImporter.setImportStatus(this.importStatus);
        nodeImporter.setSourceFolder(sourceFolder);
        return nodeImporter;
    }

    private static class StreamingNodeImporter
    extends AbstractNodeImporter {
        private File sourceFolder;

        private StreamingNodeImporter() {
        }

        public void setSourceFolder(File sourceFolder) {
            this.sourceFolder = sourceFolder;
        }

        @Override
        protected final void importContentAndMetadata(NodeRef nodeRef, ImportableItem.ContentAndMetadata contentAndMetadata, MetadataLoader.Metadata metadata) {
            if (contentAndMetadata.contentFileExists()) {
                String filename = this.getFileName(contentAndMetadata.getContentFile());
                if (AbstractNodeImporter.logger.isDebugEnabled()) {
                    AbstractNodeImporter.logger.debug((Object)("Streaming contents of file '" + filename + "' into node '" + nodeRef.toString() + "'."));
                }
                ContentWriter writer = this.fileFolderService.getWriter(nodeRef);
                try {
                    writer.putContent(Files.newInputStream(contentAndMetadata.getContentFile(), new OpenOption[0]));
                }
                catch (IOException e) {
                    throw new ContentIOException("Failed to copy content from file: \n   writer: " + String.valueOf(writer) + "\n   file: " + String.valueOf(contentAndMetadata.getContentFile()), (Throwable)e);
                }
            } else if (AbstractNodeImporter.logger.isDebugEnabled()) {
                AbstractNodeImporter.logger.debug((Object)("No content to stream into node '" + nodeRef.toString() + "' - importing metadata only."));
            }
            this.importImportableItemMetadata(nodeRef, contentAndMetadata.getContentFile(), metadata);
        }

        @Override
        protected NodeRef importImportableItemImpl(ImportableItem importableItem, BulkImportParameters.ExistingFileMode existingFileMode) {
            NodeRef target = importableItem.getParent().getNodeRef();
            if (target == null) {
                throw new AlfrescoRuntimeException("Bulk importer: target is not known for importable item: " + String.valueOf(importableItem.getParent()));
            }
            NodeRef result = null;
            MetadataLoader.Metadata metadata = this.loadMetadata(importableItem.getHeadRevision());
            Triple<NodeRef, Boolean, BulkImportStatusImpl.NodeState> node = this.createOrFindNode(target, importableItem, existingFileMode, metadata);
            boolean isDirectory = node.getSecond() == null ? false : (Boolean)node.getSecond();
            BulkImportStatusImpl.NodeState nodeState = (BulkImportStatusImpl.NodeState)((Object)node.getThird());
            result = (NodeRef)node.getFirst();
            if (result != null && nodeState != BulkImportStatusImpl.NodeState.SKIPPED) {
                int numVersionProperties = 0;
                this.importStatus.incrementImportableItemsRead(importableItem, isDirectory);
                if (isDirectory) {
                    this.importImportableItemDirectory(result, importableItem, metadata);
                } else {
                    numVersionProperties = this.importImportableItemFile(result, importableItem, metadata, nodeState, existingFileMode);
                }
                this.importStatus.incrementNodesWritten(importableItem, isDirectory, nodeState, metadata.getProperties().size() + 4, numVersionProperties);
                this.importStatus.incrementContentBytesWritten(importableItem, isDirectory, nodeState);
            } else if (isDirectory) {
                this.skipImportableDirectory(importableItem);
            } else {
                this.skipImportableFile(importableItem);
            }
            return result;
        }

        @Override
        public File getSourceFolder() {
            return this.sourceFolder;
        }
    }
}

