/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CmisActivityPoster;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityInfo;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.repo.Client;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ActivityPosterImpl
implements CmisActivityPoster,
InitializingBean {
    private static final String APP_TOOL = "CMIS";
    public static final char PathSeperatorChar = '/';
    private static Log logger = LogFactory.getLog(CmisActivityPoster.class);
    private ActivityPoster poster;
    private SiteService siteService;
    private TenantService tenantService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private HiddenAspect hiddenAspect;
    private boolean activitiesEnabled = true;

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setActivitiesEnabled(boolean activitiesEnabled) {
        this.activitiesEnabled = activitiesEnabled;
    }

    public void setPoster(ActivityPoster poster) {
        this.poster = poster;
    }

    private final String getPathFromNode(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null || nodeRef == null) {
            throw new IllegalArgumentException("Invalid node(s) in getPathFromNode call");
        }
        if (rootNodeRef.equals((Object)nodeRef)) {
            return "";
        }
        List<FileInfo> pathInfos = this.fileFolderService.getNamePath(rootNodeRef, nodeRef);
        StringBuilder sb = new StringBuilder(pathInfos.size() * 20);
        for (FileInfo fileInfo : pathInfos) {
            sb.append('/');
            sb.append(fileInfo.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Build name path for node: \n   root: " + String.valueOf(rootNodeRef) + "\n   target: " + String.valueOf(nodeRef) + "\n   path: " + String.valueOf(sb)));
        }
        return sb.toString();
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"poster", (Object)this.poster);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
    }

    private String getCurrentTenantDomain() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (tenantDomain == null) {
            return "";
        }
        return tenantDomain;
    }

    private boolean isFolder(NodeRef nodeRef) {
        QName typeQName = this.nodeService.getType(nodeRef);
        FileFolderServiceType type = this.fileFolderService.getType(typeQName);
        boolean isFolder = type.equals((Object)FileFolderServiceType.FOLDER);
        return isFolder;
    }

    @Override
    public void postFileFolderAdded(NodeRef nodeRef) {
        if (this.activitiesEnabled && !this.hiddenAspect.hasHiddenAspect(nodeRef)) {
            String siteId;
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
            if (siteId != null && !siteId.equals("")) {
                String name;
                boolean isFolder;
                String path;
                NodeRef parentNodeRef;
                block5: {
                    parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                    path = null;
                    isFolder = this.isFolder(nodeRef);
                    name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    if (isFolder) {
                        NodeRef documentLibrary = this.siteService.getContainer(siteId, "documentLibrary");
                        path = "/";
                        try {
                            path = this.getPathFromNode(documentLibrary, nodeRef);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (!logger.isDebugEnabled()) break block5;
                            logger.debug((Object)"No documentLibrary container found.");
                        }
                    }
                }
                FileInfo fileInfo = this.fileFolderService.getFileInfo(nodeRef);
                this.poster.postFileFolderActivity(isFolder ? "org.alfresco.documentlibrary.folder-added" : "org.alfresco.documentlibrary.file-added", path, this.getCurrentTenantDomain(), siteId, parentNodeRef, nodeRef, name, APP_TOOL, Client.asType((Client.ClientType)Client.ClientType.cmis), fileInfo);
            }
        }
    }

    @Override
    public void postFileFolderUpdated(boolean isFolder, NodeRef nodeRef) {
        if (this.activitiesEnabled && !this.hiddenAspect.hasHiddenAspect(nodeRef)) {
            String siteId;
            SiteInfo siteInfo = this.getSiteAsSystem(nodeRef);
            String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
            if (siteId != null && !siteId.equals("")) {
                String fileName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                if (!isFolder) {
                    FileInfo fileInfo = this.fileFolderService.getFileInfo(nodeRef);
                    this.poster.postFileFolderActivity("org.alfresco.documentlibrary.file-updated", null, this.getCurrentTenantDomain(), siteId, null, nodeRef, fileName, APP_TOOL, Client.asType((Client.ClientType)Client.ClientType.cmis), fileInfo);
                }
            }
        }
    }

    @Override
    public void postFileFolderDeleted(ActivityInfo activityInfo) {
        if (this.activitiesEnabled && activityInfo.getSiteId() != null) {
            this.poster.postFileFolderActivity(activityInfo.isFolder() ? "org.alfresco.documentlibrary.folder-deleted" : "org.alfresco.documentlibrary.file-deleted", activityInfo.getParentPath(), this.getCurrentTenantDomain(), activityInfo.getSiteId(), activityInfo.getParentNodeRef(), activityInfo.getNodeRef(), activityInfo.getFileName(), APP_TOOL, Client.asType((Client.ClientType)Client.ClientType.cmis), null);
        }
    }

    @Override
    public ActivityInfo getActivityInfo(NodeRef nodeRef) {
        String siteId;
        SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
        if (siteId != null && !siteId.equals("")) {
            String parentPath;
            boolean isFolder;
            String name;
            NodeRef parentNodeRef;
            block3: {
                parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                FileInfo fileInfo = this.fileFolderService.getFileInfo(nodeRef);
                name = fileInfo.getName();
                isFolder = fileInfo.isFolder();
                NodeRef documentLibrary = this.siteService.getContainer(siteId, "documentLibrary");
                parentPath = "/";
                try {
                    parentPath = this.getPathFromNode(documentLibrary, parentNodeRef);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)"No documentLibrary container found.");
                }
            }
            return new ActivityInfo(nodeRef, parentPath, parentNodeRef, siteId, name, isFolder);
        }
        return null;
    }

    private SiteInfo getSiteAsSystem(final NodeRef nodeRef) {
        return (SiteInfo)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteInfo>(){

            public SiteInfo doWork() throws Exception {
                return ActivityPosterImpl.this.siteService.getSite(nodeRef);
            }
        });
    }
}

