/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class ConcurrentNodeServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"content");
    public static final QName ASPECT_QNAME_TEST_TITLED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"titled");
    public static final QName PROP_QNAME_TEST_TITLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"title");
    public static final QName PROP_QNAME_TEST_MIMETYPE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mimetype");
    public static final int COUNT = 10;
    public static final int REPEATS = 20;
    private static Log logger = LogFactory.getLog(ConcurrentNodeServiceTest.class);
    ApplicationContext ctx;
    private NodeService nodeService;
    private NodeDAO nodeDAO;
    private TransactionService transactionService;
    private NodeRef rootNodeRef;
    private AuthenticationComponent authenticationComponent;

    protected void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/systemModel.xml");
        ConcurrentNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        ConcurrentNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.nodeService = serviceRegistry.getNodeService();
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        this.transactionService = serviceRegistry.getTransactionService();
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> createRootNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef storeRef = ConcurrentNodeServiceTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                ConcurrentNodeServiceTest.this.rootNodeRef = ConcurrentNodeServiceTest.this.nodeService.getRootNode(storeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createRootNodeCallback);
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testMultiThreaded_PropertyWrites() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        QName[] properties = new QName[]{QName.createQName((String)"test1", (String)"MadeUp1"), QName.createQName((String)"test2", (String)"MadeUp2"), QName.createQName((String)"test3", (String)"MadeUp3"), QName.createQName((String)"test4", (String)"MadeUp4"), QName.createQName((String)"test5", (String)"MadeUp5")};
        final int[] propCounts = new int[properties.length];
        int propNum = 0;
        while (propNum < properties.length) {
            final QName property = properties[propNum];
            final int propNumFinal = propNum++;
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ConcurrentNodeServiceTest.this.nodeService.removeProperty(ConcurrentNodeServiceTest.this.rootNodeRef, property);
                    return null;
                }
            });
            Thread thread = new Thread(new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    logger.info((Object)("About to start updating property " + String.valueOf(property)));
                    AuthenticationUtil.setRunAsUserSystem();
                    int i = 0;
                    while (i < 1000) {
                        RetryingTransactionHelper.RetryingTransactionCallback<Integer> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                            public Integer execute() throws Throwable {
                                (this).ConcurrentNodeServiceTest.this.nodeDAO.setCheckNodeConsistency();
                                int current = 0;
                                Serializable obj = (this).ConcurrentNodeServiceTest.this.nodeService.getProperty((this).ConcurrentNodeServiceTest.this.rootNodeRef, property);
                                if (obj != null && obj instanceof Integer) {
                                    current = (Integer)obj;
                                }
                                (this).ConcurrentNodeServiceTest.this.nodeService.setProperty((this).ConcurrentNodeServiceTest.this.rootNodeRef, property, (Serializable)Integer.valueOf(++current));
                                int expectedCurrent = propCounts[propNumFinal];
                                if (expectedCurrent != current - 1) {
                                    System.out.println("Found difference: " + Thread.currentThread().getName() + " " + current);
                                }
                                return current;
                            }
                        };
                        try {
                            RetryingTransactionHelper txnHelper = ConcurrentNodeServiceTest.this.transactionService.getRetryingTransactionHelper();
                            txnHelper.setMaxRetries(1000);
                            Integer newCount = (Integer)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
                            propCounts[propNumFinal] = newCount;
                        }
                        catch (Throwable e) {
                            logger.error((Object)"Failed to set value: ", e);
                        }
                        ++i;
                    }
                    logger.info((Object)("Finished updating property " + String.valueOf(property)));
                }
            }, "Thread-" + String.valueOf(property));
            threads.add(thread);
            thread.start();
        }
        logger.info((Object)"Releasing the property update threads");
        for (Thread t : threads) {
            t.interrupt();
        }
        for (Thread t : threads) {
            t.join();
        }
        Map nodeProperties = this.nodeService.getProperties(this.rootNodeRef);
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        int i = 0;
        while (i < properties.length) {
            Integer n = (Integer)nodeProperties.get(properties[i]);
            if (n == null) {
                errors.add((CallSite)((Object)("\n   Prop " + String.valueOf(properties[i]) + " : " + String.valueOf(n))));
            } else if (!n.equals(1000)) {
                errors.add((CallSite)((Object)("\n   Prop " + String.valueOf(properties[i]) + " : " + String.valueOf(n))));
            }
            ++i;
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Incorrect counts recieved for 1000 loops.");
            for (String string : errors) {
                sb.append(string);
            }
            ConcurrentNodeServiceTest.fail((String)sb.toString());
        }
    }

    public void testMultithreaded_AspectWrites() throws Exception {
        Thread[] threads = new Thread[2];
        int i = 0;
        while (i < threads.length) {
            final String name = "Thread-" + i + "-";
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AuthenticationUtil.setRunAsUserSystem();
                    int loop = 0;
                    while (loop < 10) {
                        final String nameWithLoop = name + loop;
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> runCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                QName qname = QName.createQName((String)ConcurrentNodeServiceTest.NAMESPACE, (String)nameWithLoop);
                                (this).ConcurrentNodeServiceTest.this.nodeService.addAspect((this).ConcurrentNodeServiceTest.this.rootNodeRef, qname, null);
                                return null;
                            }
                        };
                        RetryingTransactionHelper txnHelper = ConcurrentNodeServiceTest.this.transactionService.getRetryingTransactionHelper();
                        txnHelper.setMaxRetries(40);
                        try {
                            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)runCallback);
                        }
                        catch (Throwable e) {
                            logger.error((Object)e);
                        }
                        ++loop;
                    }
                }
            };
            threads[i] = new Thread(runnable, name);
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            threads[i].join();
            ++i;
        }
        Set aspects = this.nodeService.getAspects(this.rootNodeRef);
        int i2 = 0;
        while (i2 < threads.length) {
            int j = 0;
            while (j < 10) {
                String nameWithLoop = "Thread-" + i2 + "-" + j;
                QName qname = QName.createQName((String)NAMESPACE, (String)nameWithLoop);
                ConcurrentNodeServiceTest.assertTrue((String)("Missing aspect: " + nameWithLoop), (boolean)aspects.contains(qname));
                ++j;
            }
            ++i2;
        }
    }
}

