/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.acegisecurity.AccessDeniedException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TestWithUserUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class CheckOutCheckInServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private CheckOutCheckInService cociService;
    private ContentService contentService;
    private VersionService versionService;
    private MutableAuthenticationService authenticationService;
    private LockService lockService;
    private TransactionService transactionService;
    private PermissionService permissionService;
    private CopyService copyService;
    private PersonService personService;
    private FileFolderService fileFolderService;
    private AuthenticationComponent authenticationComponent;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private String userNodeRef;
    private NodeRef folderNodeRef;
    private NodeRef fileNodeRef;
    private static final String TEST_VALUE_NAME = "myDocument.doc";
    private static final String TEST_VALUE_2 = "testValue2";
    private static final String TEST_VALUE_3 = "testValue3";
    private static final QName PROP_NAME_QNAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"name");
    private static final QName PROP2_QNAME = ContentModel.PROP_DESCRIPTION;
    private static final String CONTENT_1 = "This is some content";
    private static final String CONTENT_2 = "This is the cotent modified.";
    private String userName;
    private static final String PWD = "password";

    @Before
    public void before() {
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.versionService = (VersionService)this.applicationContext.getBean("versionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.copyService = (CopyService)this.applicationContext.getBean("copyService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.nodeService = serviceRegistry.getNodeService();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> processInitWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                CheckOutCheckInServiceImplTest.this.initTestData();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)processInitWork, false, true);
    }

    private void initTestData() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT);
        this.nodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TITLED, null);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)TEST_VALUE_NAME));
        this.nodeService.setProperty(this.nodeRef, PROP2_QNAME, (Serializable)((Object)TEST_VALUE_2));
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(CONTENT_1);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        this.userName = "cociTest" + GUID.generate();
        TestWithUserUtils.createUser(this.userName, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.userNodeRef = TestWithUserUtils.getCurrentUser((AuthenticationService)this.authenticationService);
        this.permissionService.setPermission(this.rootNodeRef, this.userName, "All", true);
        this.permissionService.setPermission(this.nodeRef, this.userName, "All", true);
        this.folderNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, "folder")).getChildRef();
        this.fileNodeRef = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, "file")).getChildRef();
        contentWriter = this.contentService.getWriter(this.fileNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(CONTENT_1);
    }

    private Map<QName, Serializable> createTypePropertyBag() {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        result.put(PROP_NAME_QNAME, (Serializable)((Object)TEST_VALUE_NAME));
        return result;
    }

    @Test
    public void testCheckOut() {
        this.checkout();
    }

    private NodeRef checkout() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_COPIEDFROM));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        String name = (String)((Object)this.nodeService.getProperty(this.nodeRef, PROP_NAME_QNAME));
        String expectedWorkingCopyLabel = I18NUtil.getMessage((String)"coci_service.working_copy_label");
        String expectedWorkingCopyName = CheckOutCheckInServiceImpl.createWorkingCopyName((String)name, (String)expectedWorkingCopyLabel);
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)expectedWorkingCopyName, (String)workingCopyName);
        CheckOutCheckInServiceImplTest.assertEquals((String)"No record of working copy label kept", (Object)expectedWorkingCopyLabel, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_LABEL));
        ContentReader contentReader = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader);
        ContentReader contentReader2 = this.contentService.getReader(workingCopy, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader2);
        CheckOutCheckInServiceImplTest.assertEquals((String)"The content string of the working copy should match the original immediatly after checkout.", (String)contentReader.getContentString(), (String)contentReader2.getContentString());
        return workingCopy;
    }

    @Test
    public void testCheckIn() {
        NodeRef workingCopy = this.checkout();
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(workingCopy, versionProperties);
        NodeRef workingCopy3 = this.checkout();
        this.nodeService.setProperty(workingCopy3, PROP_NAME_QNAME, (Serializable)((Object)TEST_VALUE_2));
        this.nodeService.setProperty(workingCopy3, PROP2_QNAME, (Serializable)((Object)TEST_VALUE_3));
        ContentWriter tempWriter = this.contentService.getWriter(workingCopy3, ContentModel.PROP_CONTENT, false);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)tempWriter);
        tempWriter.putContent(CONTENT_2);
        String contentUrl = tempWriter.getContentUrl();
        HashMap<String, String> versionProperties3 = new HashMap<String, String>();
        versionProperties3.put("description", "description");
        versionProperties3.put("versionType", (String)VersionType.MAJOR);
        NodeRef origNodeRef = this.cociService.checkin(workingCopy3, versionProperties3, contentUrl, true);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)origNodeRef);
        ContentReader contentReader = this.contentService.getReader(origNodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader);
        CheckOutCheckInServiceImplTest.assertEquals((String)CONTENT_2, (String)contentReader.getContentString());
        Version version = this.versionService.getCurrentVersion(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)version);
        CheckOutCheckInServiceImplTest.assertEquals((String)"description", (String)version.getDescription());
        CheckOutCheckInServiceImplTest.assertEquals((Object)VersionType.MAJOR, (Object)version.getVersionType());
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionNodeRef);
        ContentReader versionContentReader = this.contentService.getReader(versionNodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionContentReader);
        CheckOutCheckInServiceImplTest.assertEquals((String)CONTENT_2, (String)versionContentReader.getContentString());
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_2, (Object)this.nodeService.getProperty(versionNodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_2, (Object)this.nodeService.getProperty(origNodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_3, (Object)this.nodeService.getProperty(versionNodeRef, PROP2_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_3, (Object)this.nodeService.getProperty(origNodeRef, PROP2_QNAME));
        this.cociService.cancelCheckout(workingCopy3);
        NodeRef workingCopy2 = this.checkout();
        HashMap<String, String> versionProperties2 = new HashMap<String, String>();
        versionProperties2.put("description", "Another version test");
        this.cociService.checkin(workingCopy2, versionProperties2, null, true);
        this.cociService.checkin(workingCopy2, new HashMap(), null, true);
    }

    @Test
    public void testCheckInVersionedNode_MNT_8789() {
        String versionDescription = "This is a test version";
        NodeRef nodeA = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return (NodeRef)CheckOutCheckInServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    public NodeRef execute() throws Exception {
                        AuthenticationUtil.setFullyAuthenticatedUser((String)(this).CheckOutCheckInServiceImplTest.this.userName);
                        NodeRef a = (this).CheckOutCheckInServiceImplTest.this.nodeService.createNode((this).CheckOutCheckInServiceImplTest.this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}NodeForA"), ContentModel.TYPE_CONTENT).getChildRef();
                        (this).CheckOutCheckInServiceImplTest.this.nodeService.addAspect(a, ContentModel.ASPECT_AUDITABLE, null);
                        (this).CheckOutCheckInServiceImplTest.this.nodeService.addAspect(a, ContentModel.ASPECT_VERSIONABLE, null);
                        return a;
                    }
                });
            }
        }, (String)this.userName);
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userName, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_CREATOR));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userName, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_MODIFIER));
        CheckOutCheckInServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(nodeA, ContentModel.ASPECT_VERSIONABLE));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef workingCopy = this.cociService.checkout(nodeA);
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", versionDescription);
        this.cociService.checkin(workingCopy, versionProperties);
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userName, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_CREATOR));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userName, (Object)this.nodeService.getProperty(nodeA, ContentModel.PROP_MODIFIER));
        CheckOutCheckInServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(nodeA, ContentModel.ASPECT_VERSIONABLE));
        Serializable modifiedDate = this.nodeService.getProperty(nodeA, ContentModel.PROP_MODIFIED);
        Version version = this.versionService.getCurrentVersion(nodeA);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)version);
        CheckOutCheckInServiceImplTest.assertEquals((String)versionDescription, (String)version.getDescription());
        CheckOutCheckInServiceImplTest.assertEquals((String)this.userName, (String)version.getFrozenModifier());
        CheckOutCheckInServiceImplTest.assertEquals((boolean)true, (boolean)version.getFrozenModifiedDate().equals(modifiedDate));
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionNodeRef);
        this.nodeService.deleteNode(nodeA);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSourceOfLockedCopy() {
        final NodeRef folderA = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef a = CheckOutCheckInServiceImplTest.this.nodeService.createNode(CheckOutCheckInServiceImplTest.this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}FolderA"), ContentModel.TYPE_FOLDER).getChildRef();
                return a;
            }
        });
        NodeRef folderB = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef b = CheckOutCheckInServiceImplTest.this.nodeService.createNode(CheckOutCheckInServiceImplTest.this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}FolderB"), ContentModel.TYPE_FOLDER).getChildRef();
                return b;
            }
        });
        NodeRef file = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef file = CheckOutCheckInServiceImplTest.this.nodeService.createNode(folderA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}file"), ContentModel.TYPE_CONTENT).getChildRef();
                return file;
            }
        });
        NodeRef copy = this.copyService.copy(file, folderB, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copy"), true);
        NodeRef workingCopy = this.cociService.checkout(copy);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        Date wcModBefore = (Date)this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest checkOutCheckInServiceImplTest = this;
        synchronized (checkOutCheckInServiceImplTest) {
            try {
                ((Object)((Object)this)).wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.nodeService.deleteNode(file);
        Date wcModAfter = (Date)this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((String)"cm:modified should not change on the copied node when deleting the original", (Object)wcModBefore, (Object)wcModAfter);
    }

    @Test
    public void testCheckOutCheckInWithDifferentLocales() {
        Locale.setDefault(Locale.FRANCE);
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy name not correct", (String)"myDocument (Copie de Travail).doc", (String)workingCopyName);
        Locale.setDefault(Locale.UK);
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(workingCopy, versionProperties);
        String name = (String)((Object)this.nodeService.getProperty(this.nodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy label was not removed.", (String)TEST_VALUE_NAME, (String)name);
    }

    @Test
    public void testCheckOutCheckInWithAlteredWorkingCopyName() {
        Locale.setDefault(Locale.FRANCE);
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy name not correct", (String)"myDocument (Copie de Travail).doc", (String)workingCopyName);
        this.nodeService.setProperty(workingCopy, PROP_NAME_QNAME, (Serializable)((Object)"newName (Copie de Travail).doc"));
        Locale.setDefault(Locale.UK);
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(workingCopy, versionProperties);
        String name = (String)((Object)this.nodeService.getProperty(this.nodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"File not renamed correctly.", (String)"newName.doc", (String)name);
    }

    @Test
    public void testCheckInWithNameChange() {
        NodeRef fileWorkingCopyNodeRef = this.cociService.checkout(this.fileNodeRef);
        NodeRef fileWorkingCopyNodeRefCheck = this.cociService.getWorkingCopy(this.fileNodeRef);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy not found ", (Object)fileWorkingCopyNodeRef, (Object)fileWorkingCopyNodeRefCheck);
        this.nodeService.setProperty(fileWorkingCopyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"renamed"));
        this.cociService.checkin(fileWorkingCopyNodeRef, null);
    }

    @Test
    public void testCheckOutCheckInWithTranslatableAspect() {
        NodeRef translationNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"translation"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(this.nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"translatable"), null);
        this.nodeService.createAssociation(this.nodeRef, translationNodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"translations"));
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(workingCopy, versionProperties);
    }

    @Test
    public void testVersionAspectNotSetOnCheckIn() {
        Map<QName, Serializable> bagOfProps = this.createTypePropertyBag();
        bagOfProps.put(ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, "UTF-8"));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, bagOfProps);
        NodeRef noVersionNodeRef = childAssocRef.getChildRef();
        NodeRef workingCopy = this.cociService.checkout(noVersionNodeRef);
        this.cociService.checkin(workingCopy, new HashMap());
        CheckOutCheckInServiceImplTest.assertNull((Object)this.versionService.getVersionHistory(noVersionNodeRef));
    }

    @Test
    public void testCancelCheckOut() {
        NodeRef workingCopy = this.checkout();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.lockService.checkForLock(this.nodeRef);
            CheckOutCheckInServiceImplTest.fail((String)"The origional should be locked now.");
        }
        catch (Throwable throwable) {}
        NodeRef origNodeRef = this.cociService.cancelCheckout(workingCopy);
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.nodeRef, (Object)origNodeRef);
        this.lockService.checkForLock(origNodeRef);
    }

    @Test
    public void testAutoCancelCheckOut() {
        Date modifiedDateBeforeCheckOut = (Date)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        NodeRef workingCopy = this.checkout();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.lockService.checkForLock(this.nodeRef);
            CheckOutCheckInServiceImplTest.fail((String)"The original should be locked now.");
        }
        catch (Throwable throwable) {}
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        this.nodeService.deleteNode(workingCopy);
        Date modifiedDateAfterCheckOut = (Date)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((Object)modifiedDateBeforeCheckOut, (Object)modifiedDateAfterCheckOut);
        this.lockService.checkForLock(this.nodeRef);
    }

    @Test
    public void testBidirectionalReferences() {
        final NodeRef origNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test2"), ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef wk1 = this.cociService.getWorkingCopy(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk1);
        final NodeRef workingCopy = this.cociService.checkout(origNodeRef);
        CheckOutCheckInServiceImplTest.assertTrue((String)"Expect cm:workingcopy aspect", (boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((String)"Expect cm:checkedOut aspect", (boolean)this.nodeService.hasAspect(origNodeRef, ContentModel.ASPECT_CHECKED_OUT));
        List targetAssocs = this.nodeService.getTargetAssocs(origNodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Expect a 1:1 relationship", (int)1, (int)targetAssocs.size());
        List sourceAssocs = this.nodeService.getSourceAssocs(workingCopy, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Expect a 1:1 relationship", (int)1, (int)sourceAssocs.size());
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeRef finalNodeRef = origNodeRef;
        NodeRef wk3 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() {
                NodeRef wk2 = CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(finalNodeRef);
                CheckOutCheckInServiceImplTest.assertNotNull((Object)wk2);
                CheckOutCheckInServiceImplTest.assertEquals((Object)workingCopy, (Object)wk2);
                NodeRef orig2 = CheckOutCheckInServiceImplTest.this.cociService.getCheckedOut(wk2);
                CheckOutCheckInServiceImplTest.assertNotNull((Object)orig2);
                CheckOutCheckInServiceImplTest.assertEquals((Object)origNodeRef, (Object)orig2);
                CheckOutCheckInServiceImplTest.this.cociService.cancelCheckout(workingCopy);
                return CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(CheckOutCheckInServiceImplTest.this.nodeRef);
            }
        });
        CheckOutCheckInServiceImplTest.assertNull((Object)wk3);
    }

    @Test
    public void testETWOTWO_733() {
        NodeRef origNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test2"), ContentModel.TYPE_CONTENT).getChildRef();
        this.copyService.copyAndRename(origNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test6"), false);
        NodeRef wk1 = this.cociService.getWorkingCopy(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk1);
        final NodeRef workingCopy = this.cociService.checkout(origNodeRef);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeRef finalNodeRef = origNodeRef;
        NodeRef wk3 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() {
                NodeRef wk2 = CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(finalNodeRef);
                CheckOutCheckInServiceImplTest.assertNotNull((Object)wk2);
                CheckOutCheckInServiceImplTest.assertEquals((Object)workingCopy, (Object)wk2);
                CheckOutCheckInServiceImplTest.this.cociService.cancelCheckout(workingCopy);
                return CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(CheckOutCheckInServiceImplTest.this.nodeRef);
            }
        });
        CheckOutCheckInServiceImplTest.assertNull((Object)wk3);
    }

    @Test
    public void testAR1056() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy2"));
            CheckOutCheckInServiceImplTest.fail((String)"This document has been checked out twice.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testMultipleCheckoutsCheckInsWithPropChange() {
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, null);
        final NodeRef testNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeRef workingCopy1 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                return CheckOutCheckInServiceImplTest.this.cociService.checkout(testNodeRef);
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                CheckOutCheckInServiceImplTest.this.nodeService.setProperty(workingCopy1, ContentModel.PROP_AUTHOR, (Serializable)((Object)"author1"));
                HashMap<String, String> versionProperties = new HashMap<String, String>();
                versionProperties.put("description", "This is a test version 1");
                CheckOutCheckInServiceImplTest.this.cociService.checkin(workingCopy1, versionProperties);
                return null;
            }
        });
        final NodeRef workingCopy2 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                return CheckOutCheckInServiceImplTest.this.cociService.checkout(testNodeRef);
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                CheckOutCheckInServiceImplTest.this.nodeService.setProperty(workingCopy2, ContentModel.PROP_AUTHOR, (Serializable)((Object)"author2"));
                HashMap<String, String> versionProperties = new HashMap<String, String>();
                versionProperties.put("description", "This is a test version 2");
                CheckOutCheckInServiceImplTest.this.cociService.checkin(workingCopy2, versionProperties);
                return null;
            }
        });
        final NodeRef workingCopy3 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                return CheckOutCheckInServiceImplTest.this.cociService.checkout(testNodeRef);
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                CheckOutCheckInServiceImplTest.this.nodeService.setProperty(workingCopy3, ContentModel.PROP_AUTHOR, (Serializable)((Object)"author3"));
                HashMap<String, String> versionProperties = new HashMap<String, String>();
                versionProperties.put("description", "This is a test version 3");
                CheckOutCheckInServiceImplTest.this.cociService.checkin(workingCopy3, versionProperties);
                return null;
            }
        });
    }

    @Test
    public void testAlfrescoCheckoutDoesNotModifyNode() {
        String adminUser = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)adminUser);
        Serializable initModifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        Serializable initModified = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertFalse((String)"The initial modifier should not be Admin!", (boolean)adminUser.equals(initModifier));
        NodeRef copy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        Serializable modifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Checkout should not cause the modifier to change!", (Object)initModifier, (Object)modifier);
        Serializable modified = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Checkout should not cause the modified date to change!", (Object)initModified, (Object)modified);
        this.cociService.cancelCheckout(copy);
        modifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Cancel checkout should not cause the modifier to change!", (Object)initModifier, (Object)modifier);
        modified = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Cancel checkout should not cause the modified date to change!", (Object)initModified, (Object)modified);
        copy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(copy, versionProperties);
        modifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        CheckOutCheckInServiceImplTest.assertEquals((String)"The modifier should NOT change to Admin after checkin!", (Object)initModifier, (Object)modifier);
    }

    @Test
    public void testCheckOutPermissions_ALF7680_ALF535() {
        NodeRef folder1 = this.createFolderWithPermission(this.rootNodeRef, this.userName, "Consumer");
        NodeRef node = this.createNodeWithPermission(folder1, this.userName, "Editor");
        NodeRef workingCopy = this.cociService.checkout(node, folder1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        this.cociService.cancelCheckout(workingCopy);
        NodeRef folder2 = this.createFolderWithPermission(this.rootNodeRef, this.userName, "All");
        workingCopy = this.cociService.checkout(node, folder2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        this.cociService.cancelCheckout(workingCopy);
        NodeRef folder3 = this.createFolderWithPermission(this.rootNodeRef, this.userName, "Consumer");
        try {
            workingCopy = this.cociService.checkout(node, folder3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
            CheckOutCheckInServiceImplTest.fail((String)"Node can't be checked out to folder where user has no permissions to create children");
        }
        catch (Exception exception) {}
        NodeRef node2 = this.createNodeWithPermission(folder3, this.userName, "Consumer");
        try {
            workingCopy = this.cociService.checkout(node2, folder3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
            CheckOutCheckInServiceImplTest.fail((String)"Node can't be checked out if user has no permissions to edit document");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testCheckInLockableAspectDoesntCopies_ALF16194() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(workingCopy, versionProperties);
        if (this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            CheckOutCheckInServiceImplTest.fail((String)"Lockable aspect should not be copied from the working copy to the original document");
        }
    }

    @Test
    public void testCanCheckInWhenOriginalHasUndeletableAspect() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_UNDELETABLE, null);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_UNDELETABLE));
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_UNDELETABLE));
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "This is a test version");
        this.cociService.checkin(workingCopy, versionProperties);
    }

    private NodeRef createFolderWithPermission(NodeRef parent, String username, String permission) {
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        NodeRef folder = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("TestFolder" + GUID.generate())), ContentModel.TYPE_CONTENT).getChildRef();
        this.permissionService.deletePermissions(folder);
        this.permissionService.setInheritParentPermissions(folder, false);
        this.permissionService.setPermission(folder, this.userName, permission, true);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        return folder;
    }

    private NodeRef createNodeWithPermission(NodeRef parent, String username, String permission) {
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        NodeRef node = this.copyService.copy(this.nodeRef, parent, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT);
        this.permissionService.deletePermissions(node);
        this.permissionService.setInheritParentPermissions(node, false);
        this.permissionService.setPermission(node, this.userName, permission, true);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        return node;
    }

    @Test
    public void testMoveOriginalWithWorkingCopy() {
        final NodeRef folderA = this.createFolder("MoveOriginalWithWorkingCopy_" + GUID.generate());
        final NodeRef folderB = this.createFolder("MoveOriginalWithWorkingCopy_" + GUID.generate());
        NodeRef origAllowed = this.createContent("original_" + GUID.generate(), folderA);
        NodeRef workingCopyAllowed = this.cociService.checkout(origAllowed);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopyAllowed);
        final NodeRef origDenied = this.createContent("original_" + GUID.generate(), folderA);
        final NodeRef workingCopyDenied = this.cociService.checkout(origDenied);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopyDenied);
        NodeRef movedWorkingCopyAllowed = null;
        try {
            movedWorkingCopyAllowed = this.fileFolderService.moveFrom(workingCopyAllowed, folderA, folderB, null).getNodeRef();
        }
        catch (Exception exception) {}
        CheckOutCheckInServiceImplTest.assertNotNull(movedWorkingCopyAllowed);
        CheckOutCheckInServiceImplTest.assertEquals((Object)folderB, (Object)this.nodeService.getPrimaryParent(movedWorkingCopyAllowed).getParentRef());
        boolean thrown = false;
        CheckOutCheckInServiceImplTest.assertEquals((Object)folderA, (Object)this.nodeService.getPrimaryParent(origAllowed).getParentRef());
        try {
            this.fileFolderService.moveFrom(origAllowed, folderA, folderB, null).getNodeRef();
        }
        catch (NodeLockedException nodeLockedException) {
            thrown = true;
        }
        catch (Exception exception) {}
        CheckOutCheckInServiceImplTest.assertTrue((boolean)thrown);
        this.createPerson("COCITestUser123");
        thrown = false;
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return CheckOutCheckInServiceImplTest.this.fileFolderService.moveFrom(workingCopyDenied, folderA, folderB, null).getNodeRef();
                }
            }, (String)"COCITestUser123");
        }
        catch (AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        CheckOutCheckInServiceImplTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return CheckOutCheckInServiceImplTest.this.fileFolderService.moveFrom(origDenied, folderA, folderB, null).getNodeRef();
                }
            }, (String)"COCITestUser123");
        }
        catch (AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        CheckOutCheckInServiceImplTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testDeleteUpdateOriginalOfCheckedOutDocument() {
        NodeRef folderA = this.createFolder("DeleteUpdateOriginalOfCheckedOutDocument_" + GUID.generate());
        final NodeRef orig = this.createContent("original_" + GUID.generate(), folderA);
        NodeRef workingCopy = this.cociService.checkout(orig);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        final HashMap<QName, MLText> propsToPersist = new HashMap<QName, MLText>(3);
        MLText value = new MLText(Locale.ENGLISH, GUID.generate());
        propsToPersist.put(ContentModel.PROP_DESCRIPTION, value);
        value = new MLText(Locale.ENGLISH, null);
        propsToPersist.put(ContentModel.PROP_TITLE, value);
        boolean thrown = false;
        try {
            this.nodeService.addProperties(orig, propsToPersist);
        }
        catch (NodeLockedException nodeLockedException) {
            thrown = true;
        }
        CheckOutCheckInServiceImplTest.assertTrue((String)"No one should be able to update the original", (boolean)thrown);
        this.createPerson("COCITestUser123");
        thrown = false;
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    CheckOutCheckInServiceImplTest.this.fileFolderService.delete(orig);
                    return null;
                }
            }, (String)"COCITestUser123");
        }
        catch (AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        CheckOutCheckInServiceImplTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    CheckOutCheckInServiceImplTest.this.nodeService.addProperties(orig, propsToPersist);
                    return null;
                }
            }, (String)"COCITestUser123");
        }
        catch (AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            thrown = true;
        }
        catch (NodeLockedException nodeLockedException) {
            thrown = true;
        }
        CheckOutCheckInServiceImplTest.assertTrue((boolean)thrown);
        this.fileFolderService.delete(orig);
    }

    @Test
    public void testDeleteOfWorkingCopy() {
        NodeRef folderA = this.createFolder("DeleteOfWorkingCopy_" + GUID.generate());
        NodeRef orig = this.createContent("original_" + GUID.generate(), folderA);
        NodeRef workingCopy = this.cociService.checkout(orig);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        this.fileFolderService.delete(workingCopy);
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.exists(workingCopy));
        CheckOutCheckInServiceImplTest.assertNull((Object)this.cociService.getWorkingCopy(orig));
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.cociService.isCheckedOut(orig));
    }

    @Test
    public void testDeleteWorkingCopyAspect() {
        NodeRef folderA = this.createFolder("DeleteCopiedFromAspectFromWorkingCopy_" + GUID.generate());
        NodeRef orig = this.createContent("original_" + GUID.generate(), folderA);
        NodeRef workingCopy = this.cociService.checkout(orig);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((String)"cm:workingCopy aspect not found on working copy.", (boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((String)"cm:copiedFrom aspect not found on working copy.", (boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_COPIEDFROM));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.nodeService.removeAspect(workingCopy, ContentModel.ASPECT_COPIEDFROM);
        try {
            this.nodeService.removeAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY);
            CheckOutCheckInServiceImplTest.fail((String)"Should not be able to remove cm:workingcopy");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    @Test
    public void testDeleteWorkingCopyLinkAssociation() {
        NodeRef folderA = this.createFolder("DeleteOriginalAssociationFromCopy_" + GUID.generate());
        NodeRef orig = this.createContent("original_" + GUID.generate(), folderA);
        NodeRef workingCopy = this.cociService.checkout(orig);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Did not find cm:workingcopylink", (int)1, (int)this.nodeService.getSourceAssocs(workingCopy, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK).size());
        TestTransaction.flagForCommit();
        TestTransaction.end();
        try {
            this.nodeService.removeAssociation(orig, workingCopy, ContentModel.ASSOC_WORKING_COPY_LINK);
            CheckOutCheckInServiceImplTest.fail((String)"Should not have been allowed to remove the association from working copy to original");
        }
        catch (IntegrityException integrityException) {}
    }

    private NodeRef createFolder(String fName) {
        return this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)fName), ContentModel.TYPE_FOLDER).getChildRef();
    }

    private NodeRef createContent(String contentName, NodeRef parentRef) {
        return this.nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)contentName), ContentModel.TYPE_CONTENT).getChildRef();
    }

    private void createPerson(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, PWD.toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            final PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(userName + "@gmail.com"));
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobtitle");
            personProps.put((Object)ContentModel.PROP_ORGANIZATION, (Object)"org");
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return CheckOutCheckInServiceImplTest.this.personService.createPerson((Map)personProps);
                }
            });
        }
    }

    @Test
    public void testCancelCheckoutUnlockedWCopy() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        CheckOutCheckInService securityCOCIService = serviceRegistry.getCheckOutCheckInService();
        NodeRef folderA = this.createFolder(this.rootNodeRef, "testMnt9502_" + System.currentTimeMillis());
        CheckOutCheckInServiceImplTest.assertNotNull((Object)folderA);
        NodeRef clucc = this.createContent("checkout_lock_unlock_cancelCO", folderA);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)clucc);
        NodeRef wc = securityCOCIService.checkout(clucc);
        this.lockService.lock(wc, LockType.WRITE_LOCK, 3600);
        this.lockService.unlock(wc);
        securityCOCIService.cancelCheckout(wc);
    }

    @Test
    public void testDeleteAndRestore() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef spacesStoreRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef spacesRootNodeRef = this.nodeService.getRootNode(spacesStoreRef);
        NodeRef archiveRootNodeRef = this.nodeService.getStoreArchiveNode(spacesStoreRef);
        this.permissionService.setPermission(spacesRootNodeRef, this.userName, "All", true);
        this.authenticationComponent.setCurrentUser(this.userName);
        NodeRef folderRef = this.createFolder(spacesRootNodeRef, "testDeleteAndRestore-folder-" + System.currentTimeMillis());
        NodeRef contentRef = this.createContent("testDeleteAndRestore-content", folderRef);
        String initialText = "initial text";
        ContentWriter contentWriter = this.contentService.getWriter(contentRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(initialText);
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_CHECKED_OUT));
        NodeRef workingCopyRef = this.cociService.checkout(contentRef, folderRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopyRef);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopyRef, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopyRef, ContentModel.ASPECT_COPIEDFROM));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_CHECKED_OUT));
        String updatedText = "updated text";
        contentWriter = this.contentService.getWriter(workingCopyRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(updatedText);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.exists(folderRef));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.exists(contentRef));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.exists(workingCopyRef));
        this.nodeService.deleteNode(folderRef);
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.exists(folderRef));
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.exists(contentRef));
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.exists(workingCopyRef));
        NodeRef archiveNodeRef = new NodeRef(archiveRootNodeRef.getStoreRef(), folderRef.getId());
        this.nodeService.restoreNode(archiveNodeRef, null, null, null);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.exists(folderRef));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.exists(contentRef));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.exists(workingCopyRef));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopyRef, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopyRef, ContentModel.ASPECT_COPIEDFROM));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_CHECKED_OUT));
        CheckOutCheckInServiceImplTest.assertEquals((String)initialText, (String)this.contentService.getReader(contentRef, ContentModel.PROP_CONTENT).getContentString());
        CheckOutCheckInServiceImplTest.assertEquals((String)updatedText, (String)this.contentService.getReader(workingCopyRef, ContentModel.PROP_CONTENT).getContentString());
        NodeRef folderRef2 = this.createFolder(spacesRootNodeRef, "testDeleteAndRestore-folder2-" + System.currentTimeMillis());
        this.nodeService.moveNode(folderRef, folderRef2, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
        this.cociService.checkin(workingCopyRef, null);
        CheckOutCheckInServiceImplTest.assertFalse((boolean)this.nodeService.exists(workingCopyRef));
        CheckOutCheckInServiceImplTest.assertEquals((String)updatedText, (String)this.contentService.getReader(contentRef, ContentModel.PROP_CONTENT).getContentString());
    }

    private NodeRef createFolder(NodeRef rootNodeRef, String fName) {
        return this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)fName), ContentModel.TYPE_FOLDER).getChildRef();
    }
}

