/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.IOException;
import java.io.InputStream;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.service.cmr.remote.RepoRemoteTransport;

public class RepoRemoteInputStream
extends InputStream {
    private RepoRemoteTransport fRepoRemote;
    private ClientTicketHolder fTicketHolder;
    private String fHandle;

    public RepoRemoteInputStream(String handle, RepoRemoteTransport remote, ClientTicketHolder ticketHolder) {
        this.fHandle = handle;
        this.fRepoRemote = remote;
        this.fTicketHolder = ticketHolder;
    }

    @Override
    public int read() throws IOException {
        byte[] buff;
        block3: {
            try {
                buff = this.fRepoRemote.readInput(this.fTicketHolder.getTicket(), this.fHandle, 1);
                if (buff.length != 0) break block3;
                return -1;
            }
            catch (Exception exception) {
                throw new IOException("Remote I/O Error.");
            }
        }
        return buff[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] buff;
        block3: {
            try {
                buff = this.fRepoRemote.readInput(this.fTicketHolder.getTicket(), this.fHandle, len);
                if (buff.length != 0) break block3;
                return -1;
            }
            catch (Exception exception) {
                throw new IOException("Remote I/O Error.");
            }
        }
        System.arraycopy(buff, 0, b, off, buff.length);
        return buff.length;
    }

    @Override
    public void close() throws IOException {
        try {
            this.fRepoRemote.closeInputHandle(this.fTicketHolder.getTicket(), this.fHandle);
        }
        catch (Exception exception) {
            throw new IOException("Remote Error closing input stream.");
        }
    }
}

