/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.shared;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefExpander {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeDefExpander.class);
    private static final String MARKER_INCLUDE_SUBTYPES = "include_subtypes";
    private final DictionaryService dictionaryService;
    private final NamespaceService namespaceService;

    public TypeDefExpander(DictionaryService dictionaryService, NamespaceService namespaceService) {
        this.dictionaryService = dictionaryService;
        this.namespaceService = namespaceService;
    }

    public Set<QName> expand(Collection<String> types) {
        HashSet<QName> result = new HashSet<QName>();
        types.forEach(type -> {
            boolean bl = result.addAll(this.expand((String)type));
        });
        return result;
    }

    public Collection<QName> expand(String typeDef) {
        if (typeDef == null || typeDef.isEmpty() || typeDef.equals("none") || typeDef.contains("${")) {
            return Collections.emptyList();
        }
        if (typeDef.indexOf(32) < 0) {
            return Collections.singleton(this.getQName(typeDef));
        }
        String[] typeDefParts = typeDef.split(" ");
        if (typeDefParts.length != 2) {
            LOGGER.warn("Ignoring invalid type pattern: " + typeDef);
            return Collections.emptyList();
        }
        if (typeDefParts[1].equals(MARKER_INCLUDE_SUBTYPES)) {
            QName baseType;
            if (typeDefParts[0].indexOf(42) >= 0) {
                LOGGER.warn("Ignoring invalid type pattern: " + typeDef);
                return Collections.emptyList();
            }
            try {
                baseType = this.getQName(typeDefParts[0]);
            }
            catch (NamespaceException namespaceException) {
                return Collections.emptyList();
            }
            return this.dictionaryService.getSubTypes(baseType, true);
        }
        LOGGER.warn("Ignoring invalid type pattern: " + typeDef);
        return Collections.emptyList();
    }

    private QName getQName(String type) {
        return QName.createQName((String)type, (NamespacePrefixResolver)this.namespaceService);
    }
}

