/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.cache.CacheStatistics;
import org.alfresco.repo.cache.CacheStatisticsCreated;
import org.alfresco.repo.cache.NoStatsForCache;
import org.alfresco.repo.cache.OperationStats;
import org.alfresco.repo.cache.TransactionStats;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class InMemoryCacheStatistics
implements CacheStatistics,
ApplicationContextAware {
    private final ConcurrentMap<String, ReentrantReadWriteLock> locks = new ConcurrentHashMap<String, ReentrantReadWriteLock>();
    private Map<String, Map<TransactionStats.OpType, OperationStats>> cacheToStatsMap = new HashMap<String, Map<TransactionStats.OpType, OperationStats>>();
    private ApplicationContext applicationContext;

    @Override
    public long count(String cacheName, TransactionStats.OpType opType) {
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLock(cacheName);
        readLock.lock();
        try {
            Map<TransactionStats.OpType, OperationStats> cacheStats = this.cacheToStatsMap.get(cacheName);
            if (cacheStats == null) {
                throw new NoStatsForCache(cacheName);
            }
            OperationStats opStats = cacheStats.get((Object)opType);
            long l = opStats.getCount();
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public double meanTime(String cacheName, TransactionStats.OpType opType) {
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLock(cacheName);
        readLock.lock();
        try {
            Map<TransactionStats.OpType, OperationStats> cacheStats = this.cacheToStatsMap.get(cacheName);
            if (cacheStats == null) {
                throw new NoStatsForCache(cacheName);
            }
            OperationStats opStats = cacheStats.get((Object)opType);
            double d = opStats.meanTime();
            return d;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void add(String cacheName, TransactionStats txStats) {
        boolean registerCacheStats = false;
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLock(cacheName);
        writeLock.lock();
        try {
            boolean bl = registerCacheStats = !this.cacheToStatsMap.containsKey(cacheName);
            if (registerCacheStats) {
                this.cacheToStatsMap.put(cacheName, new HashMap());
            }
            Map<TransactionStats.OpType, OperationStats> cacheStats = this.cacheToStatsMap.get(cacheName);
            TransactionStats.OpType[] opTypeArray = TransactionStats.OpType.values();
            int n = opTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransactionStats.OpType opType = opTypeArray[n2];
                SummaryStatistics txOpSummary = txStats.getTimings(opType);
                long count = txOpSummary.getN();
                double totalTime = txOpSummary.getSum();
                OperationStats oldStats = cacheStats.get((Object)opType);
                OperationStats newStats = oldStats == null ? new OperationStats(totalTime, count) : new OperationStats(oldStats, totalTime, count);
                cacheStats.put(opType, newStats);
                ++n2;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (registerCacheStats) {
            this.applicationContext.publishEvent((ApplicationEvent)new CacheStatisticsCreated(this, cacheName));
        }
    }

    @Override
    public double hitMissRatio(String cacheName) {
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLock(cacheName);
        readLock.lock();
        try {
            Map<TransactionStats.OpType, OperationStats> cacheStats = this.cacheToStatsMap.get(cacheName);
            if (cacheStats == null) {
                throw new NoStatsForCache(cacheName);
            }
            long hits = cacheStats.get((Object)TransactionStats.OpType.GET_HIT).getCount();
            long misses = cacheStats.get((Object)TransactionStats.OpType.GET_MISS).getCount();
            double d = (double)hits / (double)(hits + misses);
            return d;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public long numGets(String cacheName) {
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLock(cacheName);
        readLock.lock();
        try {
            Map<TransactionStats.OpType, OperationStats> cacheStats = this.cacheToStatsMap.get(cacheName);
            if (cacheStats == null) {
                throw new NoStatsForCache(cacheName);
            }
            long hits = cacheStats.get((Object)TransactionStats.OpType.GET_HIT).getCount();
            long misses = cacheStats.get((Object)TransactionStats.OpType.GET_MISS).getCount();
            long l = hits + misses;
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Map<TransactionStats.OpType, OperationStats> allStats(String cacheName) {
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLock(cacheName);
        readLock.lock();
        try {
            Map<TransactionStats.OpType, OperationStats> cacheStats = this.cacheToStatsMap.get(cacheName);
            if (cacheStats == null) {
                throw new NoStatsForCache(cacheName);
            }
            HashMap<TransactionStats.OpType, OperationStats> hashMap = new HashMap<TransactionStats.OpType, OperationStats>(cacheStats);
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private ReentrantReadWriteLock getLock(String cacheName) {
        ReentrantReadWriteLock newLock;
        if (!this.locks.containsKey(cacheName) && this.locks.putIfAbsent(cacheName, newLock = new ReentrantReadWriteLock()) == null) {
            return newLock;
        }
        return (ReentrantReadWriteLock)this.locks.get(cacheName);
    }

    private ReentrantReadWriteLock.ReadLock getReadLock(String cacheName) {
        ReentrantReadWriteLock.ReadLock readLock = this.getLock(cacheName).readLock();
        return readLock;
    }

    private ReentrantReadWriteLock.WriteLock getWriteLock(String cacheName) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getLock(cacheName).writeLock();
        return writeLock;
    }
}

