/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluatorAbstractBase;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TaggingService;

public class HasTagEvaluator
extends ActionConditionEvaluatorAbstractBase {
    public static final String NAME = "has-tag";
    public static final String PARAM_TAG = "tag";
    private NodeService nodeService;
    private TaggingService taggingService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    @Override
    public boolean evaluateImpl(ActionCondition ruleCondition, NodeRef actionedUponNodeRef) {
        boolean result = false;
        if (this.nodeService.exists(actionedUponNodeRef)) {
            String tag = (String)((Object)ruleCondition.getParameterValue(PARAM_TAG));
            result = this.taggingService.hasTag(actionedUponNodeRef, tag);
        }
        return result;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TAG, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_TAG)));
    }
}

