/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.StoreRefHasher;
import org.alfresco.repo.virtual.ref.StoredStoreRefHasher;
import org.alfresco.service.cmr.repository.StoreRef;
import org.junit.Assert;
import org.junit.Test;

public class StoredStoreRefHasherTest {
    private final StoreRefHasher storeRefHasher = new StoredStoreRefHasher();

    @Test
    public void testSupportedStores() {
        List<String> storeProtocols = List.of("workspace", "archive", "avm", "deleted", "versionStore");
        List<String> storeIds = List.of("SpacesStore", "lightWeightVersionStore", "version2Store");
        for (String storeProtocol : storeProtocols) {
            for (String storeId : storeIds) {
                StoreRef storeRef = new StoreRef(storeProtocol, storeId);
                String hash = this.storeRefHasher.hash(storeRef);
                StoreRef actualStoreRef = this.storeRefHasher.lookup(hash);
                Assert.assertEquals((Object)storeRef, (Object)actualStoreRef);
            }
        }
    }

    @Test(expected=RuntimeException.class)
    public void testHashInvalidStoreId() {
        StoreRef storeRef = new StoreRef("workspace", "ASpacesStore");
        this.storeRefHasher.hash(storeRef);
    }

    @Test(expected=RuntimeException.class)
    public void testHashInvalidStoreProtocol() {
        StoreRef storeRef = new StoreRef("Xworkspace", "lightWeightVersionStore");
        this.storeRefHasher.hash(storeRef);
    }

    @Test(expected=RuntimeException.class)
    public void testLookupInvalidStoreId() {
        this.storeRefHasher.lookup("91");
    }

    @Test(expected=RuntimeException.class)
    public void testLookupInvalidStoreProtocol() {
        this.storeRefHasher.lookup("19");
    }
}

