/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.util.HashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.MultiTServiceImpl;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MultiTServiceImplTest
extends BaseSpringTest {
    private MultiTServiceImpl multiTServiceImpl;
    private TenantAdminService tenantAdminService;
    private PersonService personService;
    private TenantService tenantService;
    private MutableAuthenticationService authenticationService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private boolean mtEnabled;
    private static final String DEFAULT_ADMIN_PW = "admin";
    private static final String PASS = "password";
    private static final String PROTOCOL = "testprotocol";
    private static final String IDENTIFIER = "testidentifier";
    private static final String ID = "id";
    private static final String ROOT_PATH = "/";
    private static final StoreRef DEFAULT_STORE = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
    private static final NodeRef NODE_REF = new NodeRef("testprotocol", "testidentifier", "id");
    private static final StoreRef STORE_REF = new StoreRef("testprotocol", "testidentifier");
    private static final String NAMESPACE_URI = "testassoctypenamespace";
    private static final String LOCAL_NAME = "testassoctypelocalname";
    private static final QName QNAME = QName.createQName((String)"testassoctypenamespace", (String)"testassoctypelocalname");
    private static final AssociationRef assocRef = new AssociationRef(NODE_REF, QNAME, NODE_REF);
    private static String DOMAIN = null;
    private static String USER1 = null;
    private static String USER2 = null;
    private static String USER3 = null;
    private static String USER2_WITH_DOMAIN = null;
    private static String STRING = null;
    private static String TENANT_STRING = null;
    private static String STRING_WITH_EXISTENT_DOMAIN = null;
    private static String STRING_WITH_NONEXITENT_DOMAIN = null;
    private static StoreRef TENANT_STORE = null;
    private static NodeRef TENANT_NODE_REF = null;
    private static StoreRef TENANT_STORE_REF = null;
    private static QName TENANT_QNAME = null;
    private static AssociationRef tenantAssocRef = null;
    private static ChildAssociationRef childAssocRef = null;
    private static ChildAssociationRef tenantChildAssocRef = null;

    @Before
    public void setUp() throws Exception {
        this.multiTServiceImpl = (MultiTServiceImpl)this.applicationContext.getBean("tenantService", MultiTServiceImpl.class);
        this.tenantAdminService = (TenantAdminService)this.applicationContext.getBean("tenantAdminService", TenantAdminService.class);
        this.personService = (PersonService)this.applicationContext.getBean("PersonService", PersonService.class);
        this.tenantService = (TenantService)this.applicationContext.getBean("tenantService", TenantService.class);
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService", MutableAuthenticationService.class);
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService", TransactionService.class);
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService", NodeService.class);
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService", SearchService.class);
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService", NamespaceService.class);
        DOMAIN = GUID.generate();
        USER1 = GUID.generate();
        USER2 = GUID.generate();
        USER3 = GUID.generate();
        USER2_WITH_DOMAIN = USER2 + "@" + DOMAIN;
        STRING = GUID.generate();
        TENANT_STRING = MultiTServiceImplTest.addDomainToId(STRING, DOMAIN);
        STRING_WITH_EXISTENT_DOMAIN = "@" + DOMAIN + "@";
        STRING_WITH_NONEXITENT_DOMAIN = "@" + STRING + "@";
        TENANT_STORE = new StoreRef("workspace", MultiTServiceImplTest.addDomainToId("SpacesStore", DOMAIN));
        TENANT_NODE_REF = new NodeRef(PROTOCOL, MultiTServiceImplTest.addDomainToId(IDENTIFIER, DOMAIN), ID);
        TENANT_STORE_REF = new StoreRef(PROTOCOL, MultiTServiceImplTest.addDomainToId(IDENTIFIER, DOMAIN));
        TENANT_QNAME = QName.createQName((String)MultiTServiceImplTest.addDomainToId(NAMESPACE_URI, DOMAIN), (String)LOCAL_NAME);
        tenantAssocRef = new AssociationRef(TENANT_NODE_REF, QNAME, TENANT_NODE_REF);
        childAssocRef = new ChildAssociationRef(QNAME, NODE_REF, QNAME, NODE_REF);
        tenantChildAssocRef = new ChildAssociationRef(QNAME, TENANT_NODE_REF, QNAME, TENANT_NODE_REF);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.mtEnabled = AuthenticationUtil.isMtEnabled();
        AuthenticationUtil.setMtEnabled((boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteTenant(DOMAIN);
        AuthenticationUtil.setMtEnabled((boolean)this.mtEnabled);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testIsTenantUser() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef userNodeRef = MultiTServiceImplTest.this.createUser(USER1, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                MultiTServiceImplTest.assertFalse((String)"The user is not from a tenant, but was reported otherwise.", (boolean)MultiTServiceImplTest.this.multiTServiceImpl.isTenantUser(USER1));
                userNodeRef = MultiTServiceImplTest.this.createUser(USER2_WITH_DOMAIN, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                MultiTServiceImplTest.assertFalse((String)"The user is not from a tenant, but was reported otherwise.", (boolean)MultiTServiceImplTest.this.multiTServiceImpl.isTenantUser(USER2_WITH_DOMAIN));
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                userNodeRef = MultiTServiceImplTest.this.createUser(USER3, DOMAIN, MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                MultiTServiceImplTest.assertTrue((String)"The user is from a tenant, but was reported otherwise.", (boolean)MultiTServiceImplTest.this.multiTServiceImpl.isTenantUser(USER3 + "@" + DOMAIN));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetCurrentUserDomain() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                NodeRef userNodeRef = MultiTServiceImplTest.this.createUser(USER1, DOMAIN, MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                Object work = new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getCurrentUserDomain();
                    }
                };
                String result = (String)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work, (String)USER1, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The domains do not match.", (String)DOMAIN, (String)result);
                userNodeRef = MultiTServiceImplTest.this.createUser(USER2, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                work = new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getCurrentUserDomain();
                    }
                };
                result = (String)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work, (String)USER2, (String)"");
                MultiTServiceImplTest.assertEquals((String)"The domains do not match.", (String)"", (String)result);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
        MultiTServiceImplTest.assertEquals((String)"fred", (String)MultiTServiceImpl.getMultiTenantDomainName((String)"@fred@bloggs"));
    }

    @Test
    public void testGetName() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef userNodeRef = MultiTServiceImplTest.this.createUser(USER1, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                Object work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(NODE_REF);
                    }
                };
                NodeRef result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER1, (String)"");
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should contain domain.", (Object)NODE_REF, (Object)result);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                userNodeRef = MultiTServiceImplTest.this.createUser(USER2, DOMAIN, MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(NODE_REF);
                    }
                };
                result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should contain domain.", (Object)TENANT_NODE_REF, (Object)result);
                work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(TENANT_NODE_REF, NODE_REF);
                    }
                };
                result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should contain domain.", (Object)TENANT_NODE_REF, (Object)result);
                TenantUtil.TenantRunAsWork<StoreRef> work2 = new TenantUtil.TenantRunAsWork<StoreRef>(){

                    public StoreRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(STORE_REF);
                    }
                };
                StoreRef result2 = (StoreRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work2, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The StoreRef should contain domain.", (Object)TENANT_STORE_REF, (Object)result2);
                TenantUtil.TenantRunAsWork<ChildAssociationRef> work3 = new TenantUtil.TenantRunAsWork<ChildAssociationRef>(){

                    public ChildAssociationRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(childAssocRef);
                    }
                };
                ChildAssociationRef result3 = (ChildAssociationRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work3, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The ChildAssociationRef should contain domain.", (Object)tenantChildAssocRef, (Object)result3);
                TenantUtil.TenantRunAsWork<AssociationRef> work4 = new TenantUtil.TenantRunAsWork<AssociationRef>(){

                    public AssociationRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(assocRef);
                    }
                };
                AssociationRef result4 = (AssociationRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work4, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The AssociationRef should contain domain.", (Object)tenantAssocRef, (Object)result4);
                TenantUtil.TenantRunAsWork<StoreRef> work5 = new TenantUtil.TenantRunAsWork<StoreRef>(){

                    public StoreRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(USER2_WITH_DOMAIN, STORE_REF);
                    }
                };
                StoreRef result5 = (StoreRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work5, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The StoreRef should contain domain.", (Object)TENANT_STORE_REF, (Object)result5);
                TenantUtil.TenantRunAsWork<QName> work6 = new TenantUtil.TenantRunAsWork<QName>(){

                    public QName doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(QNAME);
                    }
                };
                QName result6 = (QName)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work6, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The QName should contain domain.", (Object)TENANT_QNAME, (Object)result6);
                TenantUtil.TenantRunAsWork<QName> work7 = new TenantUtil.TenantRunAsWork<QName>(){

                    public QName doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(TENANT_NODE_REF, QNAME);
                    }
                };
                QName result7 = (QName)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work7, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The QName should contain domain.", (Object)TENANT_QNAME, (Object)result7);
                TenantUtil.TenantRunAsWork<String> work8 = new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getName(STRING);
                    }
                };
                String result8 = (String)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work8, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The String should contain domain.", (String)TENANT_STRING, (String)result8);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetNull() {
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName("", null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getName(null, null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getBaseName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getBaseName(null));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getBaseName(null, false));
        MultiTServiceImplTest.assertNull((Object)this.tenantService.getBaseName(null, false));
        this.tenantService.checkDomain(null);
    }

    @Test
    public void testInvalidDomainUser() {
        try {
            this.tenantService.getDomainUser("@", "MYDOMAIN");
            MultiTServiceImplTest.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            are.getMessage().contains("Invalid base username");
        }
        try {
            this.tenantService.getDomainUser("", "@");
            MultiTServiceImplTest.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            are.getMessage().contains("Invalid tenant domain");
        }
    }

    @Test
    public void testGetBaseName() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef userNodeRef = MultiTServiceImplTest.this.createUser(USER1, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                Object work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(NODE_REF);
                    }
                };
                NodeRef result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER1, (String)"");
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should not contain domain.", (Object)NODE_REF, (Object)result);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                userNodeRef = MultiTServiceImplTest.this.createUser(USER2, DOMAIN, MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.assertNotNull((String)"The user was not created.", (Object)userNodeRef);
                work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(TENANT_NODE_REF);
                    }
                };
                result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should not contain domain.", (Object)NODE_REF, (Object)result);
                work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(TENANT_NODE_REF, true);
                    }
                };
                result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER1, (String)"");
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should not contain domain.", (Object)NODE_REF, (Object)result);
                work1 = new TenantUtil.TenantRunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(TENANT_NODE_REF, false);
                    }
                };
                result = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work1, (String)USER1, (String)"");
                MultiTServiceImplTest.assertEquals((String)"The NodeRef should contain domain.", (Object)TENANT_NODE_REF, (Object)result);
                TenantUtil.TenantRunAsWork<StoreRef> work2 = new TenantUtil.TenantRunAsWork<StoreRef>(){

                    public StoreRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(TENANT_STORE_REF);
                    }
                };
                StoreRef result2 = (StoreRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work2, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The StoreRef should not contain domain.", (Object)STORE_REF, (Object)result2);
                TenantUtil.TenantRunAsWork<ChildAssociationRef> work3 = new TenantUtil.TenantRunAsWork<ChildAssociationRef>(){

                    public ChildAssociationRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(tenantChildAssocRef);
                    }
                };
                ChildAssociationRef result3 = (ChildAssociationRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work3, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The ChildAssociationRef not should contain domain.", (Object)childAssocRef, (Object)result3);
                TenantUtil.TenantRunAsWork<AssociationRef> work4 = new TenantUtil.TenantRunAsWork<AssociationRef>(){

                    public AssociationRef doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(tenantAssocRef);
                    }
                };
                AssociationRef result4 = (AssociationRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work4, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The AssociationRef should not contain domain.", (Object)assocRef, (Object)result4);
                TenantUtil.TenantRunAsWork<QName> work5 = new TenantUtil.TenantRunAsWork<QName>(){

                    public QName doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(TENANT_QNAME, false);
                    }
                };
                QName result5 = (QName)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work5, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The QName should not contain domain.", (Object)QNAME, (Object)result5);
                TenantUtil.TenantRunAsWork<String> work6 = new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        return (this).MultiTServiceImplTest.this.tenantService.getBaseName(TENANT_STRING);
                    }
                };
                String result6 = (String)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work6, (String)USER2, (String)DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The String should not contain domain.", (String)STRING, (String)result6);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testCheckDomainUser() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String nonExistentDomain = "nonExistentDomain";
                MultiTServiceImplTest.this.createUser(USER1, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                MultiTServiceImplTest.this.createUser(USER2, DOMAIN, MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.this.createUser(USER3, nonExistentDomain, MultiTServiceImplTest.PASS);
                String username3WithDomain = USER3 + "@" + nonExistentDomain;
                try {
                    MultiTServiceImplTest.this.checkDomainUserWork(USER1, "", USER1);
                }
                catch (Exception exception) {
                    MultiTServiceImplTest.fail((String)"The user is not from domain and is not a tenant.");
                }
                try {
                    MultiTServiceImplTest.this.checkDomainUserWork(USER2_WITH_DOMAIN, DOMAIN, USER2);
                }
                catch (Exception exception) {
                    MultiTServiceImplTest.fail((String)"The user is from domain and is a tenant.");
                }
                try {
                    MultiTServiceImplTest.this.checkDomainUserWork(username3WithDomain, DOMAIN, USER2);
                    MultiTServiceImplTest.fail((String)"The user is not from this domain.");
                }
                catch (Exception exception) {}
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testCheckDomain() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiTServiceImplTest.this.createUser(USER1, "", MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                MultiTServiceImplTest.this.createUser(USER2, DOMAIN, MultiTServiceImplTest.PASS);
                MultiTServiceImplTest.this.createUser(USER3, STRING, MultiTServiceImplTest.PASS);
                try {
                    MultiTServiceImplTest.this.checkDomainWork(STRING_WITH_EXISTENT_DOMAIN, "", USER1);
                    MultiTServiceImplTest.fail((String)"The string has a domain, which should not match the default one.");
                }
                catch (Exception exception) {}
                try {
                    MultiTServiceImplTest.this.checkDomainWork(STRING_WITH_EXISTENT_DOMAIN, DOMAIN, USER2);
                }
                catch (Exception exception) {
                    MultiTServiceImplTest.fail((String)"The string has a tenant domain and should match the execution context tenant.");
                }
                try {
                    MultiTServiceImplTest.this.checkDomainWork(STRING_WITH_NONEXITENT_DOMAIN, DOMAIN, USER2);
                    MultiTServiceImplTest.fail((String)"The string has a domain, which should not match the execution context tenant.");
                }
                catch (Exception exception) {}
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetRootNode() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef rootNodeRefDefault = MultiTServiceImplTest.this.nodeService.getRootNode(DEFAULT_STORE);
                NodeRef rootNodeRef = new NodeRef(DEFAULT_STORE, MultiTServiceImplTest.IDENTIFIER);
                NodeRef nodeRef = MultiTServiceImplTest.this.tenantService.getRootNode(MultiTServiceImplTest.this.nodeService, MultiTServiceImplTest.this.searchService, MultiTServiceImplTest.this.namespaceService, MultiTServiceImplTest.ROOT_PATH, rootNodeRef);
                MultiTServiceImplTest.assertEquals((String)"The reported rootNodeRef for the default domain is not correct.", (Object)rootNodeRefDefault, (Object)nodeRef);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                rootNodeRefDefault = MultiTServiceImplTest.this.nodeService.getRootNode(TENANT_STORE);
                rootNodeRef = new NodeRef(TENANT_STORE, MultiTServiceImplTest.IDENTIFIER);
                nodeRef = MultiTServiceImplTest.this.tenantService.getRootNode(MultiTServiceImplTest.this.nodeService, MultiTServiceImplTest.this.searchService, MultiTServiceImplTest.this.namespaceService, MultiTServiceImplTest.ROOT_PATH, rootNodeRef);
                MultiTServiceImplTest.assertEquals((String)"The reported rootNodeRef for the tenant domain is not correct.", (Object)rootNodeRefDefault, (Object)nodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testIsTenantName() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                boolean result = MultiTServiceImplTest.this.tenantService.isTenantName(STRING);
                MultiTServiceImplTest.assertFalse((String)"The string was reported as domain, but it is not", (boolean)result);
                result = MultiTServiceImplTest.this.tenantService.isTenantName(STRING_WITH_EXISTENT_DOMAIN);
                MultiTServiceImplTest.assertTrue((String)"The string was not reported as domain.", (boolean)result);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetPrimaryDomain() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String result = MultiTServiceImplTest.this.tenantService.getPrimaryDomain(USER1);
                MultiTServiceImplTest.assertNull((String)"The primary domain should be null for a non tenant user without a tenant in name.", (Object)result);
                result = MultiTServiceImplTest.this.tenantService.getPrimaryDomain(USER2_WITH_DOMAIN);
                MultiTServiceImplTest.assertNull((String)"The primary domain should be null for a tenant user if multi tenancy is not enabled.", (Object)result);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                result = MultiTServiceImplTest.this.tenantService.getPrimaryDomain(USER2_WITH_DOMAIN);
                MultiTServiceImplTest.assertEquals((String)("The primary domain of the USER2 should be " + DOMAIN + ", but was reported as " + result), (String)DOMAIN, (String)result);
                result = MultiTServiceImplTest.this.tenantService.getPrimaryDomain(USER1);
                MultiTServiceImplTest.assertTrue((String)"The primary domain should be the default one (empty string) for a non tenant user without a tenant in name.", (boolean)result.equals(""));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetDomain() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiTServiceImplTest.this.createUser(USER1, "", MultiTServiceImplTest.PASS);
                String result = MultiTServiceImplTest.this.getDomainWork(STRING, "", USER1, false);
                MultiTServiceImplTest.assertEquals((String)"The domain should be reported as default.", (String)"", (String)result);
                MultiTServiceImplTest.this.createUser(USER2, DOMAIN, MultiTServiceImplTest.PASS);
                result = MultiTServiceImplTest.this.getDomainWork(STRING, "", USER2, false);
                MultiTServiceImplTest.assertEquals((String)"The domain should be reported as default as the tenant was not created yet.", (String)"", (String)result);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                result = MultiTServiceImplTest.this.getDomainWork(STRING_WITH_EXISTENT_DOMAIN, DOMAIN, USER2, false);
                MultiTServiceImplTest.assertEquals((String)("The USER2 domain should be reported as " + DOMAIN), (String)DOMAIN, (String)result);
                try {
                    result = MultiTServiceImplTest.this.getDomainWork(STRING_WITH_EXISTENT_DOMAIN, "", USER1, true);
                    MultiTServiceImplTest.assertEquals((String)("The domain should be reported as " + DOMAIN), (String)DOMAIN, (String)result);
                }
                catch (Exception exception) {
                    MultiTServiceImplTest.fail((String)"An exception should not be thrown.");
                }
                try {
                    result = MultiTServiceImplTest.this.getDomainWork(STRING_WITH_NONEXITENT_DOMAIN, DOMAIN, USER2, true);
                    MultiTServiceImplTest.fail((String)"An exception should be thrown as the domains do not match.");
                }
                catch (Exception exception) {}
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetTenant() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Tenant tenant = MultiTServiceImplTest.this.tenantService.getTenant(DOMAIN);
                MultiTServiceImplTest.assertNull((String)"The tenant should not exist.", (Object)tenant);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                tenant = MultiTServiceImplTest.this.tenantService.getTenant(DOMAIN);
                MultiTServiceImplTest.assertNotNull((String)"The tenant should exist.", (Object)tenant);
                MultiTServiceImplTest.assertTrue((String)"The tenant should have the correct domain.", (boolean)DOMAIN.equals(tenant.getTenantDomain()));
                MultiTServiceImplTest.assertTrue((String)"The tenant should be enabled.", (boolean)tenant.isEnabled());
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testGetUserDomain() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String result = MultiTServiceImplTest.this.tenantService.getUserDomain(USER1);
                MultiTServiceImplTest.assertEquals((String)"The user domain should be the default one for a non tenant user without a tenant in name.", (String)"", (String)result);
                result = MultiTServiceImplTest.this.tenantService.getUserDomain(USER2_WITH_DOMAIN);
                MultiTServiceImplTest.assertEquals((String)"The user domain should be the default one for a user with email like name if multi tenancy is not enabled.", (String)"", (String)result);
                MultiTServiceImplTest.this.createTenant(DOMAIN);
                result = MultiTServiceImplTest.this.tenantService.getUserDomain(USER2_WITH_DOMAIN);
                MultiTServiceImplTest.assertEquals((String)("The user domain should be of the USER2 is " + DOMAIN + ", but was reported as " + result), (String)DOMAIN, (String)result);
                result = MultiTServiceImplTest.this.tenantService.getUserDomain(USER1);
                MultiTServiceImplTest.assertTrue((String)"The user domain should be the default one (empty string) for a non tenant user without a tenant in name.", (boolean)result.equals(""));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    private String getDomainWork(final String user, String domain, String runAsUsername, final boolean checkCurrentDomain) throws Exception {
        TenantUtil.TenantRunAsWork<String> work = new TenantUtil.TenantRunAsWork<String>(){

            public String doWork() throws Exception {
                return MultiTServiceImplTest.this.tenantService.getDomain(user, checkCurrentDomain);
            }
        };
        return (String)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work, (String)runAsUsername, (String)domain);
    }

    private void checkDomainWork(final String string, String domain, String runAsUsername) throws Exception {
        TenantUtil.TenantRunAsWork<Void> work = new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                MultiTServiceImplTest.this.tenantService.checkDomain(string);
                return null;
            }
        };
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work, (String)runAsUsername, (String)domain);
    }

    private void checkDomainUserWork(final String username, String domain, String runAsUsername) throws Exception {
        TenantUtil.TenantRunAsWork<Void> work = new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                MultiTServiceImplTest.this.tenantService.checkDomainUser(username);
                return null;
            }
        };
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)work, (String)runAsUsername, (String)domain);
    }

    private void createTenant(final String tenantDomain) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!MultiTServiceImplTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                    MultiTServiceImplTest.this.tenantAdminService.createTenant(tenantDomain, ("admin " + tenantDomain).toCharArray(), null);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private NodeRef createUser(String baseUserName, String tenantDomain, String password) {
        String userName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
        NodeRef personNodeRef = null;
        if (!this.personService.personExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            HashMap<QName, Object> personProperties = new HashMap<QName, Object>();
            personProperties.put(ContentModel.PROP_USERNAME, userName);
            personProperties.put(ContentModel.PROP_FIRSTNAME, baseUserName);
            personProperties.put(ContentModel.PROP_LASTNAME, baseUserName + "-" + tenantDomain);
            personProperties.put(ContentModel.PROP_EMAIL, userName);
            personNodeRef = this.personService.createPerson(personProperties);
        } else {
            personNodeRef = this.personService.getPerson(userName);
        }
        return personNodeRef;
    }

    private void deleteTenant(final String tenantDomain) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        if ((this).MultiTServiceImplTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                            BehaviourFilter behaviourFilter = (BehaviourFilter)MultiTServiceImplTest.this.applicationContext.getBean("policyBehaviourFilter");
                            behaviourFilter.disableBehaviour(ContentModel.TYPE_PERSON);
                            behaviourFilter.disableBehaviour(ContentModel.ASPECT_UNDELETABLE);
                            (this).MultiTServiceImplTest.this.tenantAdminService.deleteTenant(tenantDomain);
                        }
                        return null;
                    }
                };
                MultiTServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private static String addDomainToId(String id, String domain) {
        return "@" + domain + "@" + id;
    }
}

