/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rawevents;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.alfresco.repo.rawevents.TransactionAwareEventProducer;
import org.alfresco.repo.rawevents.types.EventType;
import org.alfresco.repo.rawevents.types.OnContentUpdatePolicyEvent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TransactionAwareEventProducerTest
extends BaseSpringTest {
    @Autowired
    private RetryingTransactionHelper retryingTransactionHelper;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private TransactionAwareEventProducer eventProducer;
    @Autowired
    @Qualifier(value="alfrescoEventObjectMapper")
    private ObjectMapper messagingObjectMapper;

    @Test
    public void send() throws Exception {
        String endpointUri = this.getMockEndpointUri();
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(endpointUri, MockEndpoint.class);
        mockEndpoint.setAssertPeriod(500L);
        String stringMessage = "stringMessage";
        OnContentUpdatePolicyEvent objectMessage = new OnContentUpdatePolicyEvent();
        objectMessage.setId(GUID.generate());
        objectMessage.setType(EventType.CONTENT_UPDATED.toString());
        objectMessage.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.eventProducer.send(endpointUri, (Object)stringMessage);
            mockEndpoint.setExpectedCount(0);
            mockEndpoint.assertIsSatisfied();
            this.eventProducer.send(endpointUri, (Object)objectMessage);
            mockEndpoint.setExpectedCount(0);
            mockEndpoint.assertIsSatisfied();
            return null;
        });
        mockEndpoint.setExpectedCount(2);
        mockEndpoint.assertIsSatisfied();
        String stringMessageSent = (String)((Exchange)mockEndpoint.getExchanges().get(0)).getIn().getBody();
        TransactionAwareEventProducerTest.assertNotNull((Object)stringMessageSent);
        TransactionAwareEventProducerTest.assertEquals((String)stringMessage, (String)stringMessageSent);
        String jsonMessageSent = (String)((Exchange)mockEndpoint.getExchanges().get(1)).getIn().getBody();
        TransactionAwareEventProducerTest.assertNotNull((Object)jsonMessageSent);
        OnContentUpdatePolicyEvent objectMessageSent = (OnContentUpdatePolicyEvent)this.messagingObjectMapper.readValue(jsonMessageSent, OnContentUpdatePolicyEvent.class);
        TransactionAwareEventProducerTest.assertNotNull((Object)objectMessageSent);
        TransactionAwareEventProducerTest.assertEquals((String)objectMessage.getId(), (String)objectMessageSent.getId());
        TransactionAwareEventProducerTest.assertEquals((String)objectMessage.getType(), (String)objectMessageSent.getType());
        TransactionAwareEventProducerTest.assertEquals((Object)objectMessage.getTimestamp(), (Object)objectMessageSent.getTimestamp());
    }

    private String getMockEndpointUri() {
        return "mock:" + ((Object)((Object)this)).getClass().getSimpleName() + "_" + GUID.generate();
    }
}

