/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;

public class VirtualProtocol
extends Protocol {
    private static final long serialVersionUID = -520071882362365522L;
    public static final int ACTUAL_NODE_LOCATION_PARAM_INDEX = 1;
    public static final int TEMPLATE_PATH_PARAM_INDEX = 0;
    public static final Character NODE_TEMPLATE_PATH_TOKEN = Character.valueOf('N');
    public static final Character CLASS_TEMPLATE_PATH_TOKEN = Character.valueOf('C');

    public VirtualProtocol() {
        this("virtual");
    }

    public VirtualProtocol(String name) {
        super(name);
    }

    @Override
    public <R> R dispatch(ProtocolMethod<R> method, Reference reference) throws ProtocolMethodException {
        return method.execute(this, reference);
    }

    public String getTemplatePath(Reference reference) {
        StringParameter parameter = (StringParameter)this.getParameter(reference, 0);
        return (String)parameter.getValue();
    }

    public Reference replaceTemplatePath(Reference reference, String path) {
        return this.replaceParameter(reference, 0, path);
    }

    public RepositoryLocation getActualNodeLocation(Reference reference) {
        ResourceParameter parameter = (ResourceParameter)this.getParameter(reference, 1);
        RepositoryResource repoResource = (RepositoryResource)parameter.getValue();
        return repoResource.getLocation();
    }

    public Reference newReference(NodeRef templateNodeRef, String templatePath, NodeRef actualNodeRef) {
        ParameterCheck.mandatoryString((String)"templatePath", (String)templatePath);
        return this.newReference(new RepositoryResource(new RepositoryNodeRef(templateNodeRef)), templatePath, actualNodeRef, Collections.emptyList());
    }

    public Reference newReference(Resource templateResource, String templatePath, NodeRef actualNodeRef, List<Parameter> extraParameters) {
        ParameterCheck.mandatoryString((String)"templatePath", (String)templatePath);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new StringParameter(templatePath));
        parameters.add(new ResourceParameter(new RepositoryResource(new RepositoryNodeRef(actualNodeRef))));
        parameters.addAll(extraParameters);
        return new Reference(Protocol.DEFAULT_ENCODING, this, templateResource, parameters);
    }

    public Reference newReference(Encoding encoding, Resource templateResource, String templatePath, Resource actualNodeResource, List<Parameter> extraParameters) {
        ParameterCheck.mandatoryString((String)"templatePath", (String)templatePath);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(3);
        parameters.add(new StringParameter(templatePath));
        parameters.add(new ResourceParameter(actualNodeResource));
        parameters.addAll(extraParameters);
        return new Reference(encoding, this, templateResource, parameters);
    }

    public Reference newReference(String templateSysPath, String templatePath, NodeRef actualNodeRef) throws ProtocolMethodException {
        Resource templateResource = this.createSystemPathResource(templateSysPath);
        if (templateResource != null) {
            return this.newReference(templateResource, templatePath, actualNodeRef, Collections.emptyList());
        }
        throw new ProtocolMethodException("Invalid template system path : " + templatePath);
    }

    protected Resource createSystemPathResource(String templateSysPath) {
        char systemToken = templateSysPath.charAt(0);
        Resource templateResource = null;
        if (systemToken == NODE_TEMPLATE_PATH_TOKEN.charValue()) {
            templateResource = new RepositoryResource(new RepositoryPath(templateSysPath.substring(1)));
        } else if (systemToken == CLASS_TEMPLATE_PATH_TOKEN.charValue()) {
            templateResource = new ClasspathResource(templateSysPath.substring(1));
        }
        return templateResource;
    }
}

