/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.alfresco.repo.version.VersionBaseModel;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.VersionLabelComparator;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.util.TempFileProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class VersionHistoryImplTest
extends TestCase {
    private NodeRef nodeRef;
    private Version rootVersion = null;
    private Version childVersion1 = null;
    private Version childVersion2 = null;
    public static final String DESERIALIZE_V22SP4 = "classpath:version-history/VersionHistoryImplTest-testSerialize-V2.2.4.bin";
    public static final String DESERIALIZE_V310_DEV = "classpath:version-history/VersionHistoryImplTest-testSerialize-V3.1.0-dev.bin";
    public static final String DESERIALIZE_V310 = "classpath:version-history/VersionHistoryImplTest-testSerialize-V3.1.0.bin";

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeRef = new NodeRef(new StoreRef("workspace", "test"), "test");
        this.rootVersion = this.newVersion(this.nodeRef, "1");
        this.childVersion1 = this.newVersion(this.nodeRef, "2");
        this.childVersion2 = this.newVersion(this.nodeRef, "3");
    }

    private VersionImpl newVersion(NodeRef nodeRef, String label) {
        HashMap<String, Object> versionProperties1 = new HashMap<String, Object>();
        versionProperties1.put("versionLabel", label);
        versionProperties1.put(VersionBaseModel.PROP_CREATED_DATE, new Date());
        versionProperties1.put("testProperty", "testValue");
        return new VersionImpl(versionProperties1, nodeRef);
    }

    public void testConstructor() {
        this.testContructorImpl();
    }

    private VersionHistoryImpl testContructorImpl() {
        VersionHistoryImpl vh = new VersionHistoryImpl(this.rootVersion, null);
        VersionHistoryImplTest.assertNotNull((Object)vh);
        return vh;
    }

    public void testRootVersionSpecified() {
        try {
            new VersionHistoryImpl(null, null);
            VersionHistoryImplTest.fail();
        }
        catch (VersionServiceException versionServiceException) {}
    }

    public void testGetRootVersion() {
        VersionHistoryImpl vh = this.testContructorImpl();
        Version rootVersion = vh.getRootVersion();
        VersionHistoryImplTest.assertNotNull((Object)rootVersion);
        VersionHistoryImplTest.assertEquals((Object)rootVersion, (Object)this.rootVersion);
    }

    public void testGetAllVersions() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Collection allVersions = vh.getAllVersions();
        VersionHistoryImplTest.assertNotNull((Object)allVersions);
        VersionHistoryImplTest.assertEquals((int)3, (int)allVersions.size());
    }

    public void testGetAllVersionsComparator() {
        String[] labels = new String[]{"1.0", "1.1", "1.2", "2.0", "2.1"};
        ArrayList<VersionImpl> versions = new ArrayList<VersionImpl>(labels.length);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            versions.add(this.newVersion(this.nodeRef, label));
            ++n2;
        }
        Collections.shuffle(versions);
        Iterator itr = versions.iterator();
        Version version = (Version)itr.next();
        VersionHistoryImpl vh = new VersionHistoryImpl(version, Collections.reverseOrder(new VersionLabelComparator()));
        while (itr.hasNext()) {
            Version predecessor = version;
            version = (Version)itr.next();
            vh.addVersion(version, predecessor);
        }
        Collection allVersions = vh.getAllVersions();
        VersionHistoryImplTest.assertNotNull((Object)allVersions);
        VersionHistoryImplTest.assertEquals((int)labels.length, (int)allVersions.size());
        itr = allVersions.iterator();
        String[] stringArray2 = labels;
        int n3 = labels.length;
        int n4 = 0;
        while (n4 < n3) {
            String label = stringArray2[n4];
            VersionHistoryImplTest.assertEquals((String)label, (String)((Version)itr.next()).getVersionLabel());
            ++n4;
        }
    }

    public void testAddVersion() {
        this.testAddVersionImpl();
    }

    private VersionHistoryImpl testAddVersionImpl() {
        VersionHistoryImpl vh = this.testContructorImpl();
        Version rootVersion = vh.getRootVersion();
        vh.addVersion(this.childVersion1, rootVersion);
        vh.addVersion(this.childVersion2, rootVersion);
        return vh;
    }

    public void testGetPredecessor() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Version version1 = vh.getPredecessor(this.childVersion1);
        VersionHistoryImplTest.assertEquals((String)version1.getVersionLabel(), (String)this.rootVersion.getVersionLabel());
        Version version2 = vh.getPredecessor(this.childVersion2);
        VersionHistoryImplTest.assertEquals((String)version2.getVersionLabel(), (String)this.rootVersion.getVersionLabel());
        Version version3 = vh.getPredecessor(this.rootVersion);
        VersionHistoryImplTest.assertNull((Object)version3);
        try {
            Version version4 = vh.getPredecessor(null);
            VersionHistoryImplTest.assertNull((Object)version4);
        }
        catch (Exception exception) {
            VersionHistoryImplTest.fail((String)"Should continue by returning null.");
        }
    }

    public void testGetSuccessors() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Collection versions1 = vh.getSuccessors(this.rootVersion);
        VersionHistoryImplTest.assertNotNull((Object)versions1);
        VersionHistoryImplTest.assertEquals((int)versions1.size(), (int)2);
        for (Version version : versions1) {
            String versionLabel = version.getVersionLabel();
            if (versionLabel == "2" || versionLabel == "3") continue;
            VersionHistoryImplTest.fail((String)"There is a version in this collection that should not be here.");
        }
        Collection versions2 = vh.getSuccessors(this.childVersion1);
        VersionHistoryImplTest.assertNotNull((Object)versions2);
        VersionHistoryImplTest.assertTrue((boolean)versions2.isEmpty());
        Collection versions3 = vh.getSuccessors(this.childVersion2);
        VersionHistoryImplTest.assertNotNull((Object)versions3);
        VersionHistoryImplTest.assertTrue((boolean)versions3.isEmpty());
    }

    public void testGetSuccessorsComparator() {
        this.rootVersion = this.newVersion(this.nodeRef, "1.0");
        String[] labels = new String[]{"1.1", "1.2", "2.0", "2.1"};
        ArrayList<VersionImpl> versions = new ArrayList<VersionImpl>(labels.length);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            versions.add(this.newVersion(this.nodeRef, label));
            ++n2;
        }
        Collections.shuffle(versions);
        Iterator itr = versions.iterator();
        Version version = this.rootVersion;
        VersionHistoryImpl vh = new VersionHistoryImpl(version, Collections.reverseOrder(new VersionLabelComparator()));
        while (itr.hasNext()) {
            vh.addVersion((Version)itr.next(), this.rootVersion);
        }
        Collection allVersions = vh.getSuccessors(this.rootVersion);
        VersionHistoryImplTest.assertNotNull((Object)allVersions);
        VersionHistoryImplTest.assertEquals((int)labels.length, (int)allVersions.size());
        itr = allVersions.iterator();
        String[] stringArray2 = labels;
        int n3 = labels.length;
        int n4 = 0;
        while (n4 < n3) {
            String label = stringArray2[n4];
            VersionHistoryImplTest.assertEquals((String)label, (String)((Version)itr.next()).getVersionLabel());
            ++n4;
        }
    }

    public void testGetVersion() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Version version1 = vh.getVersion("1");
        VersionHistoryImplTest.assertEquals((String)version1.getVersionLabel(), (String)this.rootVersion.getVersionLabel());
        Version version2 = vh.getVersion("2");
        VersionHistoryImplTest.assertEquals((String)version2.getVersionLabel(), (String)this.childVersion1.getVersionLabel());
        Version version3 = vh.getVersion("3");
        VersionHistoryImplTest.assertEquals((String)version3.getVersionLabel(), (String)this.childVersion2.getVersionLabel());
        try {
            vh.getVersion("invalidLabel");
            VersionHistoryImplTest.fail((String)"An exception should have been thrown if the version can not be retrieved.");
        }
        catch (VersionDoesNotExistException exception) {
            System.out.println("Error message: " + exception.getMessage());
        }
    }

    public void testSerialize() throws Exception {
        VersionHistoryImpl vhObj;
        File file = TempFileProvider.createTempFile((String)this.getName(), (String)".bin");
        System.out.println("Test " + this.getName() + " writing to " + file.getPath());
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(file));
        VersionHistoryImpl vh = this.testAddVersionImpl();
        try {
            os.writeObject(vh);
        }
        catch (Throwable throwable) {
            try {
                os.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            os.close();
        }
        catch (Throwable throwable) {}
        ObjectInputStream is = new ObjectInputStream(new FileInputStream(file));
        try {
            vhObj = (VersionHistoryImpl)is.readObject();
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {}
        VersionHistoryImplTest.assertNotNull((Object)vhObj);
        VersionHistoryImplTest.assertNotNull((String)"No root version", (Object)vhObj.getRootVersion());
        VersionHistoryImplTest.assertEquals((String)"Deserialized object does not match original", (Object)vh.getRootVersion().getFrozenStateNodeRef(), (Object)vhObj.getRootVersion().getFrozenStateNodeRef());
    }

    public void testDeserializeV22SP4() throws Exception {
        String[] resourceLocations;
        String[] stringArray = resourceLocations = new String[]{DESERIALIZE_V22SP4, DESERIALIZE_V310_DEV, DESERIALIZE_V310};
        int n = resourceLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceLocation = stringArray[n2];
            Resource resource = new DefaultResourceLoader().getResource(resourceLocation);
            VersionHistoryImplTest.assertNotNull((String)("Unable to find " + resourceLocation), (Object)resource);
            VersionHistoryImplTest.assertTrue((String)("Unable to find " + resourceLocation), (boolean)resource.exists());
            ObjectInputStream is = new ObjectInputStream(resource.getInputStream());
            try {
                VersionHistoryImpl cfr_ignored_0 = (VersionHistoryImpl)is.readObject();
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Throwable throwable) {}
            ++n2;
        }
    }
}

