/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.model.DataListModel;
import org.alfresco.repo.event2.shared.TypeDefExpander;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TypeDefExpanderUnitTest {
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private TypeDefExpander typeDefExpander;

    @Before
    public void setUp() {
        this.dictionaryService = (DictionaryService)Mockito.mock(DictionaryService.class);
        this.namespaceService = (NamespaceService)Mockito.mock(NamespaceService.class);
        this.typeDefExpander = new TypeDefExpander(this.dictionaryService, this.namespaceService);
    }

    @Test
    public void testExpandWithValidType() {
        String input = "usr:username";
        Mockito.when((Object)this.namespaceService.getNamespaceURI("usr")).thenReturn((Object)"http://www.alfresco.org/model/user/1.0");
        Collection result = this.typeDefExpander.expand(input);
        QName expected = ContentModel.PROP_USER_USERNAME;
        Assert.assertEquals((Object)expected, result.iterator().next());
    }

    @Test
    public void testExpandWithValidTypeIncludingSubtypes() {
        String input = "cm:content include_subtypes";
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Set<QName> subtypes = Set.of(TransferModel.TYPE_TRANSFER_RECORD, DataListModel.TYPE_EVENT, WorkflowModel.TYPE_TASK);
        Mockito.when((Object)this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true)).thenReturn(subtypes);
        Collection result = this.typeDefExpander.expand(input);
        Assert.assertEquals(subtypes, (Object)result);
    }

    @Test
    public void testExpandWithInvalidTypes() {
        Set input = Stream.of(null, " ", "none", "${test.prop}").collect(Collectors.toSet());
        Set result = this.typeDefExpander.expand(input);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

