/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.NumericPathHasher;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolHashStringifier;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.Stringifier;
import org.alfresco.util.Pair;

public class VirtualHashStringifier
extends ProtocolHashStringifier {
    private static final long serialVersionUID = -252596166306653635L;
    private NumericPathHasher numericPathHasher = new NumericPathHasher();

    public VirtualHashStringifier(HashStore classpathHashStore, Stringifier referenceDispatcher) {
        super(classpathHashStore, referenceDispatcher);
    }

    @Override
    public String stringify(Reference reference) throws ReferenceEncodingException {
        Protocol protocol = reference.getProtocol();
        if (!Protocols.VIRTUAL.protocol.equals(protocol)) {
            throw new ReferenceEncodingException("Unsupported protocol " + String.valueOf(protocol) + "." + Protocols.VIRTUAL.protocol.name + " exoected ");
        }
        return "2-" + this.stringifyVirtualReference(reference);
    }

    protected String stringifyVirtualReference(Reference reference) {
        Resource resource = reference.getResource();
        String resourceString = resource.stringify(this);
        List<Parameter> parameters = reference.getParameters();
        ResourceParameter actualNodeParameter = (ResourceParameter)parameters.get(1);
        Resource actualNodeResource = (Resource)actualNodeParameter.getValue();
        String actualNodeResourceString = actualNodeResource.stringify(this);
        StringParameter templatePathParameter = (StringParameter)parameters.get(0);
        String pathString = (String)templatePathParameter.getValue();
        Pair<String, String> pathHash = this.numericPathHasher.hash(pathString);
        StringBuilder stringifiedPath = new StringBuilder();
        String hashed = (String)pathHash.getFirst();
        String nonHashed = (String)pathHash.getSecond();
        if (nonHashed == null) {
            stringifiedPath.append("3");
            stringifiedPath.append(hashed);
        } else if (hashed == null) {
            if (nonHashed.isEmpty()) {
                stringifiedPath.append("1");
            } else {
                stringifiedPath.append("2");
                stringifiedPath.append(nonHashed);
            }
        } else {
            stringifiedPath.append("4");
            stringifiedPath.append(hashed);
            stringifiedPath.append("-");
            stringifiedPath.append(nonHashed);
        }
        String parametersString = actualNodeResourceString + "-" + stringifiedPath.toString();
        return resourceString + "-" + parametersString;
    }
}

