/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.FileNameValidator;

public class FileNameValidatorTest
extends TestCase {
    public void testValidator() {
        String[] badNames;
        String[] stringArray = badNames = new String[]{"\"", "\\", "/", "<", ">", "?", "*", ":", "|", "."};
        int n = badNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            FileNameValidatorTest.assertFalse((boolean)FileNameValidator.isValid((String)name));
            ++n2;
        }
    }

    public void testGetValidFileName() {
        FileNameValidatorTest.assertEquals((String)"ABCDEFG.txt", (String)FileNameValidator.getValidFileName((String)"ABCDEFG.txt"));
        FileNameValidatorTest.assertEquals((String)"A_B_C_D_E_F_G_H_I_J.txt", (String)FileNameValidator.getValidFileName((String)"A\"B*C\\D>E<F?G/H:I|J.txt"));
        FileNameValidatorTest.assertEquals((String)"A_B_C_D_E_F_G_H_I_J_", (String)FileNameValidator.getValidFileName((String)"A\"B*C\\D>E<F?G/H:I|J."));
        FileNameValidatorTest.assertEquals((String)"A dot in the end is not permitted_", (String)FileNameValidator.getValidFileName((String)"A dot in the end is not permitted."));
        FileNameValidatorTest.assertEquals((String)"Dots in the end are not permitted..._", (String)FileNameValidator.getValidFileName((String)"Dots in the end are not permitted...."));
        FileNameValidatorTest.assertEquals((String)".Dots.are.allowed.if. .not.at.the.end", (String)FileNameValidator.getValidFileName((String)".Dots.are.allowed.if. .not.at.the.end"));
        FileNameValidatorTest.assertEquals((String)" Spaces are permited  ", (String)FileNameValidator.getValidFileName((String)" Spaces are permited  "));
    }
}

