/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class ObjectMapperFactory {
    private ObjectMapperFactory() {
    }

    public static ObjectMapper createInstance() {
        QpidJsonBodyCleanerObjectMapper mapper = new QpidJsonBodyCleanerObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return mapper;
    }

    private static class QpidJsonBodyCleanerObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 2568701685293341501L;
        private static final String DEFAULT_ENCODING = "utf8";

        private QpidJsonBodyCleanerObjectMapper() {
        }

        public <T> T readValue(InputStream inputStream, Class<T> valueType) throws IOException {
            try {
                if (inputStream.markSupported()) {
                    inputStream.mark(524288);
                }
                return (T)super.readValue(inputStream, valueType);
            }
            catch (JsonParseException e) {
                if (!inputStream.markSupported()) {
                    throw e;
                }
                inputStream.reset();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)DEFAULT_ENCODING);
                String content = writer.toString();
                content = content.substring(content.indexOf(123));
                return (T)this.readValue(content, valueType);
            }
        }
    }
}

