/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.List;
import org.alfresco.repo.module.DeprecatedModulesValidator;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DeprecatedModulesValidatorTest {
    private static final String DEPRECATED_MODULE_1 = "deprecated-module-1";
    private static final String DEPRECATED_MODULE_2 = "deprecated-module-2";
    private static final String VALID_MODULE = "valid-module";
    private static final List<String> DEPRECATED_MODULES = List.of("deprecated-module-1", "deprecated-module-2");
    @Mock
    private ModuleService moduleService;
    @Mock
    private ModuleDetails moduleDetails;
    private DeprecatedModulesValidator deprecatedModulesValidator;

    @Before
    public void setUp() {
        this.deprecatedModulesValidator = new DeprecatedModulesValidator(this.moduleService, DEPRECATED_MODULES);
    }

    @Test
    public void shouldDoNothingWhenNoModulesAreFound() {
        Mockito.when((Object)this.moduleService.getAllModules()).thenReturn(null);
        this.deprecatedModulesValidator.onInit();
        ((ModuleService)Mockito.verify((Object)this.moduleService)).getAllModules();
    }

    @Test
    public void shouldDoNothingWhenNoDeprecatedModulesAreFound() {
        Mockito.when((Object)this.moduleService.getAllModules()).thenReturn(List.of(this.moduleDetails));
        Mockito.when((Object)this.moduleDetails.getId()).thenReturn((Object)VALID_MODULE);
        this.deprecatedModulesValidator.onInit();
        ((ModuleService)Mockito.verify((Object)this.moduleService)).getAllModules();
        ((ModuleDetails)Mockito.verify((Object)this.moduleDetails)).getId();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenADeprecatedModuleIsFound() {
        Mockito.when((Object)this.moduleService.getAllModules()).thenReturn(List.of(this.moduleDetails));
        Mockito.when((Object)this.moduleDetails.getId()).thenReturn((Object)DEPRECATED_MODULE_1);
        this.deprecatedModulesValidator.onInit();
    }

    @Test
    public void shouldThrowExceptionWhenMultipleDeprecatedModulesAreFound() {
        Mockito.when((Object)this.moduleService.getAllModules()).thenReturn(List.of(this.moduleDetails, this.moduleDetails));
        Mockito.when((Object)this.moduleDetails.getId()).thenReturn((Object)DEPRECATED_MODULE_1).thenReturn((Object)DEPRECATED_MODULE_2);
        Assert.assertThrows((String)"IllegalStateException should be thrown.", IllegalStateException.class, () -> this.deprecatedModulesValidator.onInit());
        ((ModuleService)Mockito.verify((Object)this.moduleService)).getAllModules();
        ((ModuleDetails)Mockito.verify((Object)this.moduleDetails, (VerificationMode)Mockito.times((int)2))).getId();
    }

    @Test
    public void shouldThrowExceptionWhenBothValidAndDeprecatedModulesAreFound() {
        Mockito.when((Object)this.moduleService.getAllModules()).thenReturn(List.of(this.moduleDetails, this.moduleDetails));
        Mockito.when((Object)this.moduleDetails.getId()).thenReturn((Object)VALID_MODULE).thenReturn((Object)DEPRECATED_MODULE_2);
        Assert.assertThrows((String)"IllegalStateException should be thrown.", IllegalStateException.class, () -> this.deprecatedModulesValidator.onInit());
        ((ModuleService)Mockito.verify((Object)this.moduleService)).getAllModules();
        ((ModuleDetails)Mockito.verify((Object)this.moduleDetails, (VerificationMode)Mockito.times((int)2))).getId();
    }
}

