/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class EmptyTranslationAspectTest
extends AbstractMultilingualTestCases {
    protected ContentService contentService;

    @Override
    protected void setUp() throws Exception {
        this.contentService = (ContentService)AbstractMultilingualTestCases.ctx.getBean("ContentService");
        super.setUp();
    }

    public void testCopy() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef empty = null;
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        empty = this.multilingualContentService.addEmptyTranslation(pivot, "empty_" + System.currentTimeMillis(), Locale.CHINESE);
        boolean exceptionCatched = false;
        NodeRef copy = null;
        try {
            copy = this.fileFolderService.copy(empty, this.nodeService.getPrimaryParent(empty).getParentRef(), "copyOfEmpty" + System.currentTimeMillis()).getNodeRef();
        }
        catch (Exception exception) {
            exceptionCatched = true;
        }
        EmptyTranslationAspectTest.assertTrue((String)"The copy of a translation must throws an exception", (boolean)exceptionCatched);
        EmptyTranslationAspectTest.assertNull((String)"The copy must fail ", copy);
    }

    public void testDeleteNode() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef empty = null;
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        empty = this.multilingualContentService.addEmptyTranslation(pivot, "empty_" + System.currentTimeMillis(), Locale.CHINESE);
        this.nodeService.getParentAssocs(empty);
        this.nodeService.deleteNode(empty);
        EmptyTranslationAspectTest.assertFalse((String)"The empty translation must be removed from the wokspace", (boolean)this.nodeService.exists(empty));
        EmptyTranslationAspectTest.assertFalse((String)"The empty translation must be removed from the wokspace", (boolean)this.nodeService.exists(this.nodeArchiveService.getArchivedNode(empty)));
    }

    public void testGetContent() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef otherTranslation = this.createContent();
        NodeRef empty = null;
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(pivot);
        this.multilingualContentService.addTranslation(otherTranslation, pivot, Locale.KOREAN);
        empty = this.multilingualContentService.addEmptyTranslation(pivot, "empty_" + System.currentTimeMillis(), Locale.CHINESE);
        Object contentString = this.fileFolderService.getReader(pivot).getContentString();
        contentString = (String)contentString + "_TEST_";
        this.fileFolderService.getWriter(pivot).putContent((String)contentString);
        EmptyTranslationAspectTest.assertEquals((String)"The content retourned of the empty translation must be the same that the content of the pivot", (String)this.fileFolderService.getReader(pivot).getContentString(), (String)this.fileFolderService.getReader(empty).getContentString());
        EmptyTranslationAspectTest.assertNotSame((String)"The content retourned of the empty translation must be different that the content of a non-pivot translation", (Object)this.fileFolderService.getReader(otherTranslation).getContentString(), (Object)this.fileFolderService.getReader(empty).getContentString());
        Map props = this.nodeService.getProperties(mlContainer);
        props.put(ContentModel.PROP_LOCALE, Locale.KOREAN);
        this.nodeService.setProperties(mlContainer, props);
        EmptyTranslationAspectTest.assertEquals((String)"The modification of the pivot is not take in account", (String)this.fileFolderService.getReader(otherTranslation).getContentString(), (String)this.fileFolderService.getReader(empty).getContentString());
    }

    public void testUpdateContent() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef empty = null;
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        empty = this.multilingualContentService.addEmptyTranslation(pivot, "empty_" + System.currentTimeMillis(), Locale.CHINESE);
        ContentWriter writer = this.contentService.getWriter(empty, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("ANY_CONTENT");
        EmptyTranslationAspectTest.assertNotNull((String)"The url of an updated (ex)empty transation can't be null", (Object)((ContentData)this.nodeService.getProperty(empty, ContentModel.PROP_CONTENT)).getContentUrl());
        EmptyTranslationAspectTest.assertFalse((String)("The " + String.valueOf(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION) + " aspect of an updated (ex)empty translation must be removed"), (boolean)this.nodeService.hasAspect(empty, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION));
        EmptyTranslationAspectTest.assertTrue((String)("The " + String.valueOf(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT) + " aspect of an updated (ex)empty translation must be keeped"), (boolean)this.nodeService.hasAspect(empty, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        EmptyTranslationAspectTest.assertEquals((String)"The content of the (ex)empty translation is not correct", (String)this.fileFolderService.getReader(empty).getContentString(), (String)"ANY_CONTENT");
        EmptyTranslationAspectTest.assertNotSame((String)"The content of the (ex)empty translation is not updated and is the same as the content of the pivot", (Object)this.fileFolderService.getReader(empty).getContentString(), (Object)this.fileFolderService.getReader(pivot).getContentString());
    }
}

