/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.FormService;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:org/alfresco/repo/forms/MNT-7383-context.xml"})
public class ActionFormProcessorTest
extends BaseAlfrescoSpringTest {
    private RetryingTransactionHelper transactionHelper;
    private NamespaceService namespaceService;
    private Repository repositoryHelper;
    private FormService formService;
    private NodeRef testNode;
    private List<NodeRef> testNodesToBeTidiedUp;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.formService = (FormService)this.applicationContext.getBean("FormService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        this.testNode = this.createNode(companyHome, "testDoc" + ActionFormProcessorTest.class.getSimpleName() + ".txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.contentService.getWriter(this.testNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("Irrelevant content");
        this.testNodesToBeTidiedUp = new ArrayList<NodeRef>();
        this.testNodesToBeTidiedUp.add(this.testNode);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    @Override
    @After
    public void after() throws Exception {
        super.after();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (NodeRef node : this.testNodesToBeTidiedUp) {
            if (!this.nodeService.exists(node)) continue;
            this.nodeService.deleteNode(node);
        }
        this.authenticationService.clearCurrentSecurityContext();
    }

    @Override
    protected NodeRef createNode(NodeRef parentNode, String name, QName type) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        QName docContentQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
        NodeRef node = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, docContentQName, type, props).getChildRef();
        return node;
    }

    @Test
    public void testRequestFormForNonExistentAction() throws Exception {
        try {
            this.formService.getForm(new Item("action", "noSuchActionBean"));
            ActionFormProcessorTest.fail((String)"Expected FormNotFoundException");
        }
        catch (FormNotFoundException formNotFoundException) {}
    }

    @Test
    public void testGenerateDefaultFormForParameterlessAction() throws Exception {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Form form = ActionFormProcessorTest.this.formService.getForm(new Item("action", "extract-metadata"));
                ActionFormProcessorTest.assertNotNull((String)"Expecting form to be present", (Object)form);
                List fieldDefs = form.getFieldDefinitions();
                ActionFormProcessorTest.assertEquals((String)"Wrong number of fieldDefs", (int)1, (int)fieldDefs.size());
                HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDefMap.put(fieldDef.getName(), fieldDef);
                }
                ActionFormProcessorTest.this.validateExecuteAsynchronouslyField(fieldDefMap);
                return null;
            }
        });
    }

    @Test
    public void testGenerateDefaultFormForActionWithNodeRefParam() throws Exception {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Form form = ActionFormProcessorTest.this.formService.getForm(new Item("action", "script"));
                ActionFormProcessorTest.assertNotNull((String)"Expecting form to be present", (Object)form);
                List fieldDefs = form.getFieldDefinitions();
                ActionFormProcessorTest.assertEquals((String)"Wrong number of fieldDefs", (int)2, (int)fieldDefs.size());
                HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDefMap.put(fieldDef.getName(), fieldDef);
                }
                ActionFormProcessorTest.this.validateExecuteAsynchronouslyField(fieldDefMap);
                PropertyFieldDefinition scriptRef = (PropertyFieldDefinition)fieldDefMap.get("script-ref");
                ActionFormProcessorTest.assertNotNull((String)"'script-ref' field defn was missing.", (Object)scriptRef);
                ActionFormProcessorTest.assertEquals((String)"script-ref", (String)scriptRef.getName());
                ActionFormProcessorTest.assertEquals((String)"Script", (String)scriptRef.getLabel());
                ActionFormProcessorTest.assertEquals((String)"script-ref", (String)scriptRef.getDescription());
                ActionFormProcessorTest.assertEquals((String)"text", (String)scriptRef.getDataType());
                ActionFormProcessorTest.assertTrue((boolean)scriptRef.isMandatory());
                List constraints = scriptRef.getConstraints();
                ActionFormProcessorTest.assertEquals((int)1, (int)constraints.size());
                ActionFormProcessorTest.assertEquals((String)"LIST", (String)((PropertyFieldDefinition.FieldConstraint)constraints.get(0)).getType());
                return null;
            }
        });
    }

    private void validateExecuteAsynchronouslyField(Map<String, FieldDefinition> fieldDefMap) {
        PropertyFieldDefinition execAsync = (PropertyFieldDefinition)fieldDefMap.get("executeAsynchronously");
        ActionFormProcessorTest.assertNotNull((String)"'executeAsynchronously' field defn was missing.", (Object)execAsync);
        ActionFormProcessorTest.assertEquals((String)"'executeAsynchronously' name was wrong", (String)"executeAsynchronously", (String)execAsync.getName());
        ActionFormProcessorTest.assertEquals((String)"'executeAsynchronously' label was wrong", (String)"executeAsynchronously", (String)execAsync.getLabel());
        ActionFormProcessorTest.assertNull((String)"'executeAsynchronously' description was wrong", (Object)execAsync.getDescription());
        ActionFormProcessorTest.assertEquals((String)"'executeAsynchronously' datatype was wrong", (String)"boolean", (String)execAsync.getDataType());
    }

    @Test
    public void testGenerateFormWithSpecificLocale() {
        Locale originalLocale = I18NUtil.getLocale();
        try {
            I18NUtil.setLocale((Locale)Locale.GERMANY);
            this.transactionHelper.doInTransaction(() -> {
                Form form = this.formService.getForm(new Item("action", "transform"));
                Map fieldDefMap = form.getFieldDefinitions().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
                ActionFormProcessorTest.assertEquals((String)"Zielordner", (String)((FieldDefinition)fieldDefMap.get("destination-folder")).getLabel());
                ActionFormProcessorTest.assertEquals((String)"MIME-Type", (String)((FieldDefinition)fieldDefMap.get("mime-type")).getLabel());
                return null;
            });
        }
        finally {
            I18NUtil.setLocale((Locale)originalLocale);
        }
    }

    @Test
    public void testGenerateFormWithSelectedFields() throws Exception {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ArrayList<String> fields = new ArrayList<String>();
                fields.add("destination-folder");
                fields.add("executeAsynchronously");
                Form form = ActionFormProcessorTest.this.formService.getForm(new Item("action", "move"), fields);
                ActionFormProcessorTest.assertNotNull((String)"Expecting form to be present", (Object)form);
                List fieldDefs = form.getFieldDefinitions();
                HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDefMap.put(fieldDef.getName(), fieldDef);
                }
                ActionFormProcessorTest.assertEquals((int)2, (int)fieldDefMap.size());
                AssociationFieldDefinition destFolderField = (AssociationFieldDefinition)fieldDefMap.get("destination-folder");
                ActionFormProcessorTest.assertNotNull((Object)destFolderField);
                PropertyFieldDefinition execAsyncField = (PropertyFieldDefinition)fieldDefMap.get("executeAsynchronously");
                ActionFormProcessorTest.assertNotNull((Object)execAsyncField);
                return null;
            }
        });
    }

    @Test
    public void testPersistForm_executeTransformAction() throws Exception {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Form form = ActionFormProcessorTest.this.formService.getForm(new Item("action", "transform"));
                form.addData("alf_destination", (Object)ActionFormProcessorTest.this.testNode.toString());
                form.addData("prop_mime-type", (Object)"text/xml");
                form.addData("prop_destination-folder", (Object)ActionFormProcessorTest.this.repositoryHelper.getCompanyHome().toString());
                form.addData("prop_assoc-type", (Object)ContentModel.ASSOC_CONTAINS.toPrefixString((NamespacePrefixResolver)ActionFormProcessorTest.this.namespaceService));
                form.addData("prop_assoc-name", (Object)ContentModel.ASSOC_CONTAINS.toPrefixString((NamespacePrefixResolver)ActionFormProcessorTest.this.namespaceService));
                ActionFormProcessorTest.this.formService.saveForm(form.getItem(), form.getFormData());
                for (ChildAssociationRef chAssRef : ActionFormProcessorTest.this.nodeService.getChildAssocs(ActionFormProcessorTest.this.repositoryHelper.getCompanyHome())) {
                    System.err.println(ActionFormProcessorTest.this.nodeService.getProperty(chAssRef.getChildRef(), ContentModel.PROP_NAME));
                }
                Serializable cmName = ActionFormProcessorTest.this.nodeService.getProperty(ActionFormProcessorTest.this.testNode, ContentModel.PROP_NAME);
                String transformedNodeName = ((String)((Object)cmName)).replace(".txt", ".xml");
                NodeRef expectedTransformedNode = ActionFormProcessorTest.this.nodeService.getChildByName(ActionFormProcessorTest.this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, transformedNodeName);
                ActionFormProcessorTest.assertNotNull((String)"transformed node was missing", (Object)expectedTransformedNode);
                ActionFormProcessorTest.this.testNodesToBeTidiedUp.add(expectedTransformedNode);
                return null;
            }
        });
    }

    @Test
    public void testMNT7383() throws Exception {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Form form = ActionFormProcessorTest.this.formService.getForm(new Item("action", "actionFormProcessorTestActionExecuter"));
                ActionFormProcessorTest.assertNotNull((String)"Expecting form to be present", (Object)form);
                form.addData("prop_check", (Object)Boolean.TRUE);
                form.addData("prop_date", (Object)new Date());
                ArrayList<QName> qnameList = new ArrayList<QName>();
                qnameList.add(ContentModel.TYPE_PERSON);
                qnameList.add(ContentModel.TYPE_FOLDER);
                form.addData("prop_qname", qnameList);
                ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
                nodeRefList.add(ActionFormProcessorTest.this.repositoryHelper.getCompanyHome());
                nodeRefList.add(ActionFormProcessorTest.this.repositoryHelper.getRootHome());
                form.addData("prop_nodeRefs", nodeRefList);
                ActionFormProcessorTest.this.formService.saveForm(form.getItem(), form.getFormData());
                return null;
            }
        });
    }

    public static class ActionFormProcessorTestActionExecuter
    extends ActionExecuterAbstractBase {
        public static final String NAME = "actionFormProcessorTestActionExecuter";

        protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
            paramList.add((ParameterDefinition)new ParameterDefinitionImpl("check", DataTypeDefinition.BOOLEAN, false, "Check"));
            paramList.add((ParameterDefinition)new ParameterDefinitionImpl("date", DataTypeDefinition.DATE, false, "Date"));
            paramList.add((ParameterDefinition)new ParameterDefinitionImpl("qname", DataTypeDefinition.QNAME, false, "QName", true));
            paramList.add((ParameterDefinition)new ParameterDefinitionImpl("nodeRefs", DataTypeDefinition.NODE_REF, false, "NodeRefs", true));
        }

        protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
            Serializable checkValue = action.getParameterValue("check");
            ActionFormProcessorTest.assertEquals((String)"Parameter value should be Boolean", checkValue.getClass(), Boolean.class);
            Serializable dateValue = action.getParameterValue("date");
            ActionFormProcessorTest.assertEquals((String)"Parameter value should be Date", dateValue.getClass(), Date.class);
            Serializable qnameValue = action.getParameterValue("qname");
            ActionFormProcessorTest.assertEquals((String)"Parameter value should be ArrayList", qnameValue.getClass(), ArrayList.class);
            for (QName qname : (ArrayList)qnameValue) {
                ActionFormProcessorTest.assertEquals((String)"The item value should be QName", qname.getClass(), QName.class);
            }
            Serializable nodeRefsValue = action.getParameterValue("nodeRefs");
            ActionFormProcessorTest.assertEquals((String)"Parameter value should be ArrayList", nodeRefsValue.getClass(), ArrayList.class);
            for (NodeRef nodeRef : (ArrayList)nodeRefsValue) {
                ActionFormProcessorTest.assertEquals((String)"The item value should be NodeRef", nodeRef.getClass(), NodeRef.class);
            }
        }
    }
}

