/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Locale;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractWritableContentStoreTest
extends AbstractReadOnlyContentStoreTest {
    protected static Log logger = LogFactory.getLog(AbstractWritableContentStoreTest.class);

    @Override
    protected String getExistingContentUrl() {
        ContentWriter writer = this.getWriter();
        writer.putContent("Content for getExistingContentUrl");
        return writer.getContentUrl();
    }

    protected ContentWriter getWriter() {
        ContentStore store = this.getStore();
        return store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
    }

    @Override
    @Test
    public void testSetUp() throws Exception {
        ContentStore store = this.getStore();
        Assert.assertNotNull((String)"No store provided", (Object)store);
        Assert.assertTrue((String)"The same instance of the store must be returned for getStore", (store == this.getStore() ? 1 : 0) != 0);
    }

    @Test
    public void testWritable() throws Exception {
        ContentStore store = this.getStore();
        Assert.assertTrue((String)"The store cannot be read-only", (boolean)store.isWriteSupported());
    }

    @Test
    public void testSpaceFree() throws Exception {
        ContentStore store = this.getStore();
        store.getSpaceFree();
    }

    @Test
    public void testSpaceTotal() throws Exception {
        ContentStore store = this.getStore();
        store.getSpaceTotal();
    }

    @Test
    public void testRootLocation() throws Exception {
        ContentStore store = this.getStore();
        String rootLocation = store.getRootLocation();
        Assert.assertNotNull((String)"The root location may not be null", (Object)rootLocation);
    }

    private void checkIllegalWritableContentUrl(ContentStore store, String contentUrl) {
        Assert.assertFalse((String)"This check is for unsupported content URLs only", (boolean)store.isContentUrlSupported(contentUrl));
        ContentContext bogusContentCtx = new ContentContext(null, contentUrl);
        try {
            store.getWriter(bogusContentCtx);
            Assert.fail((String)"Expected UnsupportedContentUrlException, but got nothing");
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
    }

    @Test
    public void testIllegalWritableContentUrls() {
        ContentStore store = this.getStore();
        this.checkIllegalWritableContentUrl(store, "://bogus");
        this.checkIllegalWritableContentUrl(store, "bogus://");
        this.checkIllegalWritableContentUrl(store, "bogus://bogus");
    }

    @Test
    public void testSimpleUse() {
        ContentStore store = this.getStore();
        String content = "Content for testSimpleUse";
        ContentWriter writer = store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
        Assert.assertNotNull((String)"Writer may not be null", (Object)writer);
        String contentUrlBefore = writer.getContentUrl();
        Assert.assertNotNull((String)"Content URL may not be null for unused writer", (Object)contentUrlBefore);
        Assert.assertTrue((String)("URL is not valid: " + contentUrlBefore), (boolean)AbstractContentStore.isValidContentUrl((String)contentUrlBefore));
        writer.putContent(content);
        String contentUrlAfter = writer.getContentUrl();
        Assert.assertTrue((String)("URL is not valid: " + contentUrlBefore), (boolean)AbstractContentStore.isValidContentUrl((String)contentUrlAfter));
        Assert.assertEquals((String)"The content URL may not change just because the writer has put content", (Object)contentUrlBefore, (Object)contentUrlAfter);
        ContentReader reader = store.getReader(contentUrlBefore);
        Assert.assertNotNull((String)"Reader from store is null", (Object)reader);
        Assert.assertEquals((Object)reader.getContentUrl(), (Object)writer.getContentUrl());
        String checkContent = reader.getContentString();
        Assert.assertEquals((String)"Content is different", (Object)content, (Object)checkContent);
    }

    @Test
    public synchronized void testGetReader() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
        String contentUrl = writer.getContentUrl();
        ContentReader readerFromStoreBeforeWrite = store.getReader(contentUrl);
        Assert.assertNotNull((String)"A reader must always be available from the store", (Object)readerFromStoreBeforeWrite);
        ContentReader readerFromWriterBeforeWrite = writer.getReader();
        Assert.assertNotNull((String)"A reader must always be available from the writer", (Object)readerFromWriterBeforeWrite);
        String content = "Content for testGetReader";
        long before = System.currentTimeMillis();
        this.wait(1000L);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.setLocale(Locale.CHINESE);
        writer.putContent(content);
        this.wait(1000L);
        long after = System.currentTimeMillis();
        ContentReader readerFromStore = store.getReader(contentUrl);
        Assert.assertNotNull((Object)readerFromStore);
        Assert.assertTrue((boolean)readerFromStore.exists());
        Assert.assertEquals((Object)content, (Object)readerFromStore.getContentString());
        ContentReader readerFromWriter = writer.getReader();
        Assert.assertNotNull((Object)readerFromWriter);
        Assert.assertTrue((boolean)readerFromWriter.exists());
        Assert.assertEquals((Object)writer.getContentData(), (Object)readerFromWriter.getContentData());
        Assert.assertEquals((Object)content, (Object)readerFromWriter.getContentString());
        ContentReader readerFromReader = readerFromWriter.getReader();
        Assert.assertNotNull((Object)readerFromReader);
        Assert.assertTrue((boolean)readerFromReader.exists());
        Assert.assertEquals((Object)writer.getContentData(), (Object)readerFromReader.getContentData());
        Assert.assertEquals((Object)content, (Object)readerFromReader.getContentString());
        int length = content.getBytes(writer.getEncoding()).length;
        Assert.assertEquals((String)"Reader content length is incorrect", (long)length, (long)readerFromWriter.getSize());
        long modifiedTimeCheck = readerFromWriter.getLastModified();
        long beforeSeconds = before / 1000L;
        long afterSeconds = after / 1000L;
        long modifiedTimeCheckSeconds = modifiedTimeCheck / 1000L;
        Assert.assertTrue((String)"Reader last modified is incorrect", (beforeSeconds <= modifiedTimeCheckSeconds ? 1 : 0) != 0);
        Assert.assertTrue((String)"Reader last modified is incorrect", (modifiedTimeCheckSeconds <= afterSeconds ? 1 : 0) != 0);
    }

    @Test
    public void testReaderImmutability() {
        ContentWriter writer = this.getWriter();
        ContentReader readerBeforeWrite = writer.getReader();
        Assert.assertNotNull((Object)readerBeforeWrite);
        Assert.assertFalse((boolean)readerBeforeWrite.exists());
        writer.putContent("Content for testReaderImmutability");
        Assert.assertFalse((String)"Reader's state changed after write", (boolean)readerBeforeWrite.exists());
        try {
            readerBeforeWrite.getContentString();
            Assert.fail((String)"Reader's state changed after write");
        }
        catch (ContentIOException contentIOException) {}
        ContentReader readerAfterWrite = writer.getReader();
        Assert.assertTrue((String)"New reader after write should be directed to new content", (boolean)readerAfterWrite.exists());
    }

    @Test
    public void testMimetypAndEncodingAndLocale() throws Exception {
        ContentWriter writer = this.getWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-16");
        writer.setLocale(Locale.CHINESE);
        String content = "A little bit o' this and a little bit o' that";
        byte[] bytesUtf16 = content.getBytes("UTF-16");
        OutputStream os = writer.getContentOutputStream();
        os.write(bytesUtf16);
        os.close();
        ContentReader reader = writer.getReader();
        Assert.assertEquals((String)"Writer -> Reader content URL mismatch", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Writer -> Reader mimetype mismatch", (Object)writer.getMimetype(), (Object)reader.getMimetype());
        Assert.assertEquals((String)"Writer -> Reader encoding mismatch", (Object)writer.getEncoding(), (Object)reader.getEncoding());
        Assert.assertEquals((String)"Writer -> Reader locale mismatch", (Object)writer.getLocale(), (Object)reader.getLocale());
        String contentCheck = reader.getContentString();
        Assert.assertEquals((String)"Encoding and decoding of strings failed", (Object)content, (Object)contentCheck);
    }

    @Test
    public void testClosedState() throws Exception {
        ContentWriter writer = this.getWriter();
        ContentReader readerBeforeWrite = writer.getReader();
        Assert.assertFalse((String)"Reader stream should not be closed", (boolean)readerBeforeWrite.isClosed());
        Assert.assertFalse((String)"Writer stream should not be closed", (boolean)writer.isClosed());
        writer.putContent("ABC");
        Assert.assertTrue((String)"Writer stream should be closed", (boolean)writer.isClosed());
        ContentReader readerAfterWrite = writer.getReader();
        Assert.assertNotNull((String)"No reader given by closed writer", (Object)readerAfterWrite);
        Assert.assertFalse((String)"Before-content reader should not be affected by content updates", (boolean)readerBeforeWrite.isClosed());
        Assert.assertFalse((String)"After content reader should not be closed", (boolean)readerAfterWrite.isClosed());
        ContentReader newReaderA = writer.getReader();
        ContentReader newReaderB = writer.getReader();
        Assert.assertFalse((String)"Reader must always be a new instance", (newReaderA == newReaderB ? 1 : 0) != 0);
        Assert.assertEquals((String)"Readers should refer to same URL", (Object)readerBeforeWrite.getContentUrl(), (Object)readerAfterWrite.getContentUrl());
        try {
            readerBeforeWrite.getContentString();
        }
        catch (Throwable throwable) {}
        String contentCheck = readerAfterWrite.getContentString();
        Assert.assertEquals((String)"Incorrect content", (Object)"ABC", (Object)contentCheck);
        Assert.assertFalse((String)"Before-content reader stream should not be closed", (boolean)readerBeforeWrite.isClosed());
        Assert.assertTrue((String)"After-content reader should be closed after reading", (boolean)readerAfterWrite.isClosed());
    }

    @Test
    public void testDeleteSimple() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = this.getWriter();
        writer.putContent("Content for testDeleteSimple");
        String contentUrl = writer.getContentUrl();
        Assert.assertTrue((String)"Content must now exist", (boolean)store.exists(contentUrl));
        try {
            store.delete(contentUrl);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            logger.warn((Object)("Store test testDeleteSimple not possible on " + store.getClass().getName()));
            return;
        }
        Assert.assertFalse((String)"Content must now be removed", (boolean)store.exists(contentUrl));
    }

    @Test
    public void testDeleteReaderStates() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = this.getWriter();
        String content = "Content for testDeleteReaderStates";
        String contentUrl = writer.getContentUrl();
        OutputStream os = writer.getContentOutputStream();
        os.write(content.getBytes());
        os.flush();
        os.close();
        ContentReader reader = store.getReader(contentUrl);
        Assert.assertNotNull((Object)reader);
        ContentReader readerCheck = writer.getReader();
        Assert.assertNotNull((Object)readerCheck);
        Assert.assertEquals((String)"Store and write provided readers onto different URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        InputStream is = reader.exists() ? reader.getContentInputStream() : null;
        boolean deleted = store.delete(contentUrl);
        if (is != null) {
            is.close();
        }
        reader = store.getReader(contentUrl);
        Assert.assertNotNull((Object)reader);
        if (deleted) {
            Assert.assertFalse((String)"Content should not exist", (boolean)reader.exists());
            return;
        }
        Assert.assertTrue((String)"Content should exist", (boolean)reader.exists());
        store.delete(contentUrl);
        try {
            is = reader.getContentInputStream();
            Assert.fail((String)"Reader failed to detect underlying content deletion");
        }
        catch (ContentIOException contentIOException) {}
        reader = store.getReader(contentUrl);
        Assert.assertNotNull((String)"Reader must be returned even when underlying content is missing", (Object)reader);
        Assert.assertFalse((String)"Content should not exist", (boolean)reader.exists());
        try {
            is = reader.getContentInputStream();
            Assert.fail((String)"Reader opened stream onto missing content");
        }
        catch (ContentIOException contentIOException) {}
    }

    @Test
    public void testWriteStreamListener() throws Exception {
        ContentWriter writer = this.getWriter();
        final boolean[] streamClosed = new boolean[1];
        ContentStreamListener listener = new ContentStreamListener(){

            public void contentStreamClosed() throws ContentIOException {
                streamClosed[0] = true;
            }
        };
        writer.addListener(listener);
        writer.putContent("ABC");
        Assert.assertTrue((String)"Write stream listener was not called for the stream close", (boolean)streamClosed[0]);
    }

    @Test
    public void testWriteAndReadString() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        writer.putContent(content);
        Assert.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        String check = reader.getContentString();
        Assert.assertTrue((String)"Read and write may not share same resource", (check.length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Write and read didn't work", (Object)content, (Object)check);
    }

    @Test
    public void testStringTruncation() throws Exception {
        String content = "1234567890";
        ContentWriter writer = this.getWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        String checkContent = reader.getContentString(5);
        Assert.assertEquals((String)"Truncated strings don't match", (Object)"12345", (Object)checkContent);
    }

    @Test
    public void testReadAndWriteFile() throws Exception {
        ContentWriter writer = this.getWriter();
        File sourceFile = TempFileProvider.createTempFile((String)"testReadAndWriteFile", (String)".txt");
        sourceFile.deleteOnExit();
        String content = "ABC";
        FileOutputStream os = new FileOutputStream(sourceFile);
        os.write(content.getBytes());
        os.flush();
        os.close();
        writer.putContent(sourceFile);
        Assert.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        File sinkFile = TempFileProvider.createTempFile((String)"testReadAndWriteFile", (String)".txt");
        sinkFile.deleteOnExit();
        ContentReader reader = writer.getReader();
        reader.getContent(sinkFile);
        FileInputStream is = new FileInputStream(sinkFile);
        byte[] buffer = new byte[100];
        int count = is.read(buffer);
        Assert.assertEquals((String)"No content read", (long)3L, (long)count);
        is.close();
        String check = new String(buffer, 0, count);
        Assert.assertEquals((String)"Write out of and read into files failed", (Object)content, (Object)check);
    }

    @Test
    public void testReadAndWriteStreamByPull() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        writer.putContent((InputStream)is);
        Assert.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ByteArrayOutputStream os = new ByteArrayOutputStream(100);
        ContentReader reader = writer.getReader();
        reader.getContent((OutputStream)os);
        byte[] bytes = os.toByteArray();
        String check = new String(bytes);
        Assert.assertEquals((String)"Write out and read in using streams failed", (Object)content, (Object)check);
    }

    @Test
    public void testReadAndWriteStreamByPush() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "Some Random Content";
        OutputStream os = writer.getContentOutputStream();
        os.write(content.getBytes());
        Assert.assertFalse((String)"Stream has not been closed", (boolean)writer.isClosed());
        os.close();
        Assert.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        InputStream is = reader.getContentInputStream();
        byte[] buffer = new byte[100];
        int count = is.read(buffer);
        Assert.assertEquals((String)"No content read", (long)content.length(), (long)count);
        is.close();
        String check = new String(buffer, 0, count);
        Assert.assertEquals((String)"Write out of and read into files failed", (Object)content, (Object)check);
    }

    @Test
    public void testRandomAccessWrite() throws Exception {
        ContentWriter writer = this.getWriter();
        FileChannel fileChannel = writer.getFileChannel(true);
        Assert.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            writer.getWritableChannel();
            Assert.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException runtimeException) {}
        byte[] content = new byte[]{1, 2, 3};
        int i = content.length - 1;
        while (i >= 0) {
            ByteBuffer buffer = ByteBuffer.wrap(content, i, 1);
            fileChannel.write(buffer, i);
            --i;
        }
        fileChannel.close();
        Assert.assertTrue((String)"Writer not closed", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        ReadableByteChannel channelReader = reader.getReadableChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(3);
        int count = channelReader.read(buffer);
        Assert.assertEquals((String)"Incorrect number of bytes read", (long)3L, (long)count);
        int i2 = 0;
        while (i2 < content.length) {
            Assert.assertEquals((String)"Content doesn't match", (long)content[i2], (long)buffer.get(i2));
            ++i2;
        }
        ContentContext writerTruncateCtx = new ContentContext(writer.getReader(), null);
        ContentWriter writerTruncate = this.getStore().getWriter(writerTruncateCtx);
        Assert.assertEquals((String)"Content size incorrect", (long)0L, (long)writerTruncate.getSize());
        FileChannel fcTruncate = writerTruncate.getFileChannel(true);
        fcTruncate.close();
        Assert.assertEquals((String)"Content not truncated", (long)0L, (long)writerTruncate.getSize());
        ContentContext writerNoTruncateCtx = new ContentContext(writer.getReader(), null);
        ContentWriter writerNoTruncate = this.getStore().getWriter(writerNoTruncateCtx);
        Assert.assertEquals((String)"Content size incorrect", (long)0L, (long)writerNoTruncate.getSize());
        FileChannel fcNoTruncate = writerNoTruncate.getFileChannel(false);
        fcNoTruncate.close();
        Assert.assertEquals((String)"Content was truncated", (long)writer.getSize(), (long)writerNoTruncate.getSize());
    }

    @Override
    @Test
    public void testRandomAccessRead() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        byte[] bytes = content.getBytes();
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        FileChannel fileChannel = reader.getFileChannel();
        Assert.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            reader.getReadableChannel();
            Assert.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException runtimeException) {}
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        int count = fileChannel.read(buffer);
        Assert.assertEquals((String)"Incorrect number of bytes read", (long)bytes.length, (long)count);
        ((Buffer)buffer).rewind();
        buffer.get(bytes);
        String checkContent = new String(bytes);
        Assert.assertEquals((String)"Content read failure", (Object)content, (Object)checkContent);
        fileChannel.close();
    }
}

