/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.Properties;
import org.alfresco.repo.cache.DefaultCacheFactory;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultCacheFactoryTest {
    private DefaultCacheFactory<String, String> cacheFactory;
    private Properties properties;
    private DefaultSimpleCache<String, String> cache;

    @Before
    public void setUp() throws Exception {
        this.cacheFactory = new DefaultCacheFactory();
        this.properties = new Properties();
        this.properties.setProperty("cache.someCache.maxItems", "4");
        this.properties.setProperty("cache.someCache.eviction-policy", "EVICT");
        this.properties.setProperty("cache.noSizeLimit.maxItems", "2");
        this.properties.setProperty("cache.noSizeLimit.eviction-policy", "NONE");
        this.properties.setProperty("cache.withTTL.maxItems", "0");
        this.properties.setProperty("cache.withTTL.eviction-policy", "NONE");
        this.properties.setProperty("cache.withTTL.timeToLiveSeconds", "6");
        this.properties.setProperty("cache.withMaxIdle.maxItems", "0");
        this.properties.setProperty("cache.withMaxIdle.eviction-policy", "NONE");
        this.properties.setProperty("cache.withMaxIdle.maxIdleSeconds", "7");
        this.cacheFactory.setProperties(this.properties);
    }

    @Test
    public void canCreateCache() {
        this.cache = (DefaultSimpleCache)this.cacheFactory.createCache("cache.someCache");
        Assert.assertEquals((long)4L, (long)this.cache.getMaxItems());
        Assert.assertEquals((Object)"cache.someCache", (Object)this.cache.getCacheName());
        Assert.assertTrue((boolean)this.cache.isUseMaxItems());
    }

    @Test
    public void canCreateUnboundedCache() {
        this.cache = (DefaultSimpleCache)this.cacheFactory.createCache("cache.noSizeLimit");
        Assert.assertEquals((long)2L, (long)this.cache.getMaxItems());
        Assert.assertEquals((Object)"cache.noSizeLimit", (Object)this.cache.getCacheName());
        Assert.assertFalse((boolean)this.cache.isUseMaxItems());
    }

    @Test
    public void canCreateCacheWithTTL() {
        this.cache = (DefaultSimpleCache)this.cacheFactory.createCache("cache.withTTL");
        Assert.assertEquals((Object)"cache.withTTL", (Object)this.cache.getCacheName());
        Assert.assertEquals((long)6L, (long)this.cache.getTTLSecs());
    }

    @Test
    public void canCreateCacheWithMaxIdle() {
        this.cache = (DefaultSimpleCache)this.cacheFactory.createCache("cache.withMaxIdle");
        Assert.assertEquals((Object)"cache.withMaxIdle", (Object)this.cache.getCacheName());
        Assert.assertEquals((long)0L, (long)this.cache.getTTLSecs());
        Assert.assertEquals((long)7L, (long)this.cache.getMaxIdleSecs());
    }
}

