/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.HasTagEvaluator;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Category(value={NeverRunsTests.class})
public class HasTagEvaluatorTest
extends BaseSpringTest {
    private NodeService nodeService;
    private TaggingService taggingService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private HasTagEvaluator evaluator;
    private static final String ID = GUID.generate();

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.taggingService = (TaggingService)this.applicationContext.getBean("taggingService");
        this.testStoreRef = new StoreRef("workspace", "SpacesStore");
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.evaluator = (HasTagEvaluator)this.applicationContext.getBean("has-tag");
        AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
    }

    public void testPass() {
        this.taggingService.addTag(this.nodeRef, "testTag");
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-tag", null);
        condition.setParameterValue("tag", (Serializable)((Object)"testTag"));
        boolean value = this.evaluator.evaluate((ActionCondition)condition, this.nodeRef);
        HasTagEvaluatorTest.assertTrue((String)"Tag should have been set", (boolean)value);
    }

    public void testFail() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-tag", null);
        condition.setParameterValue("tag", (Serializable)((Object)"testTag"));
        boolean value = this.evaluator.evaluate((ActionCondition)condition, this.nodeRef);
        HasTagEvaluatorTest.assertFalse((boolean)value);
    }
}

