/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ResourceFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigSource;

public class ResourceFinderConfigSource
implements ConfigSource {
    private static Log logger = LogFactory.getLog(ResourceFinderConfigSource.class);
    private ResourceFinder resourceFinder;
    private List<String> locations;

    public void setResourceFinder(ResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public List<ConfigDeployment> getConfigDeployments() {
        Resource[] resources;
        ArrayList<ConfigDeployment> configs = new ArrayList<ConfigDeployment>();
        String[] locs = this.locations.toArray(new String[this.locations.size()]);
        try {
            resources = this.resourceFinder.getResources(locs);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to find resources", (Throwable)e);
        }
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            try {
                configs.add(new ConfigDeployment(resource.getDescription(), resource.getInputStream()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loaded resource " + String.valueOf(resource)));
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Skipping unreadable resource " + String.valueOf(resource)), (Throwable)e);
            }
            ++n2;
        }
        return configs;
    }
}

