/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.StoreRef;

public class StoreArchiveMap {
    private Map<StoreRef, StoreRef> storeArchiveMap = new HashMap<StoreRef, StoreRef>(0);
    private TenantService tenantService;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setArchiveMap(Map<String, String> archiveMap) {
        for (Map.Entry<String, String> entry : archiveMap.entrySet()) {
            String storeRefKeyStr = entry.getKey();
            String storeRefValueStr = entry.getValue();
            StoreRef storeRefKey = null;
            StoreRef storeRefValue = null;
            try {
                storeRefKey = new StoreRef(storeRefKeyStr);
                storeRefValue = new StoreRef(storeRefValueStr);
            }
            catch (Throwable throwable) {
                throw new AlfrescoRuntimeException("Unable create store references from map entry: " + String.valueOf(entry));
            }
            this.storeArchiveMap.put(storeRefKey, storeRefValue);
        }
    }

    public StoreRef get(StoreRef storeRef) {
        if (this.tenantService.isEnabled()) {
            return this.tenantService.getName(this.storeArchiveMap.get(this.tenantService.getBaseName(storeRef)));
        }
        return this.storeArchiveMap.get(storeRef);
    }

    public void put(StoreRef workStoreRef, StoreRef archiveStoreRef) {
        this.storeArchiveMap.put(workStoreRef, archiveStoreRef);
    }

    public void clear() {
        this.storeArchiveMap.clear();
    }
}

