/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.alfresco.repo.activities.feed.AbstractFeedGenerator;
import org.alfresco.repo.activities.feed.FeedTaskProcessor;
import org.alfresco.repo.activities.feed.JobSettings;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFeedGenerator
extends AbstractFeedGenerator {
    private static Log logger = LogFactory.getLog(LocalFeedGenerator.class);
    private FeedTaskProcessor feedTaskProcessor;
    private int batchSize = 1000;
    private int numThreads = 4;

    public void setFeedTaskProcessor(FeedTaskProcessor feedTaskProcessor) {
        this.feedTaskProcessor = feedTaskProcessor;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getEstimatedGridSize() {
        return 1;
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    protected boolean generate() throws Exception {
        final Long maxSequence = this.getPostDaoService().getMaxActivitySeq();
        final Long minSequence = this.getPostDaoService().getMinActivitySeq();
        final Integer maxNodeHash = this.getPostDaoService().getMaxNodeHash();
        if (maxSequence == null || minSequence == null || maxNodeHash == null) {
            return false;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                LocalFeedGenerator.this.getWebScriptsCtx().setTicket(LocalFeedGenerator.this.getAuthenticationService().getCurrentTicket());
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        BatchProcessor.BatchProcessWorker<JobSettings> worker = new BatchProcessor.BatchProcessWorker<JobSettings>(){

            @Override
            public String getIdentifier(JobSettings js) {
                StringBuilder sb = new StringBuilder("JobSettings ");
                sb.append(js);
                return sb.toString();
            }

            @Override
            public void beforeProcess() throws Throwable {
            }

            @Override
            public void afterProcess() throws Throwable {
            }

            @Override
            public void process(final JobSettings js) throws Throwable {
                RetryingTransactionHelper txHelper = LocalFeedGenerator.this.getTransactionService().getRetryingTransactionHelper();
                txHelper.setMaxRetries(0);
                txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        int jobTaskNode = js.getJobTaskNode();
                        long minSeq = js.getMinSeq();
                        long maxSeq = js.getMaxSeq();
                        RepoCtx webScriptsCtx = js.getWebScriptsCtx();
                        (this).LocalFeedGenerator.this.feedTaskProcessor.process(jobTaskNode, minSeq, maxSeq, webScriptsCtx);
                        return null;
                    }
                }, false, true);
            }
        };
        BatchProcessWorkProvider<JobSettings> provider = new BatchProcessWorkProvider<JobSettings>(){
            private Long skip;
            private boolean hasMore;
            {
                this.skip = l;
                this.hasMore = true;
            }

            @Override
            public int getTotalEstimatedWorkSize() {
                return (int)this.calculateEstimatedWorkSize();
            }

            @Override
            public long getTotalEstimatedWorkSizeLong() {
                return this.calculateEstimatedWorkSize();
            }

            private long calculateEstimatedWorkSize() {
                long size = maxSequence - minSequence + 1L;
                long remain = size % (long)LocalFeedGenerator.this.batchSize;
                long workSize = remain == 0L ? size / (long)LocalFeedGenerator.this.batchSize : size / (long)LocalFeedGenerator.this.batchSize + 1L;
                return workSize;
            }

            @Override
            public Collection<JobSettings> getNextWork() {
                if (!this.hasMore) {
                    return Collections.emptyList();
                }
                JobSettings js = new JobSettings();
                js.setMinSeq(this.skip);
                js.setMaxSeq(this.skip + (long)LocalFeedGenerator.this.batchSize - 1L);
                js.setJobTaskNode(maxNodeHash);
                js.setWebScriptsCtx(LocalFeedGenerator.this.getWebScriptsCtx());
                this.skip = this.skip + (long)LocalFeedGenerator.this.batchSize;
                this.hasMore = this.skip <= maxSequence;
                ArrayList<JobSettings> result = new ArrayList<JobSettings>(1);
                result.add(js);
                return result;
            }
        };
        RetryingTransactionHelper txHelper = this.getTransactionService().getRetryingTransactionHelper();
        txHelper.setMaxRetries(0);
        new BatchProcessor<JobSettings>("LocalFeedGenerator", txHelper, provider, this.numThreads, 1, null, logger, 1).process(worker, true);
        return true;
    }
}

